/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.dimap;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.esa.beam.dataio.dimap.DimapProductHelpers;
import org.esa.beam.dataio.geometry.VectorDataNodeReader;
import org.esa.beam.framework.dataio.AbstractProductReader;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.BasicPixelGeoCoding;
import org.esa.beam.framework.datamodel.FilterBand;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoCodingFactory;
import org.esa.beam.framework.datamodel.GeometryDescriptor;
import org.esa.beam.framework.datamodel.PlacemarkDescriptor;
import org.esa.beam.framework.datamodel.PlacemarkDescriptorRegistry;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.ProductNodeGroup;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.datamodel.VectorDataNode;
import org.esa.beam.framework.datamodel.VirtualBand;
import org.esa.beam.jai.ImageManager;
import org.esa.beam.util.Debug;
import org.esa.beam.util.FeatureUtils;
import org.esa.beam.util.io.FileUtils;
import org.esa.beam.util.logging.BeamLogManager;
import org.jdom.Document;
import org.jdom.input.DOMBuilder;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DimapProductReader
extends AbstractProductReader {
    private Product product;
    private File inputDir;
    private File inputFile;
    private Map<Band, ImageInputStream> bandInputStreams;
    private int sourceRasterWidth;
    private int sourceRasterHeight;
    private Map<Band, File> bandDataFiles;
    private Set<ReaderExtender> readerExtenders;

    public DimapProductReader(ProductReaderPlugIn readerPlugIn) {
        super(readerPlugIn);
    }

    public Product getProduct() {
        return this.product;
    }

    public File getInputDir() {
        return this.inputDir;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public int getSourceRasterWidth() {
        return this.sourceRasterWidth;
    }

    public int getSourceRasterHeight() {
        return this.sourceRasterHeight;
    }

    @Override
    protected Product readProductNodesImpl() throws IOException {
        Product product = this.processProduct(null);
        if (this.readerExtenders != null) {
            for (ReaderExtender readerExtender : this.readerExtenders) {
                readerExtender.completeProductNodesReading(product);
            }
        }
        return product;
    }

    public void bindProduct(Object input, Product existingProduct) throws IOException {
        Assert.notNull(input, "input");
        Assert.notNull(existingProduct, "existingProduct");
        this.setInput(input);
        this.processProduct(existingProduct);
    }

    protected Product processProduct(Product existingProduct) throws IOException {
        this.initInput();
        Document dom = this.readDom();
        this.product = existingProduct == null ? DimapProductHelpers.createProduct(dom) : existingProduct;
        this.product.setProductReader(this);
        if (existingProduct == null) {
            this.readTiePointGrids(dom);
        }
        this.sourceRasterWidth = this.product.getSceneRasterWidth();
        this.sourceRasterHeight = this.product.getSceneRasterHeight();
        this.bindBandsToFiles(dom);
        if (existingProduct == null) {
            this.readVectorData(ImageManager.DEFAULT_IMAGE_CRS, true);
            DimapProductHelpers.addGcps(dom, this.product);
            DimapProductHelpers.addPins(dom, this.product);
            this.initGeoCodings(dom);
            this.readVectorData(ImageManager.getModelCrs(this.product.getGeoCoding()), false);
            DimapProductHelpers.addMaskUsages(dom, this.product);
        }
        this.product.setProductReader(this);
        this.product.setFileLocation(this.inputFile);
        this.product.setModified(false);
        return this.product;
    }

    private void initGeoCodings(Document dom) {
        GeoCoding[] geoCodings = DimapProductHelpers.createGeoCoding(dom, this.product);
        if (geoCodings != null) {
            if (geoCodings.length == 1) {
                this.product.setGeoCoding(geoCodings[0]);
            } else {
                int i = 0;
                while (i < geoCodings.length) {
                    this.product.getBandAt(i).setGeoCoding(geoCodings[i]);
                    ++i;
                }
            }
        } else {
            Band lonBand = this.product.getBand("longitude");
            Band latBand = this.product.getBand("latitude");
            if (latBand != null && lonBand != null) {
                BasicPixelGeoCoding geoCoding = GeoCodingFactory.createPixelGeoCoding(latBand, lonBand, null, 6);
                this.product.setGeoCoding(geoCoding);
            }
        }
    }

    private void bindBandsToFiles(Document dom) {
        Band[] bands;
        this.bandDataFiles = DimapProductHelpers.getBandDataFiles(dom, this.product, this.getInputDir());
        Band[] bandArray = bands = this.product.getBands();
        int n = bands.length;
        int n2 = 0;
        while (n2 < n) {
            File dataFile;
            Band band = bandArray[n2];
            if (!(band instanceof VirtualBand || band instanceof FilterBand || (dataFile = this.bandDataFiles.get(band)) != null && dataFile.canRead())) {
                BeamLogManager.getSystemLogger().warning("DimapProductReader: Unable to read file '" + dataFile + "' referenced by '" + band.getName() + "'.");
                BeamLogManager.getSystemLogger().warning("DimapProductReader: Removed band '" + band.getName() + "' from product '" + this.product.getFileLocation() + "'.");
            }
            ++n2;
        }
    }

    private void readTiePointGrids(Document jDomDocument) throws IOException {
        String[] tiePointGridNames;
        String[] stringArray = tiePointGridNames = this.product.getTiePointGridNames();
        int n = tiePointGridNames.length;
        int n2 = 0;
        while (n2 < n) {
            String tiePointGridName = stringArray[n2];
            TiePointGrid tiePointGrid = this.product.getTiePointGrid(tiePointGridName);
            String dataFile = DimapProductHelpers.getTiePointDataFile(jDomDocument, tiePointGrid.getName());
            dataFile = FileUtils.exchangeExtension(dataFile, ".img");
            try (FileImageInputStream inputStream = null;){
                try {
                    inputStream = new FileImageInputStream(new File(this.inputDir, dataFile));
                    float[] floats = (float[])tiePointGrid.getData().getElems();
                    inputStream.seek(0L);
                    inputStream.readFully(floats, 0, floats.length);
                    inputStream.close();
                    inputStream = null;
                    if (tiePointGrid.getDiscontinuity() != TiePointGrid.DISCONT_NONE) {
                        tiePointGrid.setDiscontinuity(TiePointGrid.getDiscontinuity(floats));
                    }
                }
                catch (IOException e) {
                    throw new IOException(MessageFormat.format("I/O error while reading tie-point grid ''{0}''.", tiePointGridName), e);
                }
            }
            ++n2;
        }
    }

    private Document readDom() throws IOException {
        Document dom;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Debug.trace("DimapProductReader: about to open file '" + this.inputFile + "'...");
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.inputFile), 262144);
            dom = new DOMBuilder().build(builder.parse(is));
            ((InputStream)is).close();
        }
        catch (Exception e) {
            throw new IOException("Failed to read DIMAP XML header.", e);
        }
        return dom;
    }

    private void initInput() throws IOException {
        if (this.getInput() instanceof String) {
            this.inputFile = new File((String)this.getInput());
        } else if (this.getInput() instanceof File) {
            this.inputFile = (File)this.getInput();
        } else {
            throw new IllegalArgumentException("unsupported input source: " + this.getInput());
        }
        Debug.assertNotNull(this.inputFile);
        this.inputDir = this.inputFile.getParentFile();
        if (this.inputDir == null) {
            this.inputDir = new File(".");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        int sourceMinX = sourceOffsetX;
        int sourceMinY = sourceOffsetY;
        int sourceMaxX = sourceOffsetX + sourceWidth - 1;
        int sourceMaxY = sourceOffsetY + sourceHeight - 1;
        File dataFile = this.bandDataFiles.get(destBand);
        ImageInputStream inputStream = this.getOrCreateImageInputStream(destBand, dataFile);
        if (inputStream == null) {
            return;
        }
        int destPos = 0;
        pm.beginTask("Reading band '" + destBand.getName() + "'...", sourceMaxY - sourceMinY);
        try {
            ImageInputStream imageInputStream = inputStream;
            synchronized (imageInputStream) {
                int sourceY = sourceMinY;
                while (sourceY <= sourceMaxY) {
                    if (pm.isCanceled()) break;
                    long sourcePosY = (long)sourceY * (long)this.sourceRasterWidth;
                    if (sourceStepX == 1) {
                        long inputPos = sourcePosY + (long)sourceMinX;
                        destBuffer.readFrom(destPos, destWidth, inputStream, inputPos);
                        destPos += destWidth;
                    } else {
                        int sourceX = sourceMinX;
                        while (sourceX <= sourceMaxX) {
                            long inputPos = sourcePosY + (long)sourceX;
                            destBuffer.readFrom(destPos, 1, inputStream, inputPos);
                            ++destPos;
                            sourceX += sourceStepX;
                        }
                    }
                    sourceY += sourceStepY;
                }
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.bandInputStreams == null) {
            return;
        }
        for (ImageInputStream imageInputStream : this.bandInputStreams.values()) {
            imageInputStream.close();
        }
        this.bandInputStreams.clear();
        this.bandInputStreams = null;
        if (this.readerExtenders != null) {
            this.readerExtenders.clear();
            this.readerExtenders = null;
        }
        super.close();
    }

    private ImageInputStream getOrCreateImageInputStream(Band band, File file) throws IOException {
        ImageInputStream inputStream = this.getImageInputStream(band);
        if (inputStream == null) {
            try {
                inputStream = new FileImageInputStream(file);
            }
            catch (IOException e) {
                BeamLogManager.getSystemLogger().log(Level.WARNING, "DimapProductReader: Unable to read file '" + file + "' referenced by '" + band.getName() + "'.", e);
            }
            if (inputStream == null) {
                return null;
            }
            if (this.bandInputStreams == null) {
                this.bandInputStreams = new Hashtable<Band, ImageInputStream>();
            }
            this.bandInputStreams.put(band, inputStream);
        }
        return inputStream;
    }

    private ImageInputStream getImageInputStream(Band band) {
        if (this.bandInputStreams != null) {
            return this.bandInputStreams.get(band);
        }
        return null;
    }

    private void readVectorData(CoordinateReferenceSystem modelCrs, boolean onlyGCPs) throws IOException {
        String dataDirName = String.valueOf(FileUtils.getFilenameWithoutExtension(this.inputFile)) + ".data";
        File dataDir = new File(this.inputDir, dataDirName);
        File vectorDataDir = new File(dataDir, "vector_data");
        if (vectorDataDir.exists()) {
            File[] vectorFiles;
            File[] fileArray = vectorFiles = this.getVectorDataFiles(vectorDataDir, onlyGCPs);
            int n = vectorFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File vectorFile = fileArray[n2];
                this.addVectorDataToProduct(vectorFile, modelCrs);
                ++n2;
            }
        }
    }

    private void addVectorDataToProduct(File vectorFile, final CoordinateReferenceSystem modelCrs) throws IOException {
        try (FileReader reader = null;){
            try {
                reader = new FileReader(vectorFile);
                FeatureUtils.FeatureCrsProvider crsProvider = new FeatureUtils.FeatureCrsProvider(){

                    @Override
                    public CoordinateReferenceSystem getFeatureCrs(Product product) {
                        return modelCrs;
                    }
                };
                OptimalPlacemarkDescriptorProvider descriptorProvider = new OptimalPlacemarkDescriptorProvider();
                VectorDataNode vectorDataNode = VectorDataNodeReader.read(vectorFile.getName(), reader, this.product, crsProvider, descriptorProvider, modelCrs, '\t', ProgressMonitor.NULL);
                if (vectorDataNode != null) {
                    ProductNodeGroup<VectorDataNode> vectorDataGroup = this.product.getVectorDataGroup();
                    VectorDataNode existing = vectorDataGroup.get(vectorDataNode.getName());
                    if (existing != null) {
                        vectorDataGroup.remove(existing);
                    }
                    vectorDataGroup.add(vectorDataNode);
                }
            }
            catch (IOException e) {
                BeamLogManager.getSystemLogger().log(Level.SEVERE, "Error reading '" + vectorFile + "'", e);
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    private File[] getVectorDataFiles(File vectorDataDir, final boolean onlyGCPs) {
        return vectorDataDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name.endsWith(".csv")) {
                    if (onlyGCPs) {
                        return name.equals("ground_control_points.csv");
                    }
                    return true;
                }
                return false;
            }
        });
    }

    public void addExtender(ReaderExtender extender) {
        if (extender == null) {
            return;
        }
        if (this.readerExtenders == null) {
            this.readerExtenders = new HashSet<ReaderExtender>();
        }
        this.readerExtenders.add(extender);
    }

    private static class OptimalPlacemarkDescriptorProvider
    implements VectorDataNodeReader.PlacemarkDescriptorProvider {
        private OptimalPlacemarkDescriptorProvider() {
        }

        @Override
        public PlacemarkDescriptor getPlacemarkDescriptor(SimpleFeatureType simpleFeatureType) {
            String placemarkDescriptorClass;
            PlacemarkDescriptor placemarkDescriptor;
            PlacemarkDescriptorRegistry placemarkDescriptorRegistry = PlacemarkDescriptorRegistry.getInstance();
            if (simpleFeatureType.getUserData().containsKey("placemarkDescriptor") && (placemarkDescriptor = placemarkDescriptorRegistry.getPlacemarkDescriptor(placemarkDescriptorClass = simpleFeatureType.getUserData().get("placemarkDescriptor").toString())) != null) {
                return placemarkDescriptor;
            }
            PlacemarkDescriptor placemarkDescriptor2 = placemarkDescriptorRegistry.getPlacemarkDescriptor(simpleFeatureType);
            if (placemarkDescriptor2 != null) {
                return placemarkDescriptor2;
            }
            return placemarkDescriptorRegistry.getPlacemarkDescriptor(GeometryDescriptor.class);
        }
    }

    public static abstract class ReaderExtender {
        public abstract void completeProductNodesReading(Product var1);
    }
}

