/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam;

import com.bc.ceres.core.CoreException;
import com.bc.ceres.core.ServiceRegistry;
import com.bc.ceres.core.ServiceRegistryManager;
import com.bc.ceres.core.runtime.Activator;
import com.bc.ceres.core.runtime.ConfigurationElement;
import com.bc.ceres.core.runtime.Extension;
import com.bc.ceres.core.runtime.ExtensionPoint;
import com.bc.ceres.core.runtime.Module;
import com.bc.ceres.core.runtime.ModuleContext;
import com.bc.ceres.core.runtime.ModuleState;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.esa.beam.framework.datamodel.RGBImageProfile;
import org.esa.beam.framework.datamodel.RGBImageProfileManager;
import org.esa.beam.util.SystemUtils;
import org.esa.beam.util.logging.BeamLogManager;
import org.geotools.factory.FactoryIteratorProvider;
import org.geotools.factory.GeoTools;
import org.geotools.referencing.operation.MathTransformProvider;

public class BeamCoreActivator
implements Activator {
    private static ModuleContext moduleContext;
    private FactoryIteratorProvider geotoolsFactoryIteratorProvider;

    public static boolean isStarted() {
        return moduleContext != null;
    }

    public static <T> void loadServices(ServiceRegistry<T> registry) {
        Iterable<T> iterable = SystemUtils.loadServices(registry.getServiceType());
        Iterator<T> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            try {
                registry.addService(iterator.next());
            }
            catch (ServiceConfigurationError e) {
                Logger logger = moduleContext != null ? moduleContext.getLogger() : BeamLogManager.getSystemLogger();
                logger.log(Level.WARNING, e.getMessage(), e.getCause());
            }
        }
    }

    @Override
    public void start(ModuleContext moduleContext) throws CoreException {
        BeamCoreActivator.moduleContext = moduleContext;
        SystemUtils.init3rdPartyLibs(moduleContext.getModule().getClassLoader());
        BeamCoreActivator.registerRGBProfiles(moduleContext);
        this.registerGeotoolsServices();
    }

    @Override
    public void stop(ModuleContext moduleContext) throws CoreException {
        BeamCoreActivator.moduleContext = null;
        this.deregisterGeotoolsServices();
    }

    private void registerGeotoolsServices() {
        ServiceRegistry<MathTransformProvider> serviceRegistry = ServiceRegistryManager.getInstance().getServiceRegistry(MathTransformProvider.class);
        BeamCoreActivator.loadServices(serviceRegistry);
        this.geotoolsFactoryIteratorProvider = new GeotoolsFactoryIteratorProvider(serviceRegistry);
        GeoTools.addFactoryIteratorProvider(this.geotoolsFactoryIteratorProvider);
    }

    private void deregisterGeotoolsServices() {
        if (this.geotoolsFactoryIteratorProvider != null) {
            GeoTools.removeFactoryIteratorProvider(this.geotoolsFactoryIteratorProvider);
        }
    }

    private static void registerRGBProfiles(ModuleContext moduleContext) throws CoreException {
        ExtensionPoint rgbExtensionPoint = moduleContext.getModule().getExtensionPoint("rgbProfiles");
        Extension[] rgbExtensions = rgbExtensionPoint.getExtensions();
        RGBImageProfileManager profileManager = RGBImageProfileManager.getInstance();
        Extension[] extensionArray = rgbExtensions;
        int n = rgbExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigurationElement[] rgbElements;
            Extension extension = extensionArray[n2];
            ConfigurationElement confElem = extension.getConfigurationElement();
            ConfigurationElement[] configurationElementArray = rgbElements = (ConfigurationElement[])confElem.getChildren("rgbProfile");
            int n3 = rgbElements.length;
            int n4 = 0;
            while (n4 < n3) {
                ConfigurationElement rgbElement = configurationElementArray[n4];
                RGBImageProfile rgbImageProfile = new RGBImageProfile();
                rgbImageProfile.configure(rgbElement);
                profileManager.addProfile(rgbImageProfile);
                ++n4;
            }
            ++n2;
        }
    }

    public static <T> List<T> loadExecutableExtensions(ModuleContext moduleContext, String extensionPointId, String elementName, Class<T> extensionType) {
        Module module = moduleContext.getModule();
        ExtensionPoint extensionPoint = module.getExtensionPoint(extensionPointId);
        ConfigurationElement[] configurationElements = extensionPoint.getConfigurationElements();
        ArrayList<T> executableExtensions = new ArrayList<T>(32);
        ConfigurationElement[] configurationElementArray = configurationElements;
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigurationElement[] children;
            ConfigurationElement configurationElement = configurationElementArray[n2];
            ConfigurationElement[] configurationElementArray2 = children = (ConfigurationElement[])configurationElement.getChildren(elementName);
            int n3 = children.length;
            int n4 = 0;
            while (n4 < n3) {
                ConfigurationElement child = configurationElementArray2[n4];
                try {
                    ModuleState moduleState = child.getDeclaringExtension().getDeclaringModule().getState();
                    if (moduleState.isOneOf(ModuleState.STARTING, ModuleState.RESOLVED)) {
                        T executableExtension = child.createExecutableExtension(extensionType);
                        executableExtensions.add(executableExtension);
                    }
                }
                catch (CoreException e) {
                    moduleContext.getLogger().log(Level.SEVERE, e.getMessage(), e);
                }
                ++n4;
            }
            ++n2;
        }
        return executableExtensions;
    }

    private static final class GeotoolsFactoryIteratorProvider
    implements FactoryIteratorProvider {
        private final ServiceRegistry<MathTransformProvider> serviceRegistry;

        private GeotoolsFactoryIteratorProvider(ServiceRegistry<MathTransformProvider> serviceRegistry) {
            this.serviceRegistry = serviceRegistry;
        }

        @Override
        public <T> Iterator<T> iterator(Class<T> category) {
            if (category.equals(this.serviceRegistry.getServiceType())) {
                return this.serviceRegistry.getServices().iterator();
            }
            return null;
        }
    }
}

