/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.glevel.support;

import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.RenderedImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ConstantDescriptor;
import javax.media.jai.operator.ScaleDescriptor;

public abstract class AbstractMultiLevelSource
implements MultiLevelSource {
    private final MultiLevelModel multiLevelModel;
    private final RenderedImage[] levelImages;

    protected AbstractMultiLevelSource(MultiLevelModel multiLevelModel) {
        this.multiLevelModel = multiLevelModel;
        this.levelImages = new RenderedImage[multiLevelModel.getLevelCount()];
    }

    @Override
    public MultiLevelModel getModel() {
        return this.multiLevelModel;
    }

    @Override
    public synchronized RenderedImage getImage(int level) {
        this.checkLevel(level);
        RenderedImage levelImage = this.levelImages[level];
        if (levelImage == null) {
            this.levelImages[level] = levelImage = this.createImage(level);
        }
        return levelImage;
    }

    @Override
    public Shape getImageShape(int level) {
        return null;
    }

    protected abstract RenderedImage createImage(int var1);

    @Override
    public synchronized void reset() {
        int level = 0;
        while (level < this.levelImages.length) {
            RenderedImage levelImage = this.levelImages[level];
            if (levelImage instanceof PlanarImage) {
                PlanarImage planarImage = (PlanarImage)levelImage;
                planarImage.dispose();
            }
            this.levelImages[level] = null;
            ++level;
        }
    }

    protected synchronized void checkLevel(int level) {
        if (level < 0 || level >= this.getModel().getLevelCount()) {
            throw new IllegalArgumentException("level=" + level);
        }
    }

    @Deprecated
    public static Dimension getImageDimension(int width, int height, double scale) {
        float scaleFactor = (float)(1.0 / scale);
        RenderedOp c = ConstantDescriptor.create(Float.valueOf(width), Float.valueOf(height), new Float[]{Float.valueOf(0.0f)}, null);
        RenderedOp s = ScaleDescriptor.create(c, Float.valueOf(scaleFactor), Float.valueOf(scaleFactor), Float.valueOf(0.0f), Float.valueOf(0.0f), null, null);
        return new Dimension(s.getWidth(), s.getHeight());
    }

    @Deprecated
    public static Rectangle getImageRectangle(int minX, int minY, int width, int height, double scale) {
        float scaleFactor = (float)(1.0 / scale);
        RenderedOp c = ConstantDescriptor.create(Float.valueOf(width), Float.valueOf(height), new Float[]{Float.valueOf(0.0f)}, null);
        RenderedOp s1 = ScaleDescriptor.create(c, Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(minX), Float.valueOf(minY), null, null);
        RenderedOp s2 = ScaleDescriptor.create(s1, Float.valueOf(scaleFactor), Float.valueOf(scaleFactor), Float.valueOf(0.0f), Float.valueOf(0.0f), null, null);
        return new Rectangle(s2.getMinX(), s2.getMinY(), s2.getWidth(), s2.getHeight());
    }
}

