/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.glayer.support;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.core.Assert;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerContext;
import com.bc.ceres.glayer.LayerType;
import com.bc.ceres.glayer.LayerTypeRegistry;
import com.bc.ceres.glayer.annotations.LayerTypeMetadata;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelRenderer;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.ConcurrentMultiLevelRenderer;
import com.bc.ceres.glevel.support.DefaultMultiLevelModel;
import com.bc.ceres.glevel.support.DefaultMultiLevelRenderer;
import com.bc.ceres.glevel.support.DefaultMultiLevelSource;
import com.bc.ceres.grender.InteractiveRendering;
import com.bc.ceres.grender.Rendering;
import com.bc.ceres.grender.Viewport;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;

public class ImageLayer
extends Layer {
    private static final Type LAYER_TYPE = LayerTypeRegistry.getLayerType(Type.class);
    public static final String PROPERTY_NAME_MULTI_LEVEL_SOURCE = "multiLevelSource";
    public static final String PROPERTY_NAME_BORDER_SHOWN = "borderShown";
    public static final String PROPERTY_NAME_BORDER_WIDTH = "borderWidth";
    public static final String PROPERTY_NAME_BORDER_COLOR = "borderColor";
    public static final String PROPERTY_NAME_PIXEL_BORDER_SHOWN = "pixelBorderShown";
    public static final String PROPERTY_NAME_PIXEL_BORDER_WIDTH = "pixelBorderWidth";
    public static final String PROPERTY_NAME_PIXEL_BORDER_COLOR = "pixelBorderColor";
    public static final boolean DEFAULT_BORDER_SHOWN = false;
    public static final Color DEFAULT_BORDER_COLOR = new Color(204, 204, 255);
    public static final double DEFAULT_BORDER_WIDTH = 1.0;
    public static final Boolean DEFAULT_PIXEL_BORDER_SHOWN = true;
    public static final Color DEFAULT_PIXEL_BORDER_COLOR = new Color(255, 255, 204);
    public static final double DEFAULT_PIXEL_BORDER_WIDTH = 0.0;
    private static final double MIN_PIXEL_SIZE_IN_VIEW = 16.0;
    @Deprecated
    private static final String PROPERTY_NAME_IMAGE_TO_MODEL_TRANSFORM = "imageToModelTransform";
    private MultiLevelSource multiLevelSource;
    private MultiLevelRenderer multiLevelRenderer;

    public ImageLayer(RenderedImage image) {
        this(image, new AffineTransform(), 1);
    }

    public ImageLayer(RenderedImage image, AffineTransform imageToModelTransform, int levelCount) {
        this(new DefaultMultiLevelSource(image, new DefaultMultiLevelModel(levelCount, imageToModelTransform, DefaultMultiLevelModel.getModelBounds(imageToModelTransform, image))));
    }

    public ImageLayer(MultiLevelSource multiLevelSource) {
        this(LAYER_TYPE, multiLevelSource, ImageLayer.initConfiguration(LAYER_TYPE.createLayerConfig(null), multiLevelSource));
    }

    public ImageLayer(Type layerType, MultiLevelSource multiLevelSource, PropertySet configuration) {
        super(layerType, configuration);
        Assert.notNull(multiLevelSource);
        this.multiLevelSource = multiLevelSource;
        this.setName("Image Layer");
    }

    @Override
    public void regenerate() {
        this.clearCaches();
        this.fireLayerDataChanged(this.getModelBounds());
    }

    public RenderedImage getImage() {
        return this.getImage(0);
    }

    public MultiLevelSource getMultiLevelSource() {
        return this.multiLevelSource;
    }

    public void setMultiLevelSource(MultiLevelSource multiLevelSource) {
        Assert.notNull(multiLevelSource);
        if (multiLevelSource != this.multiLevelSource) {
            Rectangle2D oldBounds = this.multiLevelSource.getModel().getModelBounds();
            Rectangle2D newBounds = multiLevelSource.getModel().getModelBounds();
            Rectangle2D region = oldBounds == null ? newBounds : (newBounds == null ? oldBounds : oldBounds.createUnion(newBounds));
            this.clearCaches();
            this.multiLevelSource = multiLevelSource;
            this.multiLevelRenderer = null;
            this.fireLayerDataChanged(region);
        }
    }

    public AffineTransform getImageToModelTransform() {
        return this.getImageToModelTransform(0);
    }

    public AffineTransform getModelToImageTransform() {
        return this.getModelToImageTransform(0);
    }

    public RenderedImage getImage(int level) {
        return this.multiLevelSource.getImage(level);
    }

    public AffineTransform getImageToModelTransform(int level) {
        return this.multiLevelSource.getModel().getImageToModelTransform(level);
    }

    public AffineTransform getModelToImageTransform(int level) {
        return this.multiLevelSource.getModel().getModelToImageTransform(level);
    }

    public int getLevel(Viewport vp) {
        return ImageLayer.getLevel(this.multiLevelSource.getModel(), vp);
    }

    public static int getLevel(MultiLevelModel model, Viewport vp) {
        AffineTransform i2m = model.getImageToModelTransform(0);
        double i2mScale = Math.sqrt(Math.abs(i2m.getDeterminant()));
        double m2vScale = 1.0 / vp.getZoomFactor();
        double scale = m2vScale / i2mScale;
        return model.getLevel(scale);
    }

    @Override
    protected Rectangle2D getLayerModelBounds() {
        return this.multiLevelSource.getModel().getModelBounds();
    }

    @Override
    protected void renderLayer(Rendering rendering) {
        if (this.multiLevelSource == MultiLevelSource.NULL) {
            return;
        }
        int level = this.getLevel(rendering.getViewport());
        MultiLevelRenderer renderer = this.getRenderer(rendering);
        renderer.renderImage(rendering, this.multiLevelSource, level);
        this.renderImageGridIndicators(rendering, level);
    }

    private void renderImageGridIndicators(Rendering rendering, int level) {
        boolean pixelBorderShown = level == 0 && this.isPixelBorderShown();
        boolean imageBorderShown = this.isBorderShown();
        if (!pixelBorderShown && !imageBorderShown) {
            return;
        }
        Graphics2D graphics2D = rendering.getGraphics();
        Object oldAntialiasing = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Paint oldPaint = graphics2D.getPaint();
        Stroke oldStroke = graphics2D.getStroke();
        try {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (pixelBorderShown) {
                this.drawPixelBorders(rendering, graphics2D);
            }
            if (imageBorderShown) {
                this.drawImageBorder(rendering, graphics2D, level);
            }
        }
        finally {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntialiasing);
            graphics2D.setPaint(oldPaint);
            graphics2D.setStroke(oldStroke);
        }
    }

    private void drawImageBorder(Rendering rendering, Graphics2D graphics2D, int level) {
        RenderedImage image = this.multiLevelSource.getImage(level);
        Viewport viewport = rendering.getViewport();
        AffineTransform i2m = this.multiLevelSource.getModel().getImageToModelTransform(level);
        AffineTransform m2v = viewport.getModelToViewTransform();
        Shape modelShape = i2m.createTransformedShape(new Rectangle(image.getMinX(), image.getMinY(), image.getWidth(), image.getHeight()));
        Shape viewShape = m2v.createTransformedShape(modelShape);
        graphics2D.setStroke(new BasicStroke((float)Math.max(0.0, this.getBorderWidth())));
        graphics2D.setColor(this.getBorderColor());
        graphics2D.draw(viewShape);
    }

    private void drawPixelBorders(Rendering rendering, Graphics2D graphics2D) {
        Viewport viewport = rendering.getViewport();
        AffineTransform m2i0 = this.multiLevelSource.getModel().getModelToImageTransform(0);
        AffineTransform i2m0 = this.multiLevelSource.getModel().getImageToModelTransform(0);
        AffineTransform v2m = viewport.getViewToModelTransform();
        AffineTransform m2v = viewport.getModelToViewTransform();
        Rectangle viewBounds = viewport.getViewBounds();
        Shape imageShape = m2i0.createTransformedShape(v2m.createTransformedShape(viewBounds));
        Rectangle2D imageBounds = imageShape.getBounds2D();
        double pixelSizeInViewX = i2m0.getScaleX() * m2v.getScaleX();
        double pixelSizeInViewY = i2m0.getScaleY() * m2v.getScaleY();
        if (pixelSizeInViewX >= 16.0 || pixelSizeInViewY >= 16.0) {
            RenderedImage image0 = this.multiLevelSource.getImage(0);
            int x0 = Math.max(0, (int)Math.floor(imageBounds.getX()));
            int y0 = Math.max(0, (int)Math.floor(imageBounds.getY()));
            int x1 = Math.min(image0.getWidth(), x0 + (int)Math.round(imageBounds.getWidth()) + 1);
            int y1 = Math.min(image0.getHeight(), y0 + (int)Math.round(imageBounds.getHeight()) + 1);
            graphics2D.setStroke(new BasicStroke((float)Math.max(0.0, this.getPixelBorderWidth())));
            graphics2D.setColor(this.getPixelBorderColor());
            int x = x0;
            while (x <= x1) {
                graphics2D.draw(m2v.createTransformedShape(i2m0.createTransformedShape(new Line2D.Double(x, y0, x, y1))));
                ++x;
            }
            int y = y0;
            while (y <= y1) {
                graphics2D.draw(m2v.createTransformedShape(i2m0.createTransformedShape(new Line2D.Double(x0, y, x1, y))));
                ++y;
            }
        }
    }

    @Override
    protected synchronized void disposeLayer() {
        this.resetRenderer();
        if (this.multiLevelSource != null) {
            this.multiLevelSource.reset();
            this.multiLevelSource = null;
        }
    }

    private synchronized MultiLevelRenderer getRenderer(Rendering rendering) {
        if (rendering instanceof InteractiveRendering) {
            if (this.multiLevelRenderer == null) {
                this.multiLevelRenderer = new ConcurrentMultiLevelRenderer();
            }
            return this.multiLevelRenderer;
        }
        return new DefaultMultiLevelRenderer();
    }

    private void resetRenderer() {
        if (this.multiLevelRenderer != null) {
            this.multiLevelRenderer.reset();
            this.multiLevelRenderer = null;
        }
    }

    private void clearCaches() {
        this.resetRenderer();
        this.multiLevelSource.reset();
    }

    public boolean isBorderShown() {
        return this.getConfigurationProperty(PROPERTY_NAME_BORDER_SHOWN, false);
    }

    public double getBorderWidth() {
        return this.getConfigurationProperty(PROPERTY_NAME_BORDER_WIDTH, 1.0);
    }

    public Color getBorderColor() {
        return this.getConfigurationProperty(PROPERTY_NAME_BORDER_COLOR, DEFAULT_BORDER_COLOR);
    }

    public boolean isPixelBorderShown() {
        return this.getConfigurationProperty(PROPERTY_NAME_PIXEL_BORDER_SHOWN, DEFAULT_PIXEL_BORDER_SHOWN);
    }

    public double getPixelBorderWidth() {
        return this.getConfigurationProperty(PROPERTY_NAME_PIXEL_BORDER_WIDTH, 0.0);
    }

    public Color getPixelBorderColor() {
        return this.getConfigurationProperty(PROPERTY_NAME_PIXEL_BORDER_COLOR, DEFAULT_PIXEL_BORDER_COLOR);
    }

    private static PropertySet initConfiguration(PropertySet configuration, MultiLevelSource multiLevelSource) {
        configuration.setValue(PROPERTY_NAME_MULTI_LEVEL_SOURCE, multiLevelSource);
        return configuration;
    }

    @LayerTypeMetadata(name="ImageLayerType", aliasNames={"com.bc.ceres.glayer.support.ImageLayer$Type"})
    public static class Type
    extends LayerType {
        @Override
        public boolean isValidFor(LayerContext ctx) {
            return true;
        }

        @Override
        public Layer createLayer(LayerContext ctx, PropertySet configuration) {
            MultiLevelSource multiLevelSource = (MultiLevelSource)configuration.getValue(ImageLayer.PROPERTY_NAME_MULTI_LEVEL_SOURCE);
            return new ImageLayer(this, multiLevelSource, configuration);
        }

        @Override
        public PropertySet createLayerConfig(LayerContext ctx) {
            PropertyContainer template = new PropertyContainer();
            Type.addMultiLevelSourceModel(template);
            Type.addImageToModelTransformModel(template);
            template.addProperty(Property.create(ImageLayer.PROPERTY_NAME_BORDER_SHOWN, Boolean.class, false, true));
            template.addProperty(Property.create(ImageLayer.PROPERTY_NAME_BORDER_COLOR, Color.class, DEFAULT_BORDER_COLOR, true));
            template.addProperty(Property.create(ImageLayer.PROPERTY_NAME_BORDER_WIDTH, Double.class, 1.0, true));
            template.addProperty(Property.create(ImageLayer.PROPERTY_NAME_PIXEL_BORDER_SHOWN, Boolean.class, DEFAULT_PIXEL_BORDER_SHOWN, true));
            template.addProperty(Property.create(ImageLayer.PROPERTY_NAME_PIXEL_BORDER_COLOR, Color.class, DEFAULT_PIXEL_BORDER_COLOR, true));
            template.addProperty(Property.create(ImageLayer.PROPERTY_NAME_PIXEL_BORDER_WIDTH, Double.class, 0.0, true));
            return template;
        }

        private static Property addImageToModelTransformModel(PropertyContainer configuration) {
            Property property = configuration.getProperty(ImageLayer.PROPERTY_NAME_IMAGE_TO_MODEL_TRANSFORM);
            if (property == null) {
                property = Property.create(ImageLayer.PROPERTY_NAME_IMAGE_TO_MODEL_TRANSFORM, AffineTransform.class);
                configuration.addProperty(property);
            }
            property.getDescriptor().setTransient(true);
            return property;
        }

        private static Property addMultiLevelSourceModel(PropertyContainer configuration) {
            if (configuration.getProperty(ImageLayer.PROPERTY_NAME_MULTI_LEVEL_SOURCE) == null) {
                configuration.addProperty(Property.create(ImageLayer.PROPERTY_NAME_MULTI_LEVEL_SOURCE, MultiLevelSource.class));
            }
            configuration.getDescriptor(ImageLayer.PROPERTY_NAME_MULTI_LEVEL_SOURCE).setTransient(true);
            return configuration.getProperty(ImageLayer.PROPERTY_NAME_MULTI_LEVEL_SOURCE);
        }
    }
}

