/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core.runtime.internal;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.CoreException;
import com.bc.ceres.core.ExtensibleObject;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.core.runtime.Module;
import com.bc.ceres.core.runtime.ModuleRuntime;
import com.bc.ceres.core.runtime.ModuleState;
import com.bc.ceres.core.runtime.ProxyConfig;
import com.bc.ceres.core.runtime.RuntimeConfig;
import com.bc.ceres.core.runtime.RuntimeRunnable;
import com.bc.ceres.core.runtime.internal.ModuleClassLoader;
import com.bc.ceres.core.runtime.internal.ModuleImpl;
import com.bc.ceres.core.runtime.internal.ModuleInstaller;
import com.bc.ceres.core.runtime.internal.ModuleLoader;
import com.bc.ceres.core.runtime.internal.ModuleReader;
import com.bc.ceres.core.runtime.internal.ModuleRegistry;
import com.bc.ceres.core.runtime.internal.ModuleResolver;
import com.bc.ceres.core.runtime.internal.ModuleUninstaller;
import com.bc.ceres.core.runtime.internal.ResolveException;
import com.bc.ceres.core.runtime.internal.RuntimeActivator;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RuntimeImpl
extends ExtensibleObject
implements ModuleRuntime {
    public static final String UNINSTALL_FILE_SUFFIX = ".uninstall";
    private final RuntimeConfig config;
    private final String[] commandLineArgs;
    private final ProgressMonitor progressMonitor;
    private ModuleImpl systemModule;
    private ModuleRegistry moduleRegistry;
    private ArrayList<ModuleImpl> resolvedModules;
    private boolean running;
    private long lastModuleId = 0L;

    public RuntimeImpl(RuntimeConfig config, String[] commandLineArgs, ProgressMonitor progressMonitor) {
        Assert.notNull(config, "config");
        Assert.notNull(commandLineArgs, "commandLineArgs");
        Assert.notNull(progressMonitor, "progressMonitor");
        this.config = config;
        this.commandLineArgs = commandLineArgs;
        this.progressMonitor = progressMonitor;
    }

    @Override
    public RuntimeConfig getRuntimeConfig() {
        return this.config;
    }

    @Override
    public String[] getCommandLineArgs() {
        return this.commandLineArgs;
    }

    @Override
    public Logger getLogger() {
        return this.config.getLogger();
    }

    @Override
    public Module getModule() {
        return this.systemModule;
    }

    @Override
    public Module getModule(long id) {
        return this.moduleRegistry.getModule(id);
    }

    @Override
    public Module[] getModules() {
        return this.moduleRegistry.getModules();
    }

    @Override
    public Module installModule(URL url, ProxyConfig proxyConfig, ProgressMonitor pm) throws CoreException {
        String modulesDirPath = this.config.getModulesDirPath();
        if (modulesDirPath == null) {
            throw new CoreException("Modules directory not set");
        }
        File modulesDir = new File(modulesDirPath);
        ModuleInstaller moduleInstaller = new ModuleInstaller(this.getLogger());
        ModuleImpl module = moduleInstaller.installModule(url, proxyConfig, modulesDir, pm);
        this.registerModule(module, this.newModuleId());
        return module;
    }

    @Override
    public void start() throws CoreException {
        if (this.running) {
            throw new CoreException("Already running");
        }
        this.running = true;
        this.progressMonitor.beginTask("Starting runtime", 100);
        this.getLogger().info(MessageFormat.format("Starting runtime for context [{0}]...", this.getContextId()));
        this.logRuntimeConfig();
        try {
            this.progressMonitor.setSubTaskName("Loading modules");
            this.loadModules(SubProgressMonitor.create(this.progressMonitor, 10));
            this.initSystemModule();
            this.progressMonitor.worked(5);
            this.progressMonitor.setSubTaskName("Resolving modules");
            this.resolveModules(SubProgressMonitor.create(this.progressMonitor, 5));
            this.progressMonitor.setSubTaskName("Starting modules");
            this.startModules(SubProgressMonitor.create(this.progressMonitor, 55));
            this.registerShutdownHook();
            this.progressMonitor.setSubTaskName("Running application");
            this.runApplication(SubProgressMonitor.create(this.progressMonitor, 30));
        }
        finally {
            this.progressMonitor.done();
        }
    }

    @Override
    public void stop() throws CoreException {
        if (!this.running) {
            return;
        }
        this.getLogger().info(MessageFormat.format("Stopping runtime for context [{0}]...", this.getContextId()));
        this.stopModules();
        this.dispose();
        this.running = false;
    }

    private String getContextId() {
        return this.config.getContextId();
    }

    private void dispose() {
        this.systemModule = null;
        this.moduleRegistry = null;
        this.resolvedModules = null;
    }

    private void logRuntimeConfig() {
        this.getLogger().info("Runtime configuration:");
        this.getLogger().info(String.format("  contextId      = %s", this.config.getContextId()));
        this.getLogger().info(String.format("  homeDirPath    = %s", this.config.getHomeDirPath()));
        this.getLogger().info(String.format("  configFilePath = %s", this.config.getConfigFilePath()));
        this.getLogger().info(String.format("  modulesDirPath = %s", this.config.getModulesDirPath()));
        String[] libDirPaths = this.config.getLibDirPaths();
        int i = 0;
        while (i < libDirPaths.length) {
            this.getLogger().info(String.format("  libDirPaths.%d = %s", i, this.config.getLibDirPaths()[i]));
            ++i;
        }
        this.getLogger().info(String.format("  mainClassName  = %s", this.config.getMainClassName()));
        this.getLogger().info(String.format("  applicationId  = %s", this.config.getApplicationId()));
    }

    private void loadModules(ProgressMonitor pm) throws CoreException {
        pm.beginTask("Loading modules", 3);
        try {
            if (this.config.getModulesDirPath() != null) {
                this.uninstallModules(SubProgressMonitor.create(pm, 1));
            } else {
                pm.worked(1);
            }
            this.moduleRegistry = new ModuleRegistry();
            ModuleLoader moduleLoader = new ModuleLoader(this.getLogger());
            if (this.config.getModulesDirPath() != null) {
                this.loadModulesFromModulesDir(moduleLoader, SubProgressMonitor.create(pm, 1));
            } else {
                pm.worked(1);
            }
            this.loadModulesFromClasspath(moduleLoader, SubProgressMonitor.create(pm, 1));
        }
        finally {
            pm.done();
        }
    }

    private void uninstallModules(ProgressMonitor pm) {
        ModuleUninstaller moduleUninstaller = new ModuleUninstaller(this.getLogger());
        moduleUninstaller.uninstallModules(new File(this.config.getModulesDirPath()), pm);
    }

    private void loadModulesFromModulesDir(ModuleLoader moduleLoader, ProgressMonitor pm) throws CoreException {
        File modulesDir = new File(this.config.getModulesDirPath());
        if (modulesDir.isDirectory()) {
            this.getLogger().info(String.format("Searching for modules in [%s]...", modulesDir.getPath()));
            try {
                ModuleImpl[] modules = moduleLoader.loadModules(modulesDir, pm);
                this.getLogger().info(String.format("%d module(s) found.", modules.length));
                this.registerModules(modules);
            }
            catch (IOException e) {
                throw new CoreException(e);
            }
        }
    }

    private void loadModulesFromClasspath(ModuleLoader moduleLoader, ProgressMonitor pm) throws CoreException {
        try {
            this.getLogger().info("Searching for modules in classpath...");
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            ModuleImpl[] modules = moduleLoader.loadModules(contextClassLoader, pm);
            this.getLogger().info(String.format("%d module(s) found.", modules.length));
            this.registerModules(modules);
        }
        catch (IOException e) {
            throw new CoreException(e);
        }
    }

    private void registerModules(ModuleImpl[] modules) {
        ModuleImpl[] moduleImplArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            ModuleImpl module = moduleImplArray[n2];
            try {
                if (this.moduleRegistry.getModule(module.getLocation()) != null) {
                    this.getLogger().warning(MessageFormat.format("Module [{0}-{1}@{2}] already registered.", module.getSymbolicName(), module.getVersion(), module.getLocation()));
                } else {
                    long id;
                    long l = id = module.getSymbolicName().equals("ceres-core") ? 0L : this.newModuleId();
                    if (this.moduleRegistry.getModule(id) == null) {
                        this.registerModule(module, id);
                        this.getLogger().info(MessageFormat.format("Module [{0}-{1}] registered.", module.getSymbolicName(), module.getVersion()));
                    }
                }
            }
            catch (CoreException e) {
                this.logError(MessageFormat.format("Failed to register module [{0}-{1}@{2}].", module.getSymbolicName(), module.getVersion(), module.getLocation()), e);
            }
            ++n2;
        }
    }

    private long newModuleId() {
        return ++this.lastModuleId;
    }

    private void initSystemModule() throws CoreException {
        ModuleImpl[] systemModules = this.moduleRegistry.getModules("ceres-core");
        if (systemModules.length > 0) {
            this.systemModule = systemModules[0];
        }
        if (this.systemModule == null) {
            URL location = this.getCodeSourceLocation();
            ModuleReader moduleReader = new ModuleReader(this.getLogger());
            this.systemModule = moduleReader.readFromLocation(location);
            this.registerModule(this.systemModule, 0L);
        }
    }

    private void registerModule(ModuleImpl module, long moduleId) throws CoreException {
        module.setRuntime(this);
        module.setModuleId(moduleId);
        this.moduleRegistry.registerModule(module);
    }

    private void resolveModules(ProgressMonitor pm) {
        ModuleImpl[] modules = this.moduleRegistry.getModules();
        this.resolvedModules = new ArrayList(modules.length);
        pm.beginTask("Resolving modules", modules.length + 1);
        try {
            ModuleImpl[] moduleImplArray = modules;
            int n = modules.length;
            int n2 = 0;
            while (n2 < n) {
                ModuleImpl module = moduleImplArray[n2];
                this.resolveModule(module);
                pm.worked(1);
                ++n2;
            }
            Collections.sort(this.resolvedModules, new Comparator<ModuleImpl>(){

                @Override
                public int compare(ModuleImpl m1, ModuleImpl m2) {
                    return m2.getRefCount() - m1.getRefCount();
                }
            });
            pm.worked(1);
            this.logResolveSummary();
        }
        finally {
            pm.done();
        }
    }

    private void resolveModule(ModuleImpl module) {
        List<ResolveException> resolveWarnings;
        this.getLogger().info(MessageFormat.format("Resolving module [{0}-{1}].", module.getSymbolicName(), module.getVersion()));
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        ModuleResolver moduleResolver = new ModuleResolver(contextClassLoader, true);
        try {
            moduleResolver.resolve(module);
            this.systemModule.setRefCount(this.systemModule.getRefCount() + module.getRefCount());
            this.resolvedModules.add(module);
        }
        catch (ResolveException e) {
            this.logError(e.getMessage(), e);
        }
        List<ResolveException> resolveErrors = Arrays.asList(module.getResolveErrors());
        if (!resolveErrors.isEmpty()) {
            Collections.reverse(resolveErrors);
            for (ResolveException resolveError : resolveErrors) {
                this.getLogger().log(Level.SEVERE, resolveError.getMessage());
            }
        }
        if (!(resolveWarnings = Arrays.asList(module.getResolveWarnings())).isEmpty()) {
            Collections.reverse(resolveWarnings);
            for (ResolveException resolveWarning : resolveWarnings) {
                this.getLogger().log(Level.WARNING, resolveWarning.getMessage());
            }
        }
    }

    private void logResolveSummary() {
        for (ModuleImpl module : this.resolvedModules) {
            String msg = MessageFormat.format("Module [{0}-{1}] resolved, reference count is {2}.", module.getSymbolicName(), module.getVersion(), module.getRefCount());
            this.getLogger().fine(msg);
            ModuleImpl[] moduleDependencies = module.getModuleDependencies();
            int i = 0;
            while (i < moduleDependencies.length) {
                msg = MessageFormat.format("  moduleDependencies[{0}] = {1}", i, moduleDependencies[i].getSymbolicName());
                this.getLogger().fine(msg);
                ++i;
            }
            ModuleClassLoader classLoader = (ModuleClassLoader)module.getClassLoader();
            msg = MessageFormat.format("  classLoader = {0}", classLoader);
            this.getLogger().fine(msg);
            URL[] urls = classLoader.getURLs();
            int i2 = 0;
            while (i2 < urls.length) {
                msg = MessageFormat.format("  classLoader.urls[{0}] = {1}", i2, urls[i2]);
                this.getLogger().fine(msg);
                ++i2;
            }
            URL[] nativeUrls = classLoader.getNativeUrls();
            int i3 = 0;
            while (i3 < nativeUrls.length) {
                msg = MessageFormat.format("  classLoader.nativeUrls[{0}] = {1}", i3, nativeUrls[i3]);
                this.getLogger().fine(msg);
                ++i3;
            }
            ClassLoader[] delegates = classLoader.getDelegates();
            int i4 = 0;
            while (i4 < delegates.length) {
                msg = MessageFormat.format("  classLoader.delegates[{0}] = {1}", i4, delegates[i4]);
                this.getLogger().fine(msg);
                ++i4;
            }
        }
    }

    private void startModules(ProgressMonitor subProgressMonitor) {
        try {
            subProgressMonitor.beginTask("Starting modules", this.resolvedModules.size());
            for (ModuleImpl module : this.resolvedModules) {
                if (module.getState() == ModuleState.RESOLVED) {
                    try {
                        subProgressMonitor.setSubTaskName(module.getName());
                        module.start();
                        this.getLogger().info(MessageFormat.format("Module [{0}-{1}] started.", module.getSymbolicName(), module.getVersion()));
                    }
                    catch (CoreException e) {
                        this.logError(MessageFormat.format("Failed to start module [{0}-{1}].", module.getSymbolicName(), module.getVersion()), e);
                    }
                }
                subProgressMonitor.worked(1);
            }
        }
        finally {
            subProgressMonitor.done();
        }
    }

    private void stopModules() {
        int i = this.resolvedModules.size() - 1;
        while (i >= 0) {
            ModuleImpl module = this.resolvedModules.get(i);
            if (module.getState() == ModuleState.ACTIVE) {
                try {
                    module.stop();
                    this.getLogger().info(MessageFormat.format("Module [{0}-{1}] stopped.", module.getSymbolicName(), module.getVersion()));
                }
                catch (CoreException e) {
                    this.logError(MessageFormat.format("Failed to stop module [{0}-{1}].", module.getSymbolicName(), module.getVersion()), e);
                }
            }
            --i;
        }
    }

    private void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    RuntimeImpl.this.stop();
                }
                catch (CoreException e) {
                    RuntimeImpl.this.logError("Failed to shutdown runtime.", e);
                }
            }
        });
        this.getLogger().info("Shutdown hook registered.");
    }

    private void runApplication(ProgressMonitor pm) throws CoreException {
        String applicationId = this.config.getApplicationId();
        if (applicationId == null) {
            return;
        }
        RuntimeRunnable application = this.getRuntimeActivator().getApplication(applicationId);
        if (application == null) {
            throw new CoreException(MessageFormat.format("Application [{0}] not found", applicationId));
        }
        try {
            this.getLogger().info(MessageFormat.format("Invoking application [{0}].", applicationId));
            application.run(this.commandLineArgs, pm);
            this.getLogger().info(MessageFormat.format("Application [{0}] invoked.", applicationId));
        }
        catch (Throwable t) {
            throw new CoreException(MessageFormat.format("Failed to invoke application [{0}]", applicationId), t);
        }
    }

    private RuntimeActivator getRuntimeActivator() {
        return (RuntimeActivator)this.systemModule.getActivator();
    }

    private URL getCodeSourceLocation() throws CoreException {
        CodeSource codeSource = this.getClass().getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            throw new CoreException("No code source available for system module");
        }
        return codeSource.getLocation();
    }

    private void logError(String msg, Throwable e) {
        this.getLogger().log(Level.SEVERE, msg, e);
    }
}

