/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core.runtime.internal;

import com.bc.ceres.core.CoreException;
import com.bc.ceres.core.runtime.ConfigurableExtension;
import com.bc.ceres.core.runtime.ConfigurationElement;
import com.bc.ceres.core.runtime.ConfigurationSchemaElement;
import com.bc.ceres.core.runtime.Extension;
import com.bc.ceres.core.runtime.Module;
import com.bc.ceres.core.runtime.internal.ConfigurationElementBaseImpl;
import com.bc.ceres.core.runtime.internal.ConfigurationSchemaElementImpl;
import com.bc.ceres.core.runtime.internal.ExtensionImpl;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.extended.JavaClassConverter;
import com.thoughtworks.xstream.core.util.ClassLoaderReference;
import com.thoughtworks.xstream.core.util.CompositeClassLoader;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.XppDomReader;
import com.thoughtworks.xstream.io.xml.XppDriver;
import com.thoughtworks.xstream.io.xml.xppdom.XppDom;
import java.text.MessageFormat;

public class ConfigurationElementImpl
extends ConfigurationElementBaseImpl<ConfigurationElement>
implements ConfigurationElement {
    private ExtensionImpl declaringExtension;
    private ConfigurationSchemaElementImpl schemaElement;

    public ConfigurationElementImpl(ConfigurationElementImpl parent, XppDom dom) {
        super(parent, dom);
    }

    @Override
    public ConfigurationSchemaElement getSchemaElement() {
        return this.schemaElement;
    }

    @Override
    public Extension getDeclaringExtension() {
        return this.declaringExtension;
    }

    @Override
    public <T> T createExecutableExtension(Class<T> extensionType) throws CoreException {
        String extensionClassElementName = null;
        String extensionClassAttributeName = null;
        Class<T> extensionDefaultClass = null;
        if (this.schemaElement != null) {
            String classAttributeValue;
            String typeAttributeValue = this.schemaElement.getAttribute("type");
            this.checkExtensionType(extensionType, typeAttributeValue);
            String extensionDefaultClassName = classAttributeValue = this.schemaElement.getAttribute("class");
            if (classAttributeValue != null) {
                if (classAttributeValue.startsWith("@")) {
                    extensionClassElementName = classAttributeValue.substring(1);
                    ConfigurationSchemaElement extensionDefaultClassNameElement = (ConfigurationSchemaElement)this.schemaElement.getChild(extensionClassElementName);
                    if (extensionDefaultClassNameElement != null) {
                        extensionDefaultClassName = extensionDefaultClassNameElement.getValue();
                    }
                } else if (classAttributeValue.startsWith("#")) {
                    extensionClassAttributeName = classAttributeValue.substring(1);
                }
            }
            if (extensionDefaultClassName != null) {
                extensionDefaultClassName = extensionDefaultClassName.trim();
                extensionDefaultClass = this.loadClass(extensionDefaultClassName, extensionType);
            }
        }
        Class<T> extensionClass = this.getExtensionClass(extensionType, extensionDefaultClass, extensionClassAttributeName, extensionClassElementName);
        T instance = this.createInstance(extensionClass);
        XStream xStream = this.getXStream(extensionType, extensionClass, extensionDefaultClass);
        if (xStream != null) {
            try {
                xStream.unmarshal(new XppDomReader(this.getDom()), instance);
            }
            catch (Throwable e) {
                throw new CoreException(MessageFormat.format("Module [{0}]: Failed to unmarshal executable extension [{1}]: {2}", this.getDeclaringModule().getSymbolicName(), this.getName(), e.getMessage()), e);
            }
        }
        if (instance instanceof ConfigurableExtension) {
            ConfigurableExtension configurableExtension = (ConfigurableExtension)instance;
            configurableExtension.configure(this);
        }
        return instance;
    }

    private <T> T createInstance(Class<T> someClass) throws CoreException {
        T instance;
        try {
            instance = someClass.newInstance();
        }
        catch (Throwable e) {
            throw new CoreException(MessageFormat.format("Module [{0}]: Failed to instantiate object for extension [{1}]: {2}", this.getDeclaringModule().getSymbolicName(), this.getName(), e.getMessage()), e);
        }
        return instance;
    }

    private <T> Class<T> getExtensionClass(Class<T> extensionType, Class<T> extensionDefaultClass, String extensionClassAttributeName, String extensionClassElementName) throws CoreException {
        Class<T> extensionClass = null;
        String extensionClassName = null;
        if (extensionClassElementName != null) {
            ConfigurationElement extensionClassNameElement = (ConfigurationElement)this.getChild(extensionClassElementName);
            if (extensionClassNameElement != null) {
                extensionClassName = extensionClassNameElement.getValue();
            }
        } else {
            extensionClassName = extensionClassAttributeName != null ? this.getAttribute(extensionClassAttributeName) : this.getAttribute("class");
        }
        if (extensionClassName != null) {
            extensionClassName = extensionClassName.trim();
            extensionClass = this.loadClass(extensionClassName, extensionType);
        }
        if (extensionClass == null) {
            extensionClass = extensionDefaultClass;
        }
        if (extensionClass == null) {
            throw new CoreException(MessageFormat.format("Module [{0}]: Missing class definition for executable extension [{1}]", this.getDeclaringModule().getSymbolicName(), this.getName()));
        }
        return extensionClass;
    }

    private <T> void checkExtensionType(Class<T> extensionType, String typeAttributeValue) throws CoreException {
        Class<?> declaredExtensionType;
        if (typeAttributeValue != null && !(declaredExtensionType = this.loadClass(typeAttributeValue)).equals(extensionType)) {
            throw new CoreException(MessageFormat.format("Module [{0}]: Illegal type definition for executable extension [{1}]: must be [{2}]", this.getDeclaringModule().getSymbolicName(), this.getName(), extensionType.getName()));
        }
    }

    private Class<?> loadClass(String className) throws CoreException {
        try {
            return this.getDeclaringModule().loadClass(className);
        }
        catch (Throwable e) {
            throw new CoreException(MessageFormat.format("Module [{0}]: Executable extension [{1}]: Failed to load class [{2}]", this.getDeclaringModule().getSymbolicName(), this.getName(), className), e);
        }
    }

    private <T> Class<T> loadClass(String className, Class<T> requiredType) throws CoreException {
        Class<?> someClass = this.loadClass(className);
        if (!requiredType.isAssignableFrom(someClass)) {
            throw new CoreException(MessageFormat.format("Module [{0}]: Executable extension [{1}]: Class [{2}] is not a [{3}]", this.getDeclaringModule().getSymbolicName(), this.getName(), someClass.getName(), requiredType.getName()));
        }
        return someClass;
    }

    private <T> Module getDeclaringModule() {
        return this.getDeclaringExtension().getDeclaringModule();
    }

    private <T> XStream getXStream(Class<T> extensionType, Class<T> extensionClass, Class<T> extensionDefaultClass) {
        if (this.schemaElement == null) {
            return null;
        }
        String attribute = this.schemaElement.getAttribute("autoConfig");
        if (attribute == null || !attribute.equalsIgnoreCase("true")) {
            return null;
        }
        XStream xStream = this.schemaElement.getXStream();
        if (xStream == null) {
            xStream = this.createXStream(extensionType, extensionClass);
            this.schemaElement.setXStream(xStream);
            if (extensionDefaultClass != null) {
                this.schemaElement.configureAliases(extensionDefaultClass);
            }
        }
        this.schemaElement.configureAliases(extensionClass);
        xStream.setClassLoader(this.getDeclaringModule().getClassLoader());
        return xStream;
    }

    private <T> XStream createXStream(Class<T> extensionType, Class<T> extensionClass) {
        ConfigurationSchemaElement[] children;
        ClassLoaderReference classLoaderReference = new ClassLoaderReference(new CompositeClassLoader());
        XStream xStream = new XStream(null, (HierarchicalStreamDriver)new XppDriver(), classLoaderReference);
        xStream.aliasType(this.getName(), extensionType);
        ConfigurationSchemaElement[] configurationSchemaElementArray = children = (ConfigurationSchemaElement[])this.schemaElement.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigurationSchemaElement child = configurationSchemaElementArray[n2];
            String fieldName = child.getAttribute("field");
            if (fieldName != null) {
                xStream.aliasField(child.getName(), extensionClass, fieldName);
            }
            ++n2;
        }
        WhitespaceIgnoringJavaClassConverter classConverter = new WhitespaceIgnoringJavaClassConverter(classLoaderReference);
        xStream.registerConverter(classConverter, 10000);
        return xStream;
    }

    protected ConfigurationElement[] createChildren(XppDom[] doms) {
        ConfigurationElement[] children = this.createEmptyArray(doms.length);
        int i = 0;
        while (i < doms.length) {
            ConfigurationElementImpl child = new ConfigurationElementImpl(this, doms[i]);
            child.setDeclaringExtension(this.declaringExtension);
            if (this.schemaElement != null) {
                child.setSchemaElement((ConfigurationSchemaElementImpl)this.schemaElement.getChild(child.getName()));
            }
            children[i] = child;
            ++i;
        }
        return children;
    }

    protected ConfigurationElement[] createEmptyArray(int n) {
        return new ConfigurationElement[n];
    }

    void setDeclaringExtension(ExtensionImpl declaringExtension) {
        this.declaringExtension = declaringExtension;
    }

    void setSchemaElement(ConfigurationSchemaElementImpl schemaElement) {
        this.schemaElement = schemaElement;
    }

    private static class WhitespaceIgnoringJavaClassConverter
    extends JavaClassConverter {
        public WhitespaceIgnoringJavaClassConverter(ClassLoader classLoader) {
            super(classLoader);
        }

        @Override
        public Object fromString(String str) {
            return super.fromString(str.trim());
        }
    }
}

