/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.runtime.RuntimeConfig;
import com.bc.ceres.core.runtime.RuntimeContext;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public abstract class VirtualDir {
    private static final int TEMP_DIR_ATTEMPTS = 10000;

    public abstract String getBasePath();

    public Reader getReader(String path) throws IOException {
        return new InputStreamReader(this.getInputStream(path));
    }

    public abstract InputStream getInputStream(String var1) throws IOException;

    public abstract File getFile(String var1) throws IOException;

    public abstract String[] list(String var1) throws IOException;

    public abstract void close();

    public static VirtualDir create(File file) {
        if (file.isDirectory()) {
            return new Dir(file);
        }
        try {
            return new Zip(new ZipFile(file));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public abstract boolean isCompressed();

    public abstract boolean isArchive();

    public File getTempDir() throws IOException {
        return null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public static void deleteFileTree(File treeRoot) {
        Assert.notNull(treeRoot);
        File[] files = treeRoot.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    VirtualDir.deleteFileTree(file);
                } else {
                    file.delete();
                }
                ++n2;
            }
        }
        treeRoot.delete();
    }

    public static File createUniqueTempDir() throws IOException {
        File baseDir = VirtualDir.getBaseTempDir();
        String baseName = String.valueOf(System.currentTimeMillis()) + "-";
        int counter = 0;
        while (counter < 10000) {
            File tempDir = new File(baseDir, String.valueOf(baseName) + counter);
            if (tempDir.mkdir()) {
                return tempDir;
            }
            ++counter;
        }
        throw new IllegalStateException("Failed to create directory within 10000 attempts (tried " + baseName + "0 to " + baseName + 9999 + ')');
    }

    private static File getBaseTempDir() throws IOException {
        File tempDir;
        String contextId = VirtualDir.getContextId();
        String tempDirName = System.getProperty("java.io.tmpdir");
        if (tempDirName != null) {
            tempDir = new File(tempDirName);
            if (tempDir.exists()) {
                String userName = System.getProperty("user.name");
                tempDir = new File(tempDir, String.valueOf(contextId) + "-" + userName);
                tempDir.mkdir();
            }
        } else {
            tempDir = new File(System.getProperty("user.home", "."), "." + contextId + "/temp");
            tempDir.mkdirs();
        }
        if (!tempDir.exists()) {
            throw new IOException("Temporary directory not available: " + tempDir);
        }
        return tempDir;
    }

    private static String getContextId() {
        String contextId = "ceres";
        RuntimeConfig runtimeConfig = RuntimeContext.getConfig();
        if (runtimeConfig != null) {
            contextId = runtimeConfig.getContextId();
        }
        return contextId;
    }

    private static class Dir
    extends VirtualDir {
        private final File dir;

        private Dir(File file) {
            this.dir = file;
        }

        @Override
        public String getBasePath() {
            return this.dir.getPath();
        }

        @Override
        public InputStream getInputStream(String path) throws IOException {
            if (path.endsWith(".gz")) {
                return new GZIPInputStream(new BufferedInputStream(new FileInputStream(this.getFile(path))));
            }
            return new BufferedInputStream(new FileInputStream(this.getFile(path)));
        }

        @Override
        public File getFile(String path) throws IOException {
            File child = new File(this.dir, path);
            if (!child.exists()) {
                throw new FileNotFoundException(child.getPath());
            }
            return child;
        }

        @Override
        public String[] list(String path) throws IOException {
            File child = this.getFile(path);
            return child.list();
        }

        @Override
        public void close() {
        }

        @Override
        public boolean isCompressed() {
            return false;
        }

        @Override
        public boolean isArchive() {
            return false;
        }
    }

    private static class Zip
    extends VirtualDir {
        private static final int BUFFER_SIZE = 0x400000;
        private ZipFile zipFile;
        private File tempZipFileDir;

        private Zip(ZipFile zipFile) {
            this.zipFile = zipFile;
        }

        @Override
        public String getBasePath() {
            return this.zipFile.getName();
        }

        @Override
        public InputStream getInputStream(String path) throws IOException {
            return this.getInputStream(this.getEntry(path));
        }

        @Override
        public File getFile(String path) throws IOException {
            File tempFile;
            ZipEntry zipEntry = this.getEntry(path);
            if (this.tempZipFileDir == null) {
                this.tempZipFileDir = VirtualDir.createUniqueTempDir();
            }
            if ((tempFile = new File(this.tempZipFileDir, zipEntry.getName())).exists()) {
                return tempFile;
            }
            if (zipEntry.isDirectory()) {
                tempFile.mkdirs();
            } else {
                this.unzip(zipEntry, tempFile);
            }
            return tempFile;
        }

        @Override
        public String[] list(String path) throws IOException {
            if (".".equals(path) || path.isEmpty()) {
                path = "";
            } else if (!path.endsWith("/")) {
                path = String.valueOf(path) + "/";
            }
            boolean dirSeen = false;
            TreeSet<String> nameSet = new TreeSet<String>();
            Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String name = zipEntry.getName();
                if (!name.startsWith(path)) continue;
                int i1 = path.length();
                int i2 = name.indexOf(47, i1);
                String entryName = i2 == -1 ? name.substring(i1) : name.substring(i1, i2);
                if (!entryName.isEmpty() && !nameSet.contains(entryName)) {
                    nameSet.add(entryName);
                }
                dirSeen = true;
            }
            if (!dirSeen) {
                throw new FileNotFoundException(String.valueOf(this.getBasePath()) + "!" + path);
            }
            return nameSet.toArray(new String[nameSet.size()]);
        }

        @Override
        public void close() {
            this.cleanup();
        }

        @Override
        protected void finalize() throws Throwable {
            super.finalize();
            this.cleanup();
        }

        @Override
        public boolean isCompressed() {
            return true;
        }

        @Override
        public boolean isArchive() {
            return true;
        }

        @Override
        public File getTempDir() throws IOException {
            return this.tempZipFileDir;
        }

        private void cleanup() {
            try {
                this.zipFile.close();
                this.zipFile = null;
            }
            catch (IOException iOException) {}
            if (this.tempZipFileDir != null) {
                Zip.deleteFileTree(this.tempZipFileDir);
            }
        }

        private InputStream getInputStream(ZipEntry zipEntry) throws IOException {
            InputStream inputStream = this.zipFile.getInputStream(zipEntry);
            if (zipEntry.getName().endsWith(".gz")) {
                return new GZIPInputStream(inputStream);
            }
            return inputStream;
        }

        private ZipEntry getEntry(String path) throws FileNotFoundException {
            ZipEntry zipEntry = this.zipFile.getEntry(path);
            if (zipEntry == null) {
                throw new FileNotFoundException(String.valueOf(this.zipFile.getName()) + "!" + path);
            }
            return zipEntry;
        }

        private void unzip(ZipEntry zipEntry, File tempFile) throws IOException {
            block21: {
                Throwable throwable = null;
                Object var4_5 = null;
                try (InputStream is = this.zipFile.getInputStream(zipEntry);){
                    if (is == null) break block21;
                    tempFile.getParentFile().mkdirs();
                    try {
                        Throwable throwable2 = null;
                        Object var7_11 = null;
                        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(tempFile), 0x400000);){
                            int n;
                            byte[] bytes = new byte[1024];
                            while ((n = is.read(bytes)) > 0) {
                                os.write(bytes, 0, n);
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (IOException ioe) {
                        throw new IOException("Failed to unzip '" + zipEntry.getName() + "'to '" + tempFile.getAbsolutePath() + "'", ioe);
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
        }
    }
}

