/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import com.bc.ceres.binding.ConverterRegistry;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;

public class ValueSet {
    private List<Object> objects;

    public ValueSet(Object[] items) {
        this.objects = Arrays.asList(items);
    }

    public Object[] getItems() {
        return this.objects.toArray();
    }

    public boolean contains(Object value) {
        return this.objects.contains(value);
    }

    public static ValueSet parseValueSet(String text, Class<?> itemType) throws IllegalArgumentException {
        Converter<?> converter = ConverterRegistry.getInstance().getConverter(itemType);
        if (converter == null) {
            throw new IllegalArgumentException("itemType");
        }
        StringTokenizer st = new StringTokenizer(text, ",");
        Object[] values = new Object[st.countTokens()];
        int i = 0;
        while (i < values.length) {
            try {
                values[i] = converter.parse(st.nextToken().trim().replace("\\u002C", ","));
            }
            catch (ConversionException e) {
                throw new IllegalArgumentException("text", e);
            }
            ++i;
        }
        return new ValueSet(values);
    }

    public static ValueSet parseValueSet(String[] valueStrings, Converter itemConverter) throws ConversionException {
        Object[] objects = new Object[valueStrings.length];
        int i = 0;
        while (i < valueStrings.length) {
            objects[i] = itemConverter.parse(valueStrings[i]);
            ++i;
        }
        return new ValueSet(objects);
    }
}

