@echo off
echo Extract station daily data
echo Station code according to USAF station number convention
echo Always use 6 digits, else start with 0
echo If ILWIS reports error message "File not found"
echo Abort application and close ILWIS and restart ILWIS
echo Note if ILWIS starts in your active working directory!
echo Start application again
echo.
echo.

set longfilename=%1
set shortfilename1=%longfilename:~0,4%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8
set GSODstation=%9

cd\
%OutputDrive%
cd %OutputDir%

echo your current working directory = %OutputDrive%\%OutputDir%
echo.
echo.
"%UtilDir%\wget\wget.exe" https://www.ncei.noaa.gov/data/global-summary-of-the-day/access/%shortfilename1%/%GSODstation%99999.csv
rem old link "%UtilDir%\wget\wget.exe" ftp://ftp.ncdc.noaa.gov/pub/data/gsod/%shortfilename1%/%GSODstation%-99999-%shortfilename1%.op.gz
rem https://www.ncei.noaa.gov/data/global-summary-of-the-day/access/2021/
echo off
if not exist "%OutputDrive%\%OutputDir%\%GSODstation%99999.csv"  goto MESSAGE
echo The file(s) "%GSODstation%99999.csv" for the year %shortfilename1% has been retrieved and is transferred to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found in the archive.
echo Check your Date stamp settings
echo Your current Date stamp used is %shortfilename1%
echo Data is retrieved from https://www.ncei.noaa.gov/data/global-summary-of-the-day/access/%shortfilename1%/
echo Check also manually if the data exists on ftp archive (see link above)
echo Internet has a transient nature - addresses might not be valid or has changed after some time!


pause

GOTO END

:START



ren %GSODstation%99999.csv GSOD_%GSODstation%_%shortfilename1%.csv

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\GSOD_%GSODstation%_%shortfilename1%.tbt:=table(GSOD_%GSODstation%_%shortfilename1%.csv,Comma,Convert,1,none,STATION(string),DATE(date_GSOD),LATITUDE(value.dom{-90.00:90.00:0.01}),LONGITUDE(value.dom{-180.000000:180.000000:1e-006}),ELEVATION(value.dom{-500.00:8500.00:0.01}),NAME(string),TEMP(value.dom{-100.0:10000.0:0.1}),TEMP_ATTRIBUTES(value.dom{0:100:1}),DEWP(value.dom{-200.0:10000.0:0.1}),DEWP_ATTRIBUTES(value.dom{0:100:1}),SLP(value.dom{-10000.0:10000.0:0.1}),SLP_ATTRIBUTES(value.dom{0:100:1}),STP(value.dom{0.0:1000.0:0.1}),STP_ATTRIBUTES(value.dom{0:100:1}),VISIB(value.dom{0.0:500.0:0.1}),VISIB_ATTRIBUTES(value.dom{0:100:1}),WDSP(value.dom{-100.0:10000.0:0.1}),WDSP_ATTRIBUTES(value.dom{0:100:1}),MXSPD(value.dom{-100.0:10000.0:0.1}),GUST(value.dom{-100.0:1000.0:0.1}),MAX(value.dom{-100.0:10000.0:0.1}),MAX_ATTRIBUTES(string),MIN(value.dom{-250.0:10000.0:0.1}),MIN_ATTRIBUTES(string),PRCP(value.dom{0.00:10000.00:0.01}),PRCP_ATTRIBUTES(string),SNDP(value.dom{0.00:1000.0:0.1}),FRSHTT(value.dom{0:1000000:1})) -import

rem old "%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\GSOD_%GSODstation%_%shortfilename1%.tbt=table(GSOD_%GSODstation%_%shortfilename1%.csv,Fixed,Convert,1,none,6,STN(value.dom{0:1000000:1}),6,WBAN(value.dom{0:100000:1}),10,YEARMODAY(value.dom{0:100000000:1}),8,TEMP(value.dom{-1000:10000:0.1}),3,Count(value.dom{0:100:1}string),8,DEWP(value.dom{-1000:10000:0.1}),3,Count(value.dom{0:100:1}),8,SLP(value.dom{-1000:10000:0.1}),3,Count(value.dom{0:100:1}),8,STP(value.dom{-1000:10000:0.1}),3,Count(value.dom{0:100:1}),7,VISIB(value.dom{0:1000:0.1}),3,Count(value.dom{0:100:1}),7,WDSP(value.dom{0:1000:0.1}),3,Count(value.dom{0:100:1}),7,MXSPD(value.dom{0:1000:0.1}),7,GUST(value.dom{0:1000:0.1}),8,MAX(value.dom{-1000:10000:0.1}),1,Flag_Max(string),7,MIN(value.dom{-1000:10000:0.1}),1,Flag_MIN(string),6,PRCP(value.dom{0:1000:0.01}),1,Flag_PRCP(string),6,SNDP(value.dom{0:1000:0.1}),8,FRSHTT(string))

"%IlwDir%\ilwis.exe" -C tabcalc %OutputDrive%\%OutputDir%\GSOD_%GSODstation%_%shortfilename1%.tbt Temp_C:=iff(temp lt 9999.9,(temp-32)/1.8,?);
"%IlwDir%\ilwis.exe" -C tabcalc %OutputDrive%\%OutputDir%\GSOD_%GSODstation%_%shortfilename1%.tbt TempMIN_C:=iff(min lt 9999.9,(min-32)/1.8,?);
"%IlwDir%\ilwis.exe" -C tabcalc %OutputDrive%\%OutputDir%\GSOD_%GSODstation%_%shortfilename1%.tbt TempMAX_C:=iff(max lt 9999.9,(max-32)/1.8,?);
"%IlwDir%\ilwis.exe" -C tabcalc %OutputDrive%\%OutputDir%\GSOD_%GSODstation%_%shortfilename1%.tbt Dewp_C:=iff(dewp lt 9999.9,(dewp-32)/1.8,?);
"%IlwDir%\ilwis.exe" -C tabcalc %OutputDrive%\%OutputDir%\GSOD_%GSODstation%_%shortfilename1%.tbt Visib_km:=iff(visib lt 999.9,visib*1.609344,?);
"%IlwDir%\ilwis.exe" -C tabcalc %OutputDrive%\%OutputDir%\GSOD_%GSODstation%_%shortfilename1%.tbt Wdsp_kph:=iff(wdsp lt 999.9,wdsp*1.852,?);
"%IlwDir%\ilwis.exe" -C tabcalc %OutputDrive%\%OutputDir%\GSOD_%GSODstation%_%shortfilename1%.tbt Mxspd_kph:=iff(mxspd lt 999.9,mxspd*1.852,?);
"%IlwDir%\ilwis.exe" -C tabcalc %OutputDrive%\%OutputDir%\GSOD_%GSODstation%_%shortfilename1%.tbt Gust_kph:=iff(gust lt 999.9,gust*1.852,?);
"%IlwDir%\ilwis.exe" -C tabcalc %OutputDrive%\%OutputDir%\GSOD_%GSODstation%_%shortfilename1%.tbt Prcp_mm:=iff(prcp lt 99.99,prcp*25.4,?);

del GSOD_%GSODstation%_%shortfilename1%.csv

:END
"%IlwDir%\ilwis.exe" -C closeall
