@echo off

echo MODIS Chlorophyll Alpha (Modis, Mapped 4 KM) - Aqua
echo Input filename format expected is AQUA_MODIS.20200406.L3m.DAY.SST.sst.4km.NRT.nc


set longfilename=%1
set shortfilename1=%longfilename:~0,8%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8
set MODIS_DAY=%9

cd\
%OutputDrive%
cd %OutputDir%

echo %OutputDrive%\%OutputDir%
echo %shortfilename1%



copy "%InputDrive%\%InputDir%\AQUA_MODIS.%shortfilename1%.L3m.DAY.SST.sst.4km.NRT.nc" %OutputDrive%\%OutputDir%\*.*

if not exist "%OutputDrive%\%OutputDir%\AQUA_MODIS.%shortfilename1%.L3m.DAY.SST.sst.4km.NRT.NC" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\AQUA_MODIS.%shortfilename1%.L3m.DAY.SST.sst.4km.NRT.NC" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Your current Julian date stamp used is %modis_day%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START




"%gdalDir%\gdal_translate" -of ilwis HDF5:"AQUA_MODIS.%shortfilename1%.L3m.DAY.SST.sst.4km.NRT.nc"://sst %OutputDrive%\%OutputDir%\tsst%shortfilename1%

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\Modis_sst%shortfilename1%.mpr:=iff(%OutputDrive%\%OutputDir%\tsst%shortfilename1% gt 0,%OutputDrive%\%OutputDir%\tsst%shortfilename1%*0.0049999999,?)
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\Modis_sst%shortfilename1%.mpr %UtilDir%\chloro;

del AQUA_MODIS.%shortfilename1%.L3m.DAY.SST.sst.4km.NRT.nc
del tsst%shortfilename1%.mp*
del tsst%shortfilename1%.aux.xml



:END
"%IlwDir%\ilwis.exe" -C closeall