
@echo off
rem Outgoing longwave radiation
rem Unit is in W/m^2
rem to be confirmed if it is top of atmosphere



set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8
cd\
%OutputDrive%
cd %OutputDir%

echo *%OutputDir%*

copy "%InputDrive%\%InputDir%\Z_SATE_C_BABJ_%shortfilename1%00_O_FY2G_OLR_MLT_003_NOM.AWX.gz" %OutputDrive%\%OutputDir%\*.*

if not exist "%OutputDrive%\%OutputDir%\Z_SATE_C_BABJ_%shortfilename1%00_O_FY2G_OLR_MLT_003_NOM.AWX.gz" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\Z_SATE_C_BABJ_%shortfilename1%00_O_FY2G_OLR_MLT_003_NOM.AWX.gz" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START


"%UtilDir%\7z" e Z_SATE_C_BABJ_%shortfilename1%00_O_FY2G_OLR_MLT_003_NOM.AWX.gz

ren Z_SATE_C_BAWX_*_P_FY2G_OLR_MLT_OTG_*.AWX Z_SATE_C_BABJ_%shortfilename1%00_O_FY2G_OLR_MLT_003_NOM.AWX

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\cma_olr003_FY2G_%shortfilename1%:=map('%OutputDrive%\%OutputDir%\Z_SATE_C_BABJ_%shortfilename1%00_O_FY2G_OLR_MLT_003_NOM.AWX',genras,Convert,1001,4004,Int,2,NoSwap)


"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\cma_olr003_FY2G_%shortfilename1%.mpr %UtilDir%\FY2G_olr.grf 


del Z_SATE_C_BABJ_%shortfilename1%00_O_FY2G_OLR_MLT_003_NOM.AWX.gz
del Z_SATE_C_BABJ_%shortfilename1%00_O_FY2G_OLR_MLT_003_NOM.AWX


:END
"%IlwDir%\ilwis.exe" -C closeall