@echo off
echo Import data retrieved from the Climate Data Store (https://cds.climate.copernicus.eu/#!/home)
echo Input file format expected is NetCDF
echo File name and extension required
echo Import routine allows single parameter import
echo Name of layer to be imported needs to be provided in the CMD window



set longfilename=%1
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%

echo your current working directory = %OutputDrive%\%OutputDir%
echo.
echo.

If not exist "%InputDrive%\%InputDir%\%1"  goto MESSAGE

GOTO START

:MESSAGE
echo The input file was not found in the folder specified.
echo Check your input folder and file name settings
echo Your current input folder and file name used is "%InputDrive%\%InputDir%\%1"


pause

GOTO END

:START

set /p layer_name=Enter Name Data Array to be processed (case sensitive!):
set /p out_name=Enter Name output file to be created:
set /p out_resolution=Enter Data Array Resolution [0.1 or 0.25] degree:

"%GdalDir%\gdal_translate" -of ilwis netcdf:"%InputDrive%\%InputDir%\%1":%layer_name% %out_name% -q

if %out_resolution% equ 0.1 (
del %out_name%.grf
copy %utildir%\era5_01d.grf >nul
ren era5_01d.grf %out_name%.grf
) 

if %out_resolution% equ 0.25 (
del %out_name%.grf
copy %utildir%\era5_025d.csy >nul
copy %utildir%\era5_025d.grf >nul
ren era5_025d.grf %out_name%.grf
) 

del %out_name%.aux.xml

:END
"%IlwDir%\ilwis.exe" -C closeall
