@echo off 
echo TAMSAT RFE product daily rainfall in mm
echo post march 2011 imported from netCDF
echo Current file name convention rfe2022_07_21.v3.1.nc


set longfilename=%1
set shortfilename1=%longfilename:~0,4%
set shortfilename2=%longfilename:~4,2%
set shortfilename3=%longfilename:~6,2%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%

echo rfe%shortfilename1%_%shortfilename2%_%shortfilename3%

echo *%outputDrive%\%OutputDir%*

copy "%inputDrive%\%InputDir%\rfe%shortfilename1%_%shortfilename2%_%shortfilename3%.v*.nc" "%OutputDrive%\%OutputDir%\rfe%shortfilename1%%shortfilename2%%shortfilename3%.v*.nc"

if not exist "%OutputDrive%\%OutputDir%\rfe%shortfilename1%%shortfilename2%%shortfilename3%.v*.nc" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\rfe%shortfilename1%_%shortfilename2%_%shortfilename3%.v*.nc" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START
ren rfe%shortfilename1%%shortfilename2%%shortfilename3%.v*.nc rfe%shortfilename1%%shortfilename2%%shortfilename3%.nc


"%GdalDir%\gdal_translate.exe" -of ilwis HDF5:"rfe%shortfilename1%%shortfilename2%%shortfilename3%.nc"://rfe %OutputDrive%\%OutputDir%\rfe%shortfilename1%%shortfilename2%%shortfilename3%a.mpr

copy "%utildir%\maps\rfeland_mask1.zip"

"%utildir%\7z" e rfeland_mask1.zip
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\rfe%shortfilename1%%shortfilename2%%shortfilename3%a.mpr %Utildir%\rfe_nc
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\rfe%shortfilename1%%shortfilename2%%shortfilename3%b:=ifundef(%OutputDrive%\%OutputDir%\rfe%shortfilename1%%shortfilename2%%shortfilename3%a,0.00)
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\rfe%shortfilename1%%shortfilename2%%shortfilename3%:=iff(%OutputDrive%\%OutputDir%\africaland_mask1=1 and %OutputDrive%\%OutputDir%\rfe%shortfilename1%%shortfilename2%%shortfilename3%b=0,0.00,%OutputDrive%\%OutputDir%\rfe%shortfilename1%%shortfilename2%%shortfilename3%b.mpr)
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\rfe%shortfilename1%%shortfilename2%%shortfilename3%.mpr %utildir%\rfe_nc



del rfe%shortfilename1%%shortfilename2%%shortfilename3%.nc
rem del rfe%shortfilename1%%shortfilename2%%shortfilename3%a.grf
del rfe%shortfilename1%%shortfilename2%%shortfilename3%a.mp*
del rfe%shortfilename1%%shortfilename2%%shortfilename3%b.mp*
del rfeland_mask1.*
del africaland_mask1.*


:END
"%IlwDir%\ilwis.exe" -C closeall