@echo off
echo Import routine for the Copernicus BA 300m OLCI product
echo Yearmonthdekad timestamp is required
echo Temporal resolution is once per 10 days 
echo dekad 1 = 10, dekad 2 = 20 and dekad 3 = last day of the month
echo current version is 2.0.1
echo File name format c_gls_BA300_202112100000_SOAM_S3_V1.2.1.zip
echo Data available from start 2021 onwards
echo.
echo.


echo output BA map is a value map, valid value ranges from 33289 to 65535
echo Layer extracted is FDOB_DEKAD
echo First date of burn in the dekad
echo OLCI BA, the physical range of FDOB is [33289, 65535], as is the Digital Number range. 
echo The value indicates:
echo 0 = no burn scar detected in the dekad
echo 254 = ocean flag
echo 255 = no data present (missing tile) during entire dekad 
echo YYDDD in range [33289, 65365] = the burn scar was detected at day YYDDD; where YY
echo represents the Julian calendar year since 1980 and DDD is day of year; YYDDD is a date in the dekad
echo See https://land.copernicus.eu/global/sites/cgls.vito.be/files/products/CGLOPS1_PUM_BA300m-V1_I1.40.pdf
echo all values below - equal 255 are omitted


set longfilename=%1
set shortfilename1=%longfilename:~0,8%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%

echo your current working directory = %OutputDrive%\%OutputDir%
echo your current time stamp = %shortfilename1%
echo.
echo.


echo off
if not exist "%InputDrive%\%InputDir%\c_gls_BA300_%shortfilename1%0000_SOAM_S3_V*.zip"  goto MESSAGE
echo The file c_gls_BA300_%shortfilename1%0000_SOAM_S3_V*.zip is transferred to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found in the source folder specified
echo Your source folder specified is %InputDrive%\%InputDir%
echo The input file was not found.
echo Check your directory and date stamp settings
echo.
echo Your source folder specified is %InputDrive%\%InputDir%
echo Your current date stamp used is %shortfilename1%
echo Check also manually if the data exists on your input directory - archive 
echo Note the temporal resolution of your data is once a day


pause

GOTO END

:START

rem Import NDVI to ilwis

copy "%InputDrive%\%InputDir%\c_gls_BA300_%shortfilename1%0000_SOAM_S3_V*.zip"

ren c_gls_BA300_%shortfilename1%0000_SOAM_S3_V*.zip ba_%shortfilename1%_SOAM.ZIP

%UtilDir%\7z e ba_%shortfilename1%_SOAM.ZIP %shortfilename1%/c_gls_BA300_%shortfilename1%0000_SOAM_S3_V*.nc



ren c_gls_BA300_%shortfilename1%0000_SOAM_S3_V*.nc ba_OLCI_%shortfilename1%.nc

"%GdalDir%\gdal_translate.exe" -ot Float64 -of ilwis -q HDF5:"ba_OLCI_%shortfilename1%.nc"://FDOB_DEKAD ba_org.mpr
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\ba_org'.mpr '%UtilDir%\ndv_soam_olci300m_pc';

"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\ba_OLCI%shortfilename1%_SOAM'.mpr{dom=value;vr=33289:65365:1}:=iff('%OutputDrive%\%OutputDir%\ba_org' gt 255,'%OutputDrive%\%OutputDir%\ba_org',?);




del ba_org.mp*
del ba_OLCI_%shortfilename1%.nc
del ba_%shortfilename1%_SOAM.ZIP



:END
"%IlwDir%\ilwis.exe" -C closeall