@echo off
echo Import routine for the sentinel 3 Synergy NDVI 10 day compsite product
echo Only yearmonthday timestamp is required of start of 10 day composite period
echo Temporal resolution is once per 10 days
echo File name format S3A_SY_2_V10____20181211T111721_20181221T111721_20181231T130506_AFRICA____________MAR_O_NT_002.SEN3.tar
echo File name format S3A_SY_2_V10____20200314T120000_20200324T120000_20200325T112656_AFRICA____________MAR_O_ST_002.SEN3.tar
rem file name syntax used is S3A_SY_2_V10____%shortfilename1%T??????_????????T??????_????????T??????_AFRICA____________MAR_O_?T_002.SEN3.tar

echo.
echo.



set longfilename=%1
set shortfilename1=%longfilename:~0,8%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8
set Infraview=%9


cd\
%OutputDrive%
cd %OutputDir%

echo your current working directory = %OutputDrive%\%OutputDir%
echo your current time stamp = %shortfilename1%
echo.
echo.


echo off
if not exist "%InputDrive%\%InputDir%\S3A_SY_2_V10____%shortfilename1%T??????_????????T??????_????????T??????_AFRICA____________MAR_O_?T_002.SEN3.tar"  goto MESSAGE
echo The file S3A_SY_2_V10_%shortfilename1% is transferred to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found in the source folder specified
echo Your source folder specified is %InputDrive%\%InputDir%
echo The input file was not found.
echo Check your directory and date stamp settings
echo.


pause

GOTO END

:START

rem Import S3 SYN to ilwis

copy "%InputDrive%\%InputDir%\S3A_SY_2_V10____%shortfilename1%T??????_????????T??????_????????T??????_AFRICA____________MAR_O_?T_002.SEN3.tar"

"%UtilDir%\7z.exe" e "%OutputDrive%\%OutputDir%\S3A_SY_2_V10____%shortfilename1%T??????_????????T??????_????????T??????_AFRICA____________MAR_O_?T_002.SEN3.tar" S3A_SY_2_V10____%shortfilename1%T??????_????????T??????_????????T??????_AFRICA____________MAR_O_?T_002.SEN3/ndvi.nc


"%gdalDir%\gdal_translate.exe" -of ilwis HDF5:"ndvi.nc"://NDVI TS3A_NDVI_V10_%shortfilename1%.mpr
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\TS3A_NDVI_V10_%shortfilename1%'.mpr '%UtilDir%\s3_syn_ndv'
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\S3A_NDVI_V10_%shortfilename1%'.mpr:=iff('%OutputDrive%\%OutputDir%\TS3A_NDVI_V10_%shortfilename1%' lt 255,'%OutputDrive%\%OutputDir%\TS3A_NDVI_V10_%shortfilename1%',?)

del "%OutputDrive%\%OutputDir%\S3A_SY_2_V10____%shortfilename1%T??????_????????T??????_????????T??????_AFRICA____________MAR_O_?T_002.SEN3.tar"
del "%OutputDrive%\%OutputDir%\ndvi.nc"
del "%OutputDrive%\%OutputDir%\TS3A_NDVI_V10_%shortfilename1%.mp*"


:END
"%IlwDir%\ilwis.exe" -C closeall