@echo off 
echo sea water temperature as measured by the MODIS sensor
echo units: degree Celsius
echo filename convention PML_Nigeria_MODIS_sst_refined_20130804204500.nc.bz2

set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
%OutputDrive%
cd %OutputDir%

echo *%outputDrive%\%OutputDir%*

copy "%inputDrive%\%InputDir%\PML_Nigeria_MODIS_sst_refined_%shortfilename1%00.nc.bz2" "%OutputDrive%\%OutputDir%\*.*"

if not exist "%OutputDrive%\%OutputDir%\PML_Nigeria_MODIS_sst_refined_%shortfilename1%00.nc.bz2" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\PML_Nigeria_MODIS_sst_refined_%shortfilename1%00" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the timestamp of your data file

pause

GOTO END

:START

"%UtilDir%\7z" e PML_Nigeria_MODIS_sst_refined_%shortfilename1%00.nc.bz2

"%GdalDir%\gdal_translate.exe" -of ilwis NETCDF:"PML_Nigeria_MODIS_sst_refined_%shortfilename1%00.nc":sst %OutputDrive%\%OutputDir%\PML_Nigeria_MODIS_sst_refined_%shortfilename1%_sst.mpr

"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\PML_Nigeria_MODIS_sst_refined_%shortfilename1%_sst.mpr %UtilDir%\pml_modis_Nigeria.grf;

del PML_Nigeria_MODIS_sst_refined_%shortfilename1%_sst.csy
del PML_Nigeria_MODIS_sst_refined_%shortfilename1%_sst.grf
del PML_Nigeria_MODIS_sst_refined_%shortfilename1%00.nc.bz2
del PML_Nigeria_MODIS_sst_refined_%shortfilename1%00.nc
del PML_Nigeria_MODIS_sst_refined_%shortfilename1%_sst.mpr.aux.xml


:END
"%IlwDir%\ilwis.exe" -C closeall