@echo off 
echo Cloud Temperature /height Import
echo From Nowcasting SAF
echo For Northern portion MSG disk
echo Parameters retrieved are: Cloudiness(%) - Temperature(K)  - Pressure(hPa) - Height(m)
rem Filename convention S_NWC_CTTH_MSG4_MSG-N-VISIR_20200405T041500Z.nc
echo.
echo.


set longfilename=%1
set shortfilename1=%longfilename:~0,8%
set shortfilename2=%longfilename:~8,4%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
%OutputDrive%
cd %OutputDir%

set MSG_number=2

echo *%outputDrive%\%OutputDir%*

copy "%inputDrive%\%InputDir%\S_NWC_CTTH_MSG?_MSG-N-VISIR_%shortfilename1%T%shortfilename2%00Z.nc" "%OutputDrive%\%OutputDir%\*.*"

if exist "%InputDrive%\%InputDir%\S_NWC_CTTH_MSG2_MSG-N-VISIR_%shortfilename1%T%shortfilename2%00Z.nc" GOTO START

set MSG_number=3

if exist "%InputDrive%\%InputDir%\S_NWC_CTTH_MSG3_MSG-N-VISIR_%shortfilename1%T%shortfilename2%00Z.nc" GOTO START

set MSG_number=4

:START1
if not exist "%OutputDrive%\%OutputDir%\S_NWC_CTTH_MSG%MSG_number:~0,1%_MSG-N-VISIR_%shortfilename1%T%shortfilename2%00Z.nc" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\S_NWC_CTTH_MSG%MSG_number:~0,1%_MSG-N-VISIR_%shortfilename1%T%shortfilename2%00Z.nc" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 


pause

GOTO END

:START

echo.
rem Cloudiness
echo Retrieve Cloudiness (from 0 to 1)
echo.

"%GdalDir%\gdal_translate.exe" -of ilwis HDF5:"S_NWC_CTTH_MSG%MSG_number:~0,1%_MSG-N-VISIR_%shortfilename1%T%shortfilename2%00Z.nc"://ctth_effectiv %OutputDrive%\%OutputDir%\NWC_tCTTH_effect_%shortfilename1%%shortfilename2%.mpr
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\NWC_CTTH_effect_%shortfilename1%%shortfilename2%'{dom=value;vr=0.000:100.000:0.001}:='%OutputDrive%\%OutputDir%\NWC_tCTTH_effect_%shortfilename1%%shortfilename2%'*0.00999999998 
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\NWC_CTTH_effect_%shortfilename1%%shortfilename2%'.mpr '%UtilDir%\nwc_kuband'.grf;

del "%OutputDrive%\%OutputDir%\NWC_tCTTH_effect_%shortfilename1%%shortfilename2%.mp*"


echo.
rem Temperature
echo Retrieve Temperature (K)
echo.
"%GdalDir%\gdal_translate.exe" -of ilwis HDF5:"S_NWC_CTTH_MSG4_MSG-N-VISIR_%shortfilename1%T%shortfilename2%00Z.nc"://ctth_tempe %OutputDrive%\%OutputDir%\CTTH_ttemper_%shortfilename1%.mpr
"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\CTTH_ttemper_%shortfilename1%'.mpr '%UtilDir%\nwc_kuband'.grf;
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\NWC_CTTH_temperature_%shortfilename1%%shortfilename2%'{dom=value;vr=0.000:500.000:0.001}:='%OutputDrive%\%OutputDir%\CTTH_ttemper_%shortfilename1%'*0.00999999998

del "%OutputDrive%\%OutputDir%\CTTH_ttemper_%shortfilename1%.mp*

echo.
rem Pressure
echo Retrieve Pressure (Pa)
echo.
"%GdalDir%\gdal_translate.exe" -of ilwis HDF5:"S_NWC_CTTH_MSG4_MSG-N-VISIR_%shortfilename1%T%shortfilename2%00Z.nc"://ctth_pres %OutputDrive%\%OutputDir%\CTTH_tpress_%shortfilename1%.mpr

"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\CTTH_tpress_%shortfilename1%'.mpr '%UtilDir%\nwc_kuband'.grf;
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\NWC_CTTH_pressure_%shortfilename1%%shortfilename2%'{dom=value;vr=0:150000:1}:=iff('%OutputDrive%\%OutputDir%\CTTH_tpress_%shortfilename1%' gt 0,'%OutputDrive%\%OutputDir%\CTTH_tpress_%shortfilename1%'* 10,?)

del "%OutputDrive%\%OutputDir%\CTTH_tpress_%shortfilename1%.mp*

echo.
rem Height 
echo Retrieve Height (M)
echo.
"%GdalDir%\gdal_translate.exe" -of ilwis HDF5:"S_NWC_CTTH_MSG4_MSG-N-VISIR_%shortfilename1%T%shortfilename2%00Z.nc"://ctth_alti %OutputDrive%\%OutputDir%\CTTH_theight_%shortfilename1%.mpr

"%IlwDir%\ilwis.exe" -C setgrf '%OutputDrive%\%OutputDir%\CTTH_theight_%shortfilename1%'.mpr '%UtilDir%\nwc_kuband'.grf;
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\NWC_CTTH_height_%shortfilename1%%shortfilename2%'{dom=value;vr=0:30000:1}:=iff('%OutputDrive%\%OutputDir%\CTTH_theight_%shortfilename1%' gt 0,'%OutputDrive%\%OutputDir%\CTTH_theight_%shortfilename1%',?)


del "%OutputDrive%\%OutputDir%\CTTH_theight_%shortfilename1%.mp*

del "%OutputDrive%\%OutputDir%\S_NWC_CTTH_MSG4_MSG-N-VISIR_%shortfilename1%T%shortfilename2%00Z.nc"


:END
"%IlwDir%\ilwis.exe" -C closeall