@echo off 
rem download setup_xrit2pic_cmd.exe from: http://www.alblas.demon.nl/wsat/software/winsoft_msg.html to tempory directory
rem download setup_gtk20dll.exe from: http://www.alblas.demon.nl/wsat/software/winsoft_msg.html to tempory directory
rem download setup_decompr.exe (JPEG and wvt decompression libs ) from: http://www.alblas.demon.nl/wsat/software/winsoft_msg.html to tempory directory

rem install xrit2pic_cmd to the same temp directory, repeat for setup_gtk20dll.exe - setup_decompr.exe and extract to the same directory

rem copy xrit2pic_cmd.exe and 16 dll files to your ilwis directory \Extensions\GEONETCast-Toolbox\util\xrit2pic


rem Polar orbit satellite tracks can be obained from: http://www.ssec.wisc.edu/datacenter/
rem select from the left hand menu the option: 'Polar Orbit Tracks'
rem select your satellite, e.g. NOAA 18, 19, Metop A (MO2) and 
rem select the region of interest, e.g. Europe, Africa, and
rem select the day and note the date-time of the overpass over your area of interest


rem files available in GEONETCast:
rem NOAA19 GAC
rem sample file name AVHR_GAC_1B_N19_20140805124003Z_20140805124303Z_N_O_20140805135012Z.bz2: 3 minute GAC data (409 columns by 360 lines) 
rem start and end time of file required 

set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set shortfilename2=%longfilename:~13,12%
set shortfilename3=%longfilename:~2,6%
set shortfilename4=%longfilename:~8,4%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%


echo AVHR_GAC_1B_N19_%shortfilename1%03Z_%shortfilename2%03Z_N_O_*.bz2

echo *%outputDrive%\%OutputDir%*

copy "%inputDrive%\%InputDir%\AVHR_GAC_1B_N19_%shortfilename1%03Z_%shortfilename2%03Z_N_O_*.bz2" "%OutputDrive%\%OutputDir%\AVHR_GAC_1B_N19_%shortfilename1%03Z_%shortfilename2%03Z_N_O_*.bz2"

if not exist "%OutputDrive%\%OutputDir%\AVHR_GAC_1B_N19_%shortfilename1%03Z_%shortfilename2%03Z_N_O_*.bz2" goto MESSAGE

echo The file(s) "%InputDrive%\%InputDir%\AVHR_GAC_1B_N19_%shortfilename1%03Z_%shortfilename2%03Z_N_O_*.bz2" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%_%shortfilename2%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END


:START

"%utildir%\7z" e AVHR_GAC_1B_N19_%shortfilename1%03Z_%shortfilename2%03Z_N_O_*.bz2

rem import data and transfer to pgm (Portable Gray Map Image) using xrit2pic_cmd.exe

"%UtilDir%\xrit2pic\xrit2pic_cmd.exe" -src "%OutputDrive%\%OutputDir%" -dest "%OutputDrive%\%OutputDir%" -overwrite -pgm >nul



rem Use gdal to export to ILWIS with following command (note day_time info as replacable parameter):

"%GdalDir%\gdal_translate.exe" -of ilwis GNOAA19_VIS006_%shortfilename3%_%shortfilename4%.pgm NOAA19_g_VIS006_%shortfilename1%.mpr

"%GdalDir%\gdal_translate.exe" -of ilwis GNOAA19_VIS008_%shortfilename3%_%shortfilename4%.pgm NOAA19_g_VIS008_%shortfilename1%.mpr

"%GdalDir%\gdal_translate.exe" -of ilwis GNOAA19_IR_039_%shortfilename3%_%shortfilename4%.pgm NOAA19_g_IR_039_%shortfilename1%.mpr

"%GdalDir%\gdal_translate.exe" -of ilwis GNOAA19_IR_108_%shortfilename3%_%shortfilename4%.pgm NOAA19_g_IR_108_%shortfilename1%.mpr

"%GdalDir%\gdal_translate.exe" -of ilwis GNOAA19_IR_120_%shortfilename3%_%shortfilename4%.pgm NOAA19_g_IR_120_%shortfilename1%.mpr



rem manualy create map list

copy "%UtilDir%\mpl_substitutename.bat" > nul
copy "%UtilDir%\NOAA19_G.mpl" > nul

cmd /c mpl_substitutename.bat ____ _%shortfilename1% NOAA19_G.mpl > NOAA19_G_%shortfilename1%.mpl




del GNOAA19_IR_*.pgm
del GNOAA19_VIS*.pgm
del NOAA19_g_IR_*.mpr.aux.xml
del NOAA19_g_VIS*.mpr.aux.xml
del NOAA19_g.mpl
del mpl_substitutename.bat
del AVHR_GAC_1B_N19_%shortfilename1%03Z_%shortfilename2%03Z_N_O_*.bz2
del AVHR_GAC_1B_N19_%shortfilename1%03Z_%shortfilename2%03Z_N_O_*


:END
"%IlwDir%\ilwis.exe" -C closeall