@echo off
echo Retrieve and display GFS Forecasts
echo.
echo.


set longfilename=%1
set shortfilename1=%longfilename:~0,8%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8
set irfanviewdir=%9

cd\
%OutputDrive%
cd %OutputDir%

echo your current working directory = %OutputDrive%\%OutputDir%
echo your date to be processed = %shortfilename1%
echo.
echo.


echo off
if not exist "%InputDrive%\%InputDir%\ncep_forecast_%shortfilename1%_*.tar"  goto MESSAGE
echo The available input files from "%InputDrive%\%InputDir%\ncep_forecast_%shortfilename1%_africa.*" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input files are not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the local availability of your data

pause

GOTO END

:START

copy "%inputDrive%\%InputDir%\ncep_forecast_%shortfilename1%_*.* 

rem check number of files copies
rem 9 input files are required


dir ncep_forecast_%shortfilename1%_*.tar >chL.txt
findstr /R /N "^" chL.txt | find /C ":" >chL1.txt

setLocal EnableDelayedExpansion
for /f "tokens=* delims= " %%a in (chL1.txt) do (
if !check_varL!'==' set check_varL=%%a
)

rem the file ch.txt consits of 9 lines with filenames and 7 other lines

if %check_varL% NEQ 16 GOTO MESSAGE1
if %check_varL% EQU 16 GOTO START1


:MESSAGE1
echo.
echo ================================================================================
echo Not all required input files are available - note that some links will not work!
echo ================================================================================
echo.
echo.
pause


:START1
"%UtilDir%\7z" x -y ncep_forecast_%shortfilename1%_*.tar 
"%OutputDrive%\%OutputDir%\ncep_forecast_%shortfilename1%\ncep_forecast_%shortfilename1%_africa.html


del "%OutputDrive%\%OutputDir%\ncep_forecast_%shortfilename1%_*.tar

del "%OutputDrive%\%OutputDir%\chL.txt"
del "%OutputDrive%\%OutputDir%\chL1.txt"


:END
"%IlwDir%\ilwis.exe" -C closeall
