@echo off
echo Optimal Cloud Analysis-import
echo 12 output layers
echo Non clouded areas are assigned undefined - not a value
echo Layers at full MSG resolution - extraction and further pre-processing takes some time!
echo Temporal resolution 1 hr
rem new file name: W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET11+OCAE_C_EUMG_20221002053000_1.bin



set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%

copy "%InputDrive%\%InputDir%\W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET11+OCAE_C_EUMG_%shortfilename1%00_1.bin"  

:START1
if not exist "%InputDrive%\%InputDir%\W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET11+OCAE_C_EUMG_%shortfilename1%00_1.bin"  goto MESSAGE
echo The file(s) "%InputDrive%\%InputDir%\W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET11+OCAE_C_EUMG_%shortfilename1%00_1.bin" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END


:START


rename "W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET11+OCAE_C_EUMG_%shortfilename1%00_1.bin" oca%shortfilename1%.grib
"%gdalDir%\gdal_translate.exe" -of ILWIS "%OutputDrive%\%OutputDir%\oca%shortfilename1%.grib" "%OutputDrive%\%OutputDir%\OCAt_%shortfilename1%"
"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\OCA_%shortfilename1%_undef.mpl:=maplistcalculate("iff(@1 ne 9999,@1,?)",0,11,0,OCAt_%shortfilename1%.mpl)
copy "%UtilDir%\OCAT_.csy" %OutputDrive%\%OutputDir%\OCAt_%shortfilename1%.csy"

del oca%shortfilename1%.grib
del OCAt_%shortfilename1%_band_*.mp*
del OCAt_%shortfilename1%.mpl
del OCAt_%shortfilename1%.aux.xml

:END
"%IlwDir%\ilwis.exe" -C closeall