@echo off
echo Clear-Sky Reflectance Map - MSG - 0 degree - import
echo.
echo.
echo Band assignment according to EUMETSAT
echo 1. number of accumulations
echo 2. solar zenith angle
echo 3. relative azimuth angle
echo 4. reflectance in 0.6 micron channel
echo 5. reflectance in 0.8 micron channel
echo 6. reflectance in 1.6 micron channel
echo 7. reflectance in 3.9 micron channel
echo.
echo the 3.9 channel reflectance is a placeholder in the product, it is not
echo produced/calculated at EUMETSAT. Calculating the reflective part of
echo a signal from a near infrared channel is a bit tricky. Hence, all the
echo values are set to 0.
echo.
echo.
echo Temporal resolution 0nce a day, timestamp 12:00 UTC
rem new filename: W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET11+CRM_C_EUMG_20220730120000_1.bin

set longfilename=%1
set shortfilename1=%longfilename:~0,12%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%

copy "%InputDrive%\%InputDir%\W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET11+CRM_C_EUMG_%shortfilename1%00_1.bin"  

if not exist "%InputDrive%\%InputDir%\W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET11+CRM_C_EUMG_%shortfilename1%00_1.bin"  goto MESSAGE
echo The file(s) "%InputDrive%\%InputDir%\W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET11+CRM_C_EUMG_%shortfilename1%00_1.bin" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END


:START

rename "W_XX-EUMETSAT-Darmstadt,SING+LEV+SAT,MET11+CRM_C_EUMG_%shortfilename1%00_1.bin" crm%shortfilename1%.grib
"%gdalDir%\gdal_translate.exe" -of ILWIS "%OutputDrive%\%OutputDir%\crm%shortfilename1%.grib" "%OutputDrive%\%OutputDir%\CRM_%shortfilename1%"


"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\CRM_refl06_%shortfilename1%'.mpr{dom=value;vr=0:100:1}:='%OutputDrive%\%OutputDir%\CRM_%shortfilename1%_Band_4'
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\CRM_refl08_%shortfilename1%'.mpr{dom=value;vr=0:100:1}:='%OutputDrive%\%OutputDir%\CRM_%shortfilename1%_Band_5'
"%IlwDir%\ilwis.exe" -C '%OutputDrive%\%OutputDir%\CRM_refl16_%shortfilename1%'.mpr{dom=value;vr=0:100:1}:='%OutputDrive%\%OutputDir%\CRM_%shortfilename1%_Band_6'

copy %UtilDir%\mpl_substitutename.bat >NUL
copy %UtilDir%\mpef_crm_fcc.mpl >NUL

cmd /c mpl_substitutename.bat ____ _%shortfilename1% mpef_crm_fcc.mpl > mpef_crm_fcc_%shortfilename1%.mpl


del CRM_%shortfilename1%_band_?.mp*
del CRM_%shortfilename1%.mpl
del crm%shortfilename1%.grib
del CRM_%shortfilename1%.aux.xml

del mpl_substitutename.bat
del mpef_crm_fcc.mpl

:END
"%IlwDir%\ilwis.exe" -C closeall