@echo off
echo HSAF MPEG-import
echo temporal resolution 24 hours
echo Output is a value map in mm/24hrs 
echo file name expected is S-HSAF-h05B_20190205_0000_24_fdk.grb.gz
echo note timestamp for hhmm is 00:00 UTC - 0000Z
echo initial rainfall product is the rainfall integrated precipitation from previous day - 24hrs from 00:00 to 23:45!!!!
echo here the timestamp used is correcting the shift and rainfall product is generated for the same day as rainfall integration


set longfilename=%1

rem adjust for the day misalignment
rem the date setting is modified so the rainfall is extracted for the date entered
rem the actual date stamp is providing the rainfall information of H05B as of the day before
rem so for date stamp 20200430 the file having a date stamp of 20200501 is retrieved and processed

set day=+1
echo>"%temp%\%~n0.vbs" i="%longfilename%"
echo>>"%temp%\%~n0.vbs" d=DateSerial(Mid(i,1,4),Mid(i,5,2),Mid(i,7,2))
echo>>"%temp%\%~n0.vbs" s=DateAdd("d",%day%,d)
echo>>"%temp%\%~n0.vbs" WScript.Echo year(s)^& right(100+month(s),2)^& right(100+day(s),2)
for /f %%a in ('cscript /nologo "%temp%\%~n0.vbs"') do set "result=%%a"
del "%temp%\%~n0.vbs"
set "YYYY=%result:~0,4%"
set "MM=%result:~4,2%"
set "DD=%result:~6,2%"
set "nextday=%yyyy%%mm%%dd%"


set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8


cd\
%OutputDrive%
cd %OutputDir%


copy "%InputDrive%\%InputDir%\S-HSAF-h05B_%nextday%_0000_24_fdk.grb.gz" 


if not exist "%InputDrive%\%InputDir%\S-HSAF-h05B_%nextday%_0000_24_fdk.grb.gz"  goto MESSAGE
echo The file(s) "%InputDrive%\%InputDir%\S-HSAF-h05B_%nextday%_0000_24_fdk.grb.gz" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START

"%UtilDir%\7z" e %OutputDrive%\%OutputDir%\S-HSAF-h05B_%nextday%_0000_24_fdk.grb.gz
"%gdalDir%\gdal_translate.exe" -of ilwis "h05B_%nextday%_0000_24_fdk.grb" %OutputDrive%\%OutputDir%\h05B_%nextday%_24.mpr

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\MPEG_H05B_%longfilename%.mpr{dom=value;vr=0:1000:0.00001}:=iff(%OutputDrive%\%OutputDir%\h05B_%nextday%_24_band_1 gt 0.01,%OutputDrive%\%OutputDir%\h05B_%nextday%_24_band_1,?)
"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\MPEG_H05B_%longfilename%.mpr %UtilDir%\mpe_georef


del h05B_%nextday%_24.grf
del h05B_%nextday%_24.csy
del h05B_%nextday%_24.mpr.aux*
del h05B_%nextday%_24_band_?.mp*
del h05B_%nextday%_24.mpl
del S-HSAF-h05B_%nextday%_0000_24_fdk.grb.gz
del h05B_%nextday%_0000_24_fdk.grb

:END
"%IlwDir%\ilwis.exe" -C closeall