@echo off
rem file name convention is S-CM_CFCmm20200301000041023SVMSG01MA.nc
rem only yyyymmdd is required

set longfilename=%1
set shortfilename1=%longfilename:~0,6%
set InputDrive=%2
set InputDir=%3
set OutputDrive=%4
set OutputDir=%5
set gdalDir=%6
set IlwDir=%7
set UtilDir=%8

cd\
%OutputDrive%
cd %OutputDir%

echo *%OutputDir%*


copy "%InputDrive%\%InputDir%\S-CM_CFCmm%shortfilename1%*.nc" "%OutputDrive%\%OutputDir%\*.*"


if not exist "%OutputDrive%\%OutputDir%\S-CM_CFCmm%shortfilename1%*.nc" goto MESSAGE
echo The file(s) "%InputDrive%\%InputDir%\S-CM_CFCmm%shortfilename1%*.nc" will be copied to your current working directory
echo.
echo.

GOTO START

:MESSAGE
echo The input file was not found.
echo Check your directory and date stamp settings
echo Your current date stamp used is %shortfilename1%
echo Check also if the data exists on your input directory - archive 
echo Note the temporal resolution of your data

pause

GOTO END

:START

ren %OutputDrive%\%OutputDir%\S-CM_CFCmm%shortfilename1%*.nc S-CM_CFCmm%shortfilename1%.nc 

"%gdalDir%\gdal_translate" -of ilwis hdf5:"S-CM_CFCmm%shortfilename1%.nc"://cfc "%OutputDrive%\%OutputDir%\T_cfc_%shortfilename1%"

"%IlwDir%\ilwis.exe" -C CM_tcfc_%shortfilename1%.mpr:=MapMirrorRotate(T_cfc_%shortfilename1%,MirrHor)

"%IlwDir%\ilwis.exe" -C setgrf %OutputDrive%\%OutputDir%\CM_tcfc_%shortfilename1%.mpr %UtilDir%\CM_CFC;

"%IlwDir%\ilwis.exe" -C %OutputDrive%\%OutputDir%\CM_CFC_%shortfilename1%.mpr:=iff(%OutputDrive%\%OutputDir%\CM_tcfc_%shortfilename1% ge 0,%OutputDrive%\%OutputDir%\CM_tcfc_%shortfilename1%,?)


del T_cfc_%shortfilename1%.mp*
del CM_tcfc_%shortfilename1%.mp*
del *.xml
del S-CM_CFCmm%shortfilename1%.nc 

:END
"%IlwDir%\ilwis.exe" -C closeall