import java.awt.Component;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;


public class Value {
	private Object objectVal;
	private String stringVal;
	private Integer intVal;
	private Boolean boolVal;

	public Value(Object val) {
		this.objectVal = val;
		this.stringVal = null;
		this.intVal = null;
		this.boolVal = null;
	}
	
	public Value(String val) {
		this.objectVal = null;
		this.stringVal = val;
		this.intVal = null;
		this.boolVal = null;
	}
	
	public Value(Integer val) {
		this.objectVal = null;
		this.stringVal = null;
		this.intVal = val;
		this.boolVal = null;
	}
	
	public Value(Boolean val) {
		this.objectVal = null;
		this.stringVal = null;
		this.intVal = null;
		this.boolVal = val;
	}
	
	public void setVal(Object val) {
		this.objectVal = val;
	}
	
	public void setVal(String val) {
		if (intVal != null)
			intVal = Integer.parseInt(val);
		else
			stringVal = val;
	}
	
	public void setVal(Integer val) {
		if (intVal != null)
			intVal = val;
		else
			stringVal = val.toString();
	}
	
	public void setVal(Boolean val) {
		boolVal = val;
	}
	
	public Object getObjectVal() {
		return objectVal;
	}
	
	public String getStringVal() {
		if (intVal != null)
			return intVal.toString();
		else
			return stringVal;
	}
	
	public Integer getIntVal() {
		if (intVal != null)
			return intVal;
		else
			return Integer.parseInt(stringVal);
	}
	
	public Boolean getBoolVal() {
		return boolVal;
	}

	public void setValFrom(Component component) {
		if (component instanceof JCheckBox)
			boolVal = ((JCheckBox)component).isSelected();
		else if (component instanceof JTextField) {
			if (intVal != null)
				intVal = Integer.parseInt(((JTextField)component).getText());
			else if (stringVal != null)
				stringVal = ((JTextField)component).getText();
		}
		else if (component instanceof JComboBox)
			objectVal = ((JComboBox)component).getSelectedItem();
	}

	public void putValInto(Component component) {
		if (component instanceof JCheckBox)
			((JCheckBox)component).setSelected(boolVal);
		else if (component instanceof JTextField) {
			if (intVal != null)
				((JTextField)component).setText("" + intVal);
			else if (stringVal != null)
				((JTextField)component).setText(stringVal);
		}
		else if (component instanceof JComboBox)
			((JComboBox)component).setSelectedItem(objectVal);
	}
	
	public String toString() {
		if (boolVal != null)
			return boolVal?"true":"false";
		else if (intVal != null)
			return intVal.toString();
		else if (stringVal != null)
			return stringVal;
		else if (objectVal != null)
			return objectVal.toString();
		else
			return "error";
	}
}
