/*
 * Decompiled with CFR 0.152.
 */
package org.n52.operation.gs.spatial.location.sort;

import com.vividsolutions.jts.algorithm.CentroidArea;
import com.vividsolutions.jts.algorithm.CentroidPoint;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import com.vividsolutions.jts.operation.distance.DistanceOp;
import com.vividsolutions.jts.operation.distance.GeometryLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.n52.operation.gs.spatial.location.sort.AdjacencyList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdjacencyListByGeometry
implements AdjacencyList {
    Methods method = Methods.byAnchor;
    Geometry anchor = null;
    String attribute;
    HashMap<String, List<Integer>> neighbours;
    List<Feature> adjacencyList;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    @Override
    public List<Feature> getAdjecencyList(List<Feature> inputList) {
        if (this.method == Methods.byAnchor) {
            return this.sortByAnchor(inputList);
        }
        if (this.method == Methods.byNeighbourhood) {
            return this.sortByNeighbourhood(inputList);
        }
        return null;
    }

    private List<Feature> sortByAnchor(List<Feature> features) {
        Object attrib;
        ArrayList<Feature> sorted = new ArrayList<Feature>();
        ArrayList<FeatureDistance> sorting = new ArrayList<FeatureDistance>();
        ArrayList<FeatureByAttribute> fbaList = new ArrayList<FeatureByAttribute>();
        GeometryFactory geofac = features.get(0).getDefaultGeometry().getFactory();
        for (Feature f : features) {
            FeatureByAttribute fba = new FeatureByAttribute();
            fba.feature = f;
            fba.attribute = this.attribute;
            fbaList.add(fba);
        }
        Collections.sort(fbaList);
        CentroidArea ca = null;
        CentroidPoint cp = null;
        FeatureType type = features.get(0).getFeatureType();
        Class clas = type.getDefaultGeometry().getType();
        if (clas.equals(Polygon.class) || clas.equals(MultiPolygon.class)) {
            ca = new CentroidArea();
        } else if (clas.equals(Point.class) || clas.equals(MultiPoint.class)) {
            cp = new CentroidPoint();
        } else {
            return null;
        }
        int size = fbaList.size();
        int index = 0;
        FeatureByAttribute fba = (FeatureByAttribute)fbaList.get(index);
        FeatureByAttribute fbaOld = null;
        Object attribOld = attrib = fba.feature.getAttribute(this.attribute);
        while (index < size) {
            if (cp != null) {
                cp = new CentroidPoint();
            } else {
                ca = new CentroidArea();
            }
            while (attrib.equals(attribOld)) {
                if (cp != null) {
                    cp.add(fba.feature.getDefaultGeometry());
                } else {
                    ca.add(fba.feature.getDefaultGeometry());
                }
                fbaOld = fba;
                if (++index < size) {
                    fba = (FeatureByAttribute)fbaList.get(index);
                    attrib = fba.feature.getAttribute(this.attribute);
                    continue;
                }
                attrib = new Object();
            }
            attribOld = attrib;
            Coordinate crd = null;
            crd = cp != null ? cp.getCentroid() : ca.getCentroid();
            Coordinate[] coords = new Coordinate[]{crd};
            CoordinateArraySequence seq = new CoordinateArraySequence(coords);
            Point pnt = new Point((CoordinateSequence)seq, geofac);
            DistanceOp dop = new DistanceOp((Geometry)pnt, this.anchor);
            GeometryLocation loc = dop.closestLocations()[1];
            Coordinate cross = loc.getCoordinate();
            FeatureDistance fd = new FeatureDistance();
            fd.feature = fbaOld.feature;
            fd.centroid = crd;
            fd.index = cross;
            sorting.add(fd);
        }
        Collections.sort(sorting);
        for (FeatureDistance fd : sorting) {
            sorted.add(fd.feature);
        }
        return sorted;
    }

    private List<Feature> sortByNeighbourhood(List<Feature> features) {
        List<Feature> sortedFeatures = this.sortByAnchor(features);
        Feature startFeature = sortedFeatures.get(0);
        this.neighbours = new HashMap();
        for (Feature feature : sortedFeatures) {
            for (Feature candidate : features) {
                Geometry currentGeometry;
                if (feature.getID().equals(candidate.getID()) || !(currentGeometry = feature.getDefaultGeometry()).touches(candidate.getDefaultGeometry())) continue;
                if (this.neighbours.get(feature.getID()) == null) {
                    this.neighbours.put(feature.getID(), new ArrayList());
                }
                if (this.neighbours.get(feature.getID()).contains(candidate)) continue;
                this.neighbours.get(feature.getID()).add(sortedFeatures.indexOf(candidate));
            }
        }
        Set<String> keys = this.neighbours.keySet();
        for (String key : keys) {
            List<Integer> list = this.neighbours.get(key);
            Collections.sort(list);
            this.neighbours.put(key, list);
        }
        this.adjacencyList = new ArrayList<Feature>();
        Feature currentFeature = startFeature;
        this.adjacencyList.add(startFeature);
        ArrayList<Feature> available = new ArrayList<Feature>();
        available.addAll(sortedFeatures);
        while (available.size() > 1) {
            this.moveToNext(sortedFeatures, available, currentFeature);
            if (available.size() <= 1) continue;
            currentFeature = available.get(1);
        }
        return this.adjacencyList;
    }

    private void moveToNext(List<Feature> sortedFeatures, List<Feature> available, Feature currentFeature) {
        List<Integer> neighbourList = this.neighbours.get(currentFeature.getID());
        if (neighbourList != null) {
            for (Integer index : neighbourList) {
                Feature candidate = sortedFeatures.get(index);
                if (this.adjacencyList.contains(candidate)) continue;
                this.adjacencyList.add(candidate);
                available.remove(candidate);
                this.moveToNext(sortedFeatures, available, candidate);
            }
        } else if (!this.adjacencyList.contains(currentFeature)) {
            this.adjacencyList.add(currentFeature);
            available.remove(currentFeature);
        }
    }

    public void setAnchor(Geometry anchor) {
        this.anchor = anchor;
    }

    public void setMethod(Methods method) {
        this.method = method;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Methods {
        byAnchor,
        byNeighbourhood;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FeatureDistance
    implements Comparable<FeatureDistance> {
        public Feature feature;
        public Coordinate index;
        public Coordinate centroid;

        @Override
        public int compareTo(FeatureDistance fd) {
            if (this.index.x < fd.index.x) {
                return -1;
            }
            if (this.index.x > fd.index.x) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FeatureByAttribute
    implements Comparable<FeatureByAttribute> {
        public Feature feature;
        public String attribute;

        @Override
        public int compareTo(FeatureByAttribute fd) {
            try {
                Comparable obj1 = (Comparable)this.feature.getAttribute(this.attribute);
                Comparable obj2 = (Comparable)fd.feature.getAttribute(this.attribute);
                return obj1.compareTo(obj2);
            }
            catch (ClassCastException ex) {
                return 0;
            }
        }
    }
}

