/*
 * Decompiled with CFR 0.152.
 */
package org.n52.operation.fluxnet;

import com.sun.org.apache.xpath.internal.XPathAPI;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.n52.math.AbstractAlgorithm;
import org.n52.math.Algorithm;
import org.n52.math.AlgorithmOnList;
import org.n52.math.testforms.AlgorithmsForm;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FluxNetAlgorithm
implements AlgorithmOnList {
    private int nins;
    private int nhids;
    private int nouts;
    private int nunits;
    private Unit[] Units;
    private int[] Input;
    private int[] Hidden;
    private int[] Output;
    private double[] scalingInSlope;
    private double[] scalingInOffset;
    private double[] scalingOutSlope;
    private double[] scalingOutOffset;
    private String[] paramNames;
    private String[] paramDescriptions;
    private String[] outputNames;
    private String[] outputDescriptions;

    public FluxNetAlgorithm(String netFile, String configFile) {
        this.init(netFile, configFile);
    }

    private void init(String netFile, String configFile) {
        try {
            this.loadNetworkFile(netFile);
            this.loadConfigFile(configFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadConfigFile(String configFile) throws IllegalArgumentException, ParserConfigurationException, SAXException, IOException, TransformerException {
        String scalingSlope;
        String scalingOffset;
        String description;
        String name;
        Node n2;
        Node n;
        Document doc = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder build = factory.newDocumentBuilder();
        try {
            doc = build.parse(configFile);
        }
        catch (MalformedURLException mue) {
            doc = build.parse(new File(configFile));
        }
        NodeList nodes = XPathAPI.selectNodeList(doc.getDocumentElement(), "/FluxnetAlgorithmConfiguration/InputParameters/Parameter");
        if (nodes.getLength() != this.nins) {
            throw new IllegalArgumentException("error -- Number of input parameters in network file and config file differs.");
        }
        this.scalingInOffset = new double[this.nins];
        this.scalingInSlope = new double[this.nins];
        this.paramNames = new String[this.nins];
        this.paramDescriptions = new String[this.nins];
        int i = 0;
        while (i < this.nins) {
            n = nodes.item(i);
            n2 = XPathAPI.selectSingleNode(n, "Name/text()");
            name = n2.getNodeValue();
            n2 = XPathAPI.selectSingleNode(n, "Description/text()");
            description = n2.getNodeValue();
            n2 = XPathAPI.selectSingleNode(n, "ScalingOffset/text()");
            scalingOffset = n2.getNodeValue();
            n2 = XPathAPI.selectSingleNode(n, "ScalingSlope/text()");
            scalingSlope = n2.getNodeValue();
            this.paramNames[i] = name;
            this.paramDescriptions[i] = description;
            this.scalingInOffset[i] = Double.parseDouble(scalingOffset);
            this.scalingInSlope[i] = Double.parseDouble(scalingSlope);
            ++i;
        }
        nodes = XPathAPI.selectNodeList(doc.getDocumentElement(), "/FluxnetAlgorithmConfiguration/OutputParameters/Parameter");
        if (nodes.getLength() != this.nouts) {
            throw new IllegalArgumentException("error -- Number of output parameters in network file and config file differs.");
        }
        this.scalingOutOffset = new double[this.nouts];
        this.scalingOutSlope = new double[this.nouts];
        this.outputNames = new String[this.nouts];
        this.outputDescriptions = new String[this.nouts];
        i = 0;
        while (i < this.nouts) {
            n = nodes.item(i);
            n2 = XPathAPI.selectSingleNode(n, "Name/text()");
            name = n2.getNodeValue();
            n2 = XPathAPI.selectSingleNode(n, "Description/text()");
            description = n2.getNodeValue();
            n2 = XPathAPI.selectSingleNode(n, "ScalingOffset/text()");
            scalingOffset = n2.getNodeValue();
            n2 = XPathAPI.selectSingleNode(n, "ScalingSlope/text()");
            scalingSlope = n2.getNodeValue();
            this.outputNames[i] = name;
            this.outputDescriptions[i] = description;
            this.scalingOutOffset[i] = Double.parseDouble(scalingOffset);
            this.scalingOutSlope[i] = Double.parseDouble(scalingSlope);
            ++i;
        }
    }

    private String[] split(String str, char c) {
        int count = 1;
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == c) {
                ++count;
            }
            ++i;
        }
        String[] ret = new String[count];
        int fromIndex = 0;
        int fillIndex = 0;
        int i2 = 0;
        while (i2 < count) {
            int toIndex = str.indexOf(c, fromIndex);
            if (toIndex < 0) {
                toIndex = str.length();
            }
            ret[fillIndex++] = str.substring(fromIndex, toIndex).trim();
            fromIndex = toIndex + 1;
            ++i2;
        }
        return ret;
    }

    private void loadNetworkFile(String netFile) {
        BufferedReader input = null;
        try {
            try {
                try {
                    URL u = new URL(netFile);
                    URLConnection uc = u.openConnection();
                    input = new BufferedReader(new InputStreamReader(uc.getInputStream()));
                }
                catch (MalformedURLException mue) {
                    input = new BufferedReader(new FileReader(netFile));
                }
                String line = null;
                while ((line = input.readLine()) != null && !line.contains("network name")) {
                }
                String netName = this.split(line, ':')[1];
                while ((line = input.readLine()) != null && !line.contains("no. of units")) {
                }
                this.nunits = Integer.parseInt(this.split(line, ':')[1]);
                while ((line = input.readLine()) != null && !line.contains("unit default section")) {
                }
                line = input.readLine();
                line = input.readLine();
                line = input.readLine();
                line = input.readLine();
                String actFunction = this.split(line, '|')[5];
                if (actFunction.compareTo("Act_Logistic") != 0) {
                    throw new UnsupportedOperationException("error in unit default section of network file -- Activation function named in input file must be Act_Logistic.  Network would not function properly.");
                }
                while ((line = input.readLine()) != null && !line.contains("unit definition section")) {
                }
                line = input.readLine();
                line = input.readLine();
                line = input.readLine();
                this.nins = 0;
                this.nhids = 0;
                this.nouts = 0;
                double[] bias = new double[this.nunits];
                int[] type = new int[this.nunits];
                int i = 0;
                while (i < this.nunits) {
                    line = input.readLine();
                    String[] a = this.split(line, '|');
                    if (Integer.parseInt(a[0]) - 1 != i) {
                        throw new UnsupportedOperationException("error in unit definition section of network file -- units not in expected order");
                    }
                    bias[i] = Double.parseDouble(a[4]);
                    if (a[5].compareTo("i") == 0) {
                        type[i] = 1;
                        ++this.nins;
                    } else if (a[5].compareTo("h") == 0) {
                        type[i] = 2;
                        ++this.nhids;
                    } else if (a[5].compareTo("o") == 0) {
                        type[i] = 3;
                        ++this.nouts;
                    }
                    ++i;
                }
                while ((line = input.readLine()) != null && !line.contains("connection definition section")) {
                }
                line = input.readLine();
                line = input.readLine();
                line = input.readLine();
                int[] nsrcs = new int[this.nunits];
                int[][] source = new int[this.nunits][this.nunits];
                double[][] weight = new double[this.nunits][this.nunits];
                int i2 = 0;
                while (i2 < this.nunits) {
                    nsrcs[i2] = 0;
                    int j = 0;
                    while (j < this.nunits) {
                        source[i2][j] = 0;
                        weight[i2][j] = 0.0;
                        ++j;
                    }
                    ++i2;
                }
                int iunit = 0;
                while (iunit < this.nhids + this.nouts) {
                    line = input.readLine();
                    while (line.endsWith(",")) {
                        String concatline = input.readLine();
                        if (concatline == null) continue;
                        line = String.valueOf(line) + " " + concatline;
                    }
                    String[] field = this.split(line, '|');
                    String unit = field[0];
                    int unitnr = Integer.parseInt(unit) - 1;
                    String sourceWeightPairList = field[2];
                    String[] sourceWeightPair = this.split(sourceWeightPairList, ',');
                    nsrcs[unitnr] = sourceWeightPair.length;
                    int j = 0;
                    while (j < nsrcs[unitnr]) {
                        String[] subf = this.split(sourceWeightPair[j], ':');
                        int sourcenr = Integer.parseInt(subf[0]) - 1;
                        source[unitnr][sourcenr] = 1;
                        weight[unitnr][sourcenr] = Double.parseDouble(subf[1]);
                        ++j;
                    }
                    ++iunit;
                }
                this.Input = new int[this.nins];
                int index = 0;
                int i3 = 0;
                while (i3 < this.nunits) {
                    if (type[i3] == 1) {
                        this.Input[index++] = i3;
                    }
                    ++i3;
                }
                this.Hidden = new int[this.nhids];
                index = 0;
                i3 = 0;
                while (i3 < this.nunits) {
                    if (type[i3] == 2) {
                        this.Hidden[index++] = i3;
                    }
                    ++i3;
                }
                this.Output = new int[this.nouts];
                index = 0;
                i3 = 0;
                while (i3 < this.nunits) {
                    if (type[i3] == 3) {
                        this.Output[index++] = i3;
                    }
                    ++i3;
                }
                this.Units = new Unit[this.nunits];
                int unit = 0;
                while (unit < this.nunits) {
                    this.Units[unit] = new Unit();
                    this.Units[unit].activation = 0.0;
                    this.Units[unit].bias = bias[unit];
                    this.Units[unit].sources = new int[this.nunits];
                    this.Units[unit].weights = new double[this.nunits];
                    int s = 0;
                    while (s < this.nunits) {
                        this.Units[unit].sources[s] = source[unit][s];
                        this.Units[unit].weights[s] = weight[unit][s];
                        ++s;
                    }
                    ++unit;
                }
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        String networkfile = args[0];
        String configfile = args[1];
        FluxNetAlgorithm aol = new FluxNetAlgorithm(networkfile, configfile);
        double[] defaults = new double[]{270.05, 0.954, 5.0, 0.397, 1.0, 56.3, 0.107, 4.1, 219.9, 0.97, 27.67, 0.17, 6.647, 6306.54};
        AlgorithmsForm framekb_1 = new AlgorithmsForm(aol, defaults);
        framekb_1.setDefaultCloseOperation(3);
        framekb_1.setTitle("FluxNet");
        framekb_1.setVisible(true);
    }

    public double[] calculate(double[] params) {
        double[] scaledinput = this.scaleInput(params);
        double[] scaledresult = this.net(scaledinput);
        double[] result = this.scaleOutput(scaledresult);
        return result;
    }

    private double[] scaleInput(double[] input) {
        int i = 0;
        while (i < this.nins) {
            input[i] = (input[i] - this.scalingInOffset[i]) / this.scalingInSlope[i];
            ++i;
        }
        return input;
    }

    private double[] scaleOutput(double[] output) {
        int i = 0;
        while (i < this.nouts) {
            output[i] = output[i] * this.scalingOutSlope[i] + this.scalingOutOffset[i];
            ++i;
        }
        return output;
    }

    private double actLogistic(double sum, double bias) {
        if (sum + bias < 10000.0) {
            return 1.0 / (1.0 + Math.exp(-sum - bias));
        }
        return 0.0;
    }

    private double[] net(double[] scaledinput) {
        int source;
        double sum;
        Unit unit;
        int member = 0;
        while (member < this.nins) {
            this.Units[this.Input[member]].activation = scaledinput[member];
            ++member;
        }
        member = 0;
        while (member < this.nhids) {
            unit = this.Units[this.Hidden[member]];
            sum = 0.0;
            source = 0;
            while (source < this.nunits) {
                if (unit.sources[source] == 1) {
                    sum += this.Units[source].activation * unit.weights[source];
                }
                ++source;
            }
            unit.activation = this.actLogistic(sum, unit.bias);
            ++member;
        }
        member = 0;
        while (member < this.nouts) {
            unit = this.Units[this.Output[member]];
            sum = 0.0;
            source = 0;
            while (source < this.nunits) {
                if (unit.sources[source] == 1) {
                    sum += this.Units[source].activation * unit.weights[source];
                }
                ++source;
            }
            unit.activation = this.actLogistic(sum, unit.bias);
            ++member;
        }
        double[] scaledoutput = new double[this.nouts];
        int member2 = 0;
        while (member2 < this.nouts) {
            scaledoutput[member2] = this.Units[this.Output[member2]].activation;
            ++member2;
        }
        return scaledoutput;
    }

    public int getNrParams() {
        return this.nins;
    }

    public String getParamName(int paramNr) throws IndexOutOfBoundsException {
        return this.paramNames[paramNr];
    }

    public String getParamDescription(int paramNr) throws IndexOutOfBoundsException {
        return this.paramDescriptions[paramNr];
    }

    public int getNrAlgorithms() {
        return this.nouts;
    }

    private double[] thisCalculate(double[] params) {
        return this.calculate(params);
    }

    public Algorithm getAlgorithm(int index) {
        final int ind = index;
        return new AbstractAlgorithm(this.outputNames[ind], this.outputDescriptions[ind], this.paramNames, this.paramDescriptions){

            public double calculate(double[] params) {
                double[] result = FluxNetAlgorithm.this.thisCalculate(params);
                return result[ind];
            }
        };
    }

    private class Unit {
        double activation;
        double bias;
        int[] sources;
        double[] weights;

        Unit() {
        }
    }
}

