/*
 * Decompiled with CFR 0.152.
 */
package org.n52.math.testforms;

import java.util.ArrayList;
import java.util.Iterator;
import org.n52.math.Algorithm;
import org.n52.math.AlgorithmOnList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericAlgorithms
extends ArrayList<Algorithm>
implements AlgorithmOnList {
    private Algorithm longestAlgorithm;
    private int lastModCount;

    @Override
    public double[] calculate(double[] params) {
        this.Check();
        double[] result = new double[this.getNrAlgorithms()];
        int i = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            result[i] = ((Algorithm)iter.next()).calculate(params);
            ++i;
        }
        return result;
    }

    @Override
    public int getNrParams() {
        this.Check();
        return this.longestAlgorithm.getNrParams();
    }

    @Override
    public String getParamName(int paramNr) throws IndexOutOfBoundsException {
        this.Check();
        return this.longestAlgorithm.getParamName(paramNr);
    }

    @Override
    public String getParamDescription(int paramNr) throws IndexOutOfBoundsException {
        this.Check();
        return this.longestAlgorithm.getParamDescription(paramNr);
    }

    @Override
    public int getNrAlgorithms() {
        return this.size();
    }

    @Override
    public Algorithm getAlgorithm(int index) {
        return (Algorithm)this.get(index);
    }

    private void Check() {
        if (this.lastModCount == this.modCount) {
            return;
        }
        int maxParams = 0;
        for (Algorithm alg : this) {
            if (alg.getNrParams() <= maxParams) continue;
            maxParams = alg.getNrParams();
            this.longestAlgorithm = alg;
        }
        this.lastModCount = this.modCount;
    }
}

