/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Formatter;
import ucar.nc2.constants.CDM;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.grib2.Grib2Parameter;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.grib.grib2.table.Grib2Table;
import ucar.nc2.grib.grib2.table.NcepLocalTables;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarPeriod;
import ucar.unidata.util.StringUtil2;

public class CfsrLocalTables
extends NcepLocalTables {
    private static final String tableName = "resources/grib2/local/cfsr.txt";
    private static boolean debug = false;
    private static CfsrLocalTables single;

    public static CfsrLocalTables getCust(Grib2Table table) {
        if (single == null) {
            single = new CfsrLocalTables(table);
        }
        return single;
    }

    private CfsrLocalTables(Grib2Table grib2Table) {
        super(grib2Table);
        if (grib2Table.getPath() == null) {
            grib2Table.setPath(tableName);
        }
        this.initLocalTable();
    }

    @Override
    public String getTablePath(int discipline, int category, int number) {
        if (category <= 191 && number <= 191) {
            return super.getTablePath(discipline, category, number);
        }
        return tableName;
    }

    @Override
    public String getGeneratingProcessName(int genProcess) {
        switch (genProcess) {
            case 197: {
                return "CFSR";
            }
        }
        return super.getGeneratingProcessName(genProcess);
    }

    @Override
    public int[] getForecastTimeIntervalOffset(Grib2Record gr) {
        int end;
        int start;
        Grib2Pds pds = gr.getPDS();
        if (!pds.isTimeInterval()) {
            return null;
        }
        int statType = pds.getOctet(47);
        int n = pds.getInt4StartingAtOctet(50);
        int p2 = pds.getInt4StartingAtOctet(55);
        int p2mp1 = pds.getInt4StartingAtOctet(62);
        int p1 = p2 - p2mp1;
        switch (statType) {
            case 193: {
                start = p1;
                end = p1 + n * p2;
                break;
            }
            case 194: {
                start = 0;
                end = n * p2;
                break;
            }
            case 195: 
            case 204: 
            case 205: {
                start = p1;
                end = p2;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown statType " + statType);
            }
        }
        return new int[]{start, end};
    }

    @Override
    public TimeCoord.TinvDate getForecastTimeInterval(Grib2Record gr) {
        Grib2Pds pds = gr.getPDS();
        if (!pds.isTimeInterval()) {
            return null;
        }
        int[] intv = this.getForecastTimeIntervalOffset(gr);
        assert (intv != null);
        int intvLen = intv[1] - intv[0];
        int timeUnitOrg = pds.getTimeUnit();
        int timeUnitConvert = this.convertTimeUnit(timeUnitOrg);
        CalendarPeriod unitPeriod = Grib2Utils.getCalendarPeriod(timeUnitConvert);
        if (unitPeriod == null) {
            throw new IllegalArgumentException("unknown CalendarPeriod " + timeUnitConvert + " org=" + timeUnitOrg);
        }
        CalendarPeriod.Field fld = unitPeriod.getField();
        CalendarDate start = gr.getReferenceDate().add(intv[0], fld);
        CalendarPeriod period = CalendarPeriod.of(intvLen, fld);
        return new TimeCoord.TinvDate(start, period);
    }

    @Override
    public double getForecastTimeIntervalSizeInHours(Grib2Pds pds) {
        return 6.0;
    }

    private boolean isCfsr2(Grib2Pds pds) {
        int genType = pds.getGenProcessId();
        if (genType != 82 && genType != 89) {
            return false;
        }
        Grib2Pds.PdsInterval pdsIntv = (Grib2Pds.PdsInterval)((Object)pds);
        Grib2Pds.TimeInterval[] ti = pdsIntv.getTimeIntervals();
        return ti.length != 1;
    }

    @Override
    public void showSpecialPdsInfo(Grib2Record gr, Formatter f) {
        Grib2Pds pds = gr.getPDS();
        if (!pds.isTimeInterval()) {
            return;
        }
        if (pds.getRawLength() < 65) {
            return;
        }
        int statType = pds.getOctet(47);
        int statType2 = pds.getOctet(59);
        int ngrids = pds.getInt4StartingAtOctet(50);
        int p2 = pds.getInt4StartingAtOctet(55);
        int p2mp1 = pds.getInt4StartingAtOctet(62);
        f.format("%nCFSR MM special encoding (NCAR)%n", new Object[0]);
        f.format("  (47) Code Table 4.10 = %d%n", statType);
        f.format("  (50-53) N in avg     = %d%n", ngrids);
        f.format("  (55-58) Grib1 P2     = %d%n", p2);
        f.format("  (59) Code Table 4.10 = %d%n", statType2);
        f.format("  (62-65) P2 minus P1  = %d%n", p2mp1);
        f.format("                   P1  = %d%n", p2 - p2mp1);
        int[] intv = this.getForecastTimeIntervalOffset(gr);
        if (intv == null) {
            return;
        }
        f.format("ForecastTimeIntervalOffset  = (%d,%d)%n", intv[0], intv[1]);
        f.format("      ForecastTimeInterval  = %s%n", this.getForecastTimeInterval(gr));
    }

    protected void initLocalTable() {
        ClassLoader cl = this.getClass().getClassLoader();
        try (InputStream is = cl.getResourceAsStream(tableName);){
            String line;
            if (is == null) {
                throw new IllegalStateException("Cant find resources/grib2/local/cfsr.txt");
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is, CDM.utf8Charset));
            while ((line = br.readLine()) != null) {
                if (line.length() == 0 || line.startsWith("#")) continue;
                String[] flds = StringUtil2.splitString(line);
                int p1 = Integer.parseInt(flds[0].trim());
                int p2 = Integer.parseInt(flds[1].trim());
                int p3 = Integer.parseInt(flds[2].trim());
                StringBuilder b = new StringBuilder();
                int count = 3;
                while (count < flds.length && !flds[count].equals(".")) {
                    b.append(flds[count++]).append(' ');
                }
                String abbrev = b.toString().trim();
                b.setLength(0);
                ++count;
                while (count < flds.length && !flds[count].equals(".")) {
                    b.append(flds[count++]).append(' ');
                }
                String name = b.toString().trim();
                b.setLength(0);
                ++count;
                while (count < flds.length && !flds[count].equals(".")) {
                    b.append(flds[count++]).append(' ');
                }
                String unit = b.toString().trim();
                Grib2Parameter s2 = new Grib2Parameter(p1, p2, p3, name, unit, abbrev, null);
                this.local.put(CfsrLocalTables.makeParamId(p1, p2, p3), s2);
                if (!debug) continue;
                System.out.printf(" %s%n", s2);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void main(String[] args) {
        CfsrLocalTables t = new CfsrLocalTables(new Grib2Table("DSS", 7, 0, 0, 0, -1, null, Grib2Table.Type.cfsr));
        Formatter f = new Formatter();
        Grib2Parameter.compareTables("DSS-093", "Standard WMO version 8", t.getParameters(), Grib2Customizer.factory(0, 0, 0, 0, 0), f);
        System.out.printf("%s%n", f);
        Formatter f2 = new Formatter();
        Grib2Parameter.compareTables("DSS-093", "NCEP Table", t.getParameters(), Grib2Customizer.factory(7, 0, 0, 0, 0), f2);
        System.out.printf("%s%n", f2);
    }
}

