/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.collection;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.inventory.TimedCollection;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.DsgFeatureCollection;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ft.point.PointCollectionImpl;
import ucar.nc2.ft.point.PointIteratorAbstract;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.collection.CompositeDatasetFactory;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarDateUnit;
import ucar.unidata.geoloc.LatLonRect;

public class CompositeStationCollectionFlattened
extends PointCollectionImpl {
    private static Logger logger = LoggerFactory.getLogger(CompositeStationCollectionFlattened.class);
    private TimedCollection stnCollections;
    private LatLonRect bbSubset;
    private List<String> stationsSubset;
    private CalendarDateRange dateRange;
    private List<VariableSimpleIF> varList;
    private boolean wantStationsubset = false;

    protected CompositeStationCollectionFlattened(String name, CalendarDateUnit timeUnit, String altUnits, List<String> stations, CalendarDateRange dateRange, List<VariableSimpleIF> varList, TimedCollection stnCollections) throws IOException {
        super(name, timeUnit, altUnits);
        this.stationsSubset = stations;
        this.dateRange = dateRange;
        this.varList = varList;
        this.stnCollections = stnCollections;
        this.wantStationsubset = stations != null && stations.size() > 0;
    }

    protected CompositeStationCollectionFlattened(String name, CalendarDateUnit timeUnit, String altUnits, LatLonRect bbSubset, CalendarDateRange dateRange, TimedCollection stnCollections) throws IOException {
        super(name, timeUnit, altUnits);
        this.bbSubset = bbSubset;
        this.dateRange = dateRange;
        this.stnCollections = stnCollections;
    }

    @Override
    public PointFeatureIterator getPointFeatureIterator() throws IOException {
        return new PointIterator();
    }

    private class PointIterator
    extends PointIteratorAbstract {
        private boolean finished = false;
        private Iterator<TimedCollection.Dataset> iter;
        private FeatureDatasetPoint currentDataset;
        private PointFeatureIterator pfIter = null;

        PointIterator() {
            this.iter = CompositeStationCollectionFlattened.this.stnCollections.getDatasets().iterator();
        }

        private PointFeatureIterator getNextIterator() throws IOException {
            PointFeatureCollection pc;
            if (!this.iter.hasNext()) {
                return null;
            }
            TimedCollection.Dataset td = this.iter.next();
            Formatter errlog = new Formatter();
            this.currentDataset = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open(FeatureType.STATION, td.getLocation(), null, errlog);
            if (this.currentDataset == null) {
                logger.error("FeatureDatasetFactoryManager failed to open: " + td.getLocation() + " \nerrlog = " + errlog);
                return this.getNextIterator();
            }
            if (CompositeDatasetFactory.debug) {
                System.out.printf("CompositeStationCollectionFlattened.Iterator open new dataset: %s%n", td.getLocation());
            }
            List<DsgFeatureCollection> fcList = this.currentDataset.getPointFeatureCollectionList();
            StationTimeSeriesFeatureCollection stnCollection = (StationTimeSeriesFeatureCollection)fcList.get(0);
            if (CompositeStationCollectionFlattened.this.wantStationsubset) {
                pc = stnCollection.flatten(CompositeStationCollectionFlattened.this.stationsSubset, CompositeStationCollectionFlattened.this.dateRange, CompositeStationCollectionFlattened.this.varList);
            } else if (CompositeStationCollectionFlattened.this.bbSubset == null) {
                pc = stnCollection.flatten(null, CompositeStationCollectionFlattened.this.dateRange, null);
            } else {
                List<StationFeature> stations = stnCollection.getStationFeatures(CompositeStationCollectionFlattened.this.bbSubset);
                ArrayList<String> names = new ArrayList<String>();
                for (StationFeature s2 : stations) {
                    names.add(s2.getName());
                }
                pc = stnCollection.flatten(names, CompositeStationCollectionFlattened.this.dateRange, null);
            }
            return pc.getPointFeatureIterator();
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.pfIter == null) {
                    this.pfIter = this.getNextIterator();
                    if (this.pfIter == null) {
                        this.close();
                        return false;
                    }
                }
                if (!this.pfIter.hasNext()) {
                    this.pfIter.close();
                    this.currentDataset.close();
                    if (CompositeDatasetFactory.debug) {
                        System.out.printf("CompositeStationCollectionFlattened.Iterator close dataset: %s%n", this.currentDataset.getLocation());
                    }
                    this.pfIter = this.getNextIterator();
                    return this.hasNext();
                }
                return true;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }

        @Override
        public PointFeature next() {
            PointFeature pf = this.pfIter.next();
            this.calcBounds(pf);
            return pf;
        }

        @Override
        public void close() {
            if (this.finished) {
                return;
            }
            if (this.pfIter != null) {
                this.pfIter.close();
            }
            this.finishCalcBounds();
            if (this.currentDataset != null) {
                try {
                    this.currentDataset.close();
                    if (CompositeDatasetFactory.debug) {
                        System.out.printf("CompositeStationCollectionFlattened close dataset: %s%n", this.currentDataset.getLocation());
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.finished = true;
        }
    }
}

