/*
 * Decompiled with CFR 0.152.
 */
package ucar.coord;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateBuilder;
import ucar.coord.CoordinateEns;
import ucar.coord.CoordinateRuntime;
import ucar.coord.CoordinateTime;
import ucar.coord.CoordinateTime2D;
import ucar.coord.CoordinateTime2DUnionizer;
import ucar.coord.CoordinateTimeIntv;
import ucar.coord.CoordinateVert;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.collection.GribCollectionMutable;
import ucar.nc2.grib.collection.PartitionCollectionMutable;
import ucar.nc2.time.CalendarDate;

public class CoordinatePartitionUnionizer {
    private static final boolean debugPartitionErrors = true;
    private final FeatureCollectionConfig.GribIntvFilter intvFilter;
    private final Logger logger;
    private final GribCollectionMutable.VariableIndex vi;
    private final Map<Long, PartitionCollectionMutable.Partition> timeMap;
    List<Coordinate> unionCoords = new ArrayList<Coordinate>();
    CoordinateBuilder runtimeBuilder;
    CoordinateBuilder timeBuilder;
    CoordinateBuilder timeIntvBuilder;
    CoordinateBuilder vertBuilder;
    CoordinateBuilder ensBuilder;
    CoordinateTime2DUnionizer time2DBuilder;
    boolean duplicateRuntimeMessage;

    public CoordinatePartitionUnionizer(GribCollectionMutable.VariableIndex vi, FeatureCollectionConfig.GribIntvFilter intvFilter, Logger logger) {
        this.vi = vi;
        this.intvFilter = intvFilter;
        this.logger = logger;
        this.timeMap = new HashMap<Long, PartitionCollectionMutable.Partition>();
    }

    public void addCoords(List<Coordinate> coords, PartitionCollectionMutable.Partition part) {
        Coordinate runtime = null;
        for (Coordinate coord : coords) {
            switch (coord.getType()) {
                case runtime: {
                    CoordinateRuntime rtime = (CoordinateRuntime)coord;
                    if (this.runtimeBuilder == null) {
                        this.runtimeBuilder = new CoordinateRuntime.Builder2(rtime.getTimeUnits());
                    }
                    this.runtimeBuilder.addAll(coord);
                    runtime = coord;
                    if (this.duplicateRuntimeMessage || part == null) break;
                    this.testDuplicateRuntime(rtime, part);
                    break;
                }
                case time: {
                    CoordinateTime time = (CoordinateTime)coord;
                    if (this.timeBuilder == null) {
                        this.timeBuilder = new CoordinateTime.Builder2(coord.getCode(), time.getTimeUnit(), time.getRefDate());
                    }
                    this.timeBuilder.addAll(coord);
                    break;
                }
                case timeIntv: {
                    CoordinateTimeIntv timeIntv = (CoordinateTimeIntv)coord;
                    if (this.timeIntvBuilder == null) {
                        this.timeIntvBuilder = new CoordinateTimeIntv.Builder2(null, coord.getCode(), timeIntv.getTimeUnit(), timeIntv.getRefDate());
                    }
                    this.timeIntvBuilder.addAll(this.intervalFilter((CoordinateTimeIntv)coord));
                    break;
                }
                case time2D: {
                    CoordinateTime2D time2D = (CoordinateTime2D)coord;
                    if (this.time2DBuilder == null) {
                        this.time2DBuilder = new CoordinateTime2DUnionizer(time2D.isTimeInterval(), time2D.getTimeUnit(), coord.getCode(), false, this.logger);
                    }
                    this.time2DBuilder.addAll(time2D);
                    CoordinateRuntime runtimeFrom2D = time2D.getRuntimeCoordinate();
                    if (runtimeFrom2D.equals(runtime)) break;
                    this.logger.warn("HEY CoordinateUnionizer runtimes not equal");
                    break;
                }
                case ens: {
                    if (this.ensBuilder == null) {
                        this.ensBuilder = new CoordinateEns.Builder2(coord.getCode());
                    }
                    this.ensBuilder.addAll(coord);
                    break;
                }
                case vert: {
                    CoordinateVert vertCoord = (CoordinateVert)coord;
                    if (this.vertBuilder == null) {
                        this.vertBuilder = new CoordinateVert.Builder2(coord.getCode(), vertCoord.getVertUnit());
                    }
                    this.vertBuilder.addAll(coord);
                }
            }
        }
    }

    private void testDuplicateRuntime(CoordinateRuntime runtime, PartitionCollectionMutable.Partition part) {
        PartitionCollectionMutable.Partition shownPrevPart = null;
        for (int idx = 0; idx < runtime.getNCoords(); ++idx) {
            long time = runtime.getRuntime(idx);
            PartitionCollectionMutable.Partition prevPart = this.timeMap.get(time);
            if (prevPart != null && prevPart != part && prevPart != shownPrevPart) {
                this.logger.warn("Variable {} Runtime {} in part {} and partition {}", this.vi.id(), CalendarDate.of(time), prevPart.getName(), part.getName());
                shownPrevPart = prevPart;
                this.duplicateRuntimeMessage = true;
            }
            this.timeMap.put(time, part);
        }
    }

    private List<TimeCoord.Tinv> intervalFilter(CoordinateTimeIntv coord) {
        if (this.intvFilter == null) {
            return coord.getTimeIntervals();
        }
        ArrayList<TimeCoord.Tinv> result = new ArrayList<TimeCoord.Tinv>();
        for (TimeCoord.Tinv tinv : coord.getTimeIntervals()) {
            if (this.intvFilter.filter(this.vi.getVarid(), tinv.getBounds1(), tinv.getBounds2(), Integer.MIN_VALUE)) continue;
            result.add(tinv);
        }
        return result;
    }

    public List<Coordinate> finish() {
        if (this.runtimeBuilder != null) {
            this.unionCoords.add(this.runtimeBuilder.finish());
        } else {
            this.logger.warn("HEY CoordinateUnionizer missing runtime");
        }
        if (this.timeBuilder != null) {
            this.unionCoords.add(this.timeBuilder.finish());
        } else if (this.timeIntvBuilder != null) {
            this.unionCoords.add(this.timeIntvBuilder.finish());
        } else if (this.time2DBuilder != null) {
            this.unionCoords.add(this.time2DBuilder.finish());
        } else {
            this.logger.warn("HEY CoordinateUnionizer missing time");
        }
        if (this.ensBuilder != null) {
            this.unionCoords.add(this.ensBuilder.finish());
        }
        if (this.vertBuilder != null) {
            this.unionCoords.add(this.vertBuilder.finish());
        }
        return this.unionCoords;
    }
}

