/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.Mercator;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MercatorPseudoProvider
extends MapProjection.AbstractProvider {
    private static final long serialVersionUID = 118002069939741891L;
    static final ParameterDescriptorGroup PARAMETERS = MercatorPseudoProvider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.EPSG, "Popular Visualisation Pseudo Mercator"), new NamedIdentifier(Citations.EPSG, "1024"), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(34))}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, LATITUDE_OF_ORIGIN, CENTRAL_MERIDIAN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

    public MercatorPseudoProvider() {
        super(PARAMETERS);
    }

    public Class<CylindricalProjection> getOperationType() {
        return CylindricalProjection.class;
    }

    @Override
    protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
        parameters.parameter("semi_minor").setValue(parameters.parameter("semi_major").getValue());
        return new Spherical(parameters);
    }

    private static final class Spherical
    extends Mercator.Spherical {
        private static final long serialVersionUID = -7583892502939355783L;

        protected Spherical(ParameterValueGroup parameters) throws ParameterNotFoundException {
            super(parameters);
        }

        public ParameterDescriptorGroup getParameterDescriptors() {
            return PARAMETERS;
        }

        protected double getToleranceForAssertions(double longitude, double latitude) {
            double delta = Math.abs(longitude - this.centralMeridian) / 2.0 + Math.abs(latitude - this.latitudeOfOrigin);
            if (delta > 40.0) {
                return 1.0;
            }
            return 0.1;
        }
    }
}

