/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.Set;
import org.geotools.factory.BufferedFactory;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.IdentifiedObjectFinder;
import org.geotools.referencing.factory.ReferencingFactory;
import org.geotools.util.ObjectCache;
import org.geotools.util.ObjectCaches;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.util.InternationalString;

public final class CachedCRSAuthorityDecorator
extends AbstractAuthorityFactory
implements AuthorityFactory,
CRSAuthorityFactory,
BufferedFactory {
    ObjectCache cache;
    private CRSAuthorityFactory crsAuthority;
    private AbstractAuthorityFactory delegate;

    public CachedCRSAuthorityDecorator(CRSAuthorityFactory factory) {
        this(factory, CachedCRSAuthorityDecorator.createCache(GeoTools.getDefaultHints()));
    }

    protected CachedCRSAuthorityDecorator(CRSAuthorityFactory factory, ObjectCache cache) {
        super(((ReferencingFactory)((Object)factory)).getPriority());
        this.cache = cache;
        this.crsAuthority = factory;
        this.delegate = (AbstractAuthorityFactory)((Object)factory);
    }

    protected static ObjectCache createCache(Hints hints) throws FactoryRegistryException {
        return ObjectCaches.create(hints);
    }

    protected String toKey(String code) {
        return ObjectCaches.toKey(this.getAuthority(), code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdentifiedObject createObject(String code) throws FactoryException {
        String key = this.toKey(code);
        IdentifiedObject obj = (IdentifiedObject)this.cache.get(key);
        if (obj == null) {
            try {
                this.cache.writeLock(key);
                obj = (IdentifiedObject)this.cache.peek(key);
                if (obj == null) {
                    obj = this.crsAuthority.createObject(code);
                    this.cache.put(key, obj);
                }
            }
            finally {
                this.cache.writeUnLock(key);
            }
        }
        return obj;
    }

    public Citation getAuthority() {
        return this.crsAuthority.getAuthority();
    }

    public Set getAuthorityCodes(Class type) throws FactoryException {
        return this.crsAuthority.getAuthorityCodes(type);
    }

    public InternationalString getDescriptionText(String code) throws FactoryException {
        return this.crsAuthority.getDescriptionText(code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CompoundCRS createCompoundCRS(String code) throws FactoryException {
        String key = this.toKey(code);
        CompoundCRS crs = (CompoundCRS)this.cache.get(key);
        if (crs == null) {
            try {
                this.cache.writeLock(key);
                crs = (CompoundCRS)this.cache.peek(key);
                if (crs == null) {
                    crs = this.crsAuthority.createCompoundCRS(code);
                    this.cache.put(key, crs);
                }
            }
            finally {
                this.cache.writeUnLock(key);
            }
        }
        return crs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        String key = this.toKey(code);
        CoordinateReferenceSystem crs = (CoordinateReferenceSystem)this.cache.get(key);
        if (crs == null) {
            try {
                this.cache.writeLock(key);
                crs = (CoordinateReferenceSystem)this.cache.peek(key);
                if (crs == null) {
                    crs = this.crsAuthority.createCoordinateReferenceSystem(code);
                    this.cache.put(key, crs);
                }
            }
            finally {
                this.cache.writeUnLock(key);
            }
        }
        return crs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DerivedCRS createDerivedCRS(String code) throws FactoryException {
        String key = this.toKey(code);
        DerivedCRS crs = (DerivedCRS)this.cache.get(key);
        if (crs == null) {
            try {
                this.cache.writeLock(key);
                crs = (DerivedCRS)this.cache.peek(key);
                if (crs == null) {
                    crs = this.crsAuthority.createDerivedCRS(code);
                    this.cache.put(key, crs);
                }
            }
            finally {
                this.cache.writeUnLock(key);
            }
        }
        return crs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EngineeringCRS createEngineeringCRS(String code) throws FactoryException {
        String key = this.toKey(code);
        EngineeringCRS crs = (EngineeringCRS)this.cache.get(key);
        if (crs == null) {
            try {
                this.cache.writeLock(key);
                crs = (EngineeringCRS)this.cache.peek(key);
                if (crs == null) {
                    crs = this.crsAuthority.createEngineeringCRS(code);
                    this.cache.put(key, crs);
                }
            }
            finally {
                this.cache.writeUnLock(key);
            }
        }
        return crs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeocentricCRS createGeocentricCRS(String code) throws FactoryException {
        String key = this.toKey(code);
        GeocentricCRS crs = (GeocentricCRS)this.cache.get(key);
        if (crs == null) {
            try {
                this.cache.writeLock(key);
                crs = (GeocentricCRS)this.cache.peek(key);
                if (crs == null) {
                    crs = this.crsAuthority.createGeocentricCRS(code);
                    this.cache.put(key, crs);
                }
            }
            finally {
                this.cache.writeUnLock(key);
            }
        }
        return crs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeographicCRS createGeographicCRS(String code) throws FactoryException {
        String key = this.toKey(code);
        GeographicCRS crs = (GeographicCRS)this.cache.get(key);
        if (crs == null) {
            try {
                this.cache.writeLock(key);
                crs = (GeographicCRS)this.cache.peek(key);
                if (crs == null) {
                    crs = this.crsAuthority.createGeographicCRS(code);
                    this.cache.put(key, crs);
                }
            }
            finally {
                this.cache.writeUnLock(key);
            }
        }
        return crs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageCRS createImageCRS(String code) throws FactoryException {
        String key = this.toKey(code);
        ImageCRS crs = (ImageCRS)this.cache.get(key);
        if (crs == null) {
            try {
                this.cache.writeLock(key);
                crs = (ImageCRS)this.cache.peek(key);
                if (crs == null) {
                    crs = this.crsAuthority.createImageCRS(code);
                    this.cache.put(key, crs);
                }
            }
            finally {
                this.cache.writeUnLock(key);
            }
        }
        return crs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectedCRS createProjectedCRS(String code) throws FactoryException {
        String key = this.toKey(code);
        ProjectedCRS crs = (ProjectedCRS)this.cache.get(key);
        if (crs == null) {
            try {
                this.cache.writeLock(key);
                crs = (ProjectedCRS)this.cache.peek(key);
                if (crs == null) {
                    crs = this.crsAuthority.createProjectedCRS(code);
                    this.cache.put(key, crs);
                }
            }
            finally {
                this.cache.writeUnLock(key);
            }
        }
        return crs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemporalCRS createTemporalCRS(String code) throws FactoryException {
        String key = this.toKey(code);
        TemporalCRS crs = (TemporalCRS)this.cache.get(key);
        if (crs == null) {
            try {
                this.cache.writeLock(key);
                crs = (TemporalCRS)this.cache.peek(key);
                if (crs == null) {
                    crs = this.crsAuthority.createTemporalCRS(code);
                    this.cache.put(key, crs);
                }
            }
            finally {
                this.cache.writeUnLock(key);
            }
        }
        return crs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VerticalCRS createVerticalCRS(String code) throws FactoryException {
        String key = this.toKey(code);
        VerticalCRS crs = (VerticalCRS)this.cache.get(key);
        if (crs == null) {
            try {
                this.cache.writeLock(key);
                crs = (VerticalCRS)this.cache.peek(key);
                if (crs == null) {
                    crs = this.crsAuthority.createVerticalCRS(code);
                    this.cache.put(key, crs);
                }
            }
            finally {
                this.cache.writeUnLock(key);
            }
        }
        return crs;
    }

    public void dispose() throws FactoryException {
        this.delegate.dispose();
        this.cache.clear();
        this.cache = null;
        this.delegate = null;
    }

    public String getBackingStoreDescription() throws FactoryException {
        return this.delegate.getBackingStoreDescription();
    }

    public synchronized IdentifiedObjectFinder getIdentifiedObjectFinder(Class type) throws FactoryException {
        return new Finder(this.delegate.getIdentifiedObjectFinder(type), ObjectCaches.create("weak", 250));
    }

    private final class Finder
    extends IdentifiedObjectFinder.Adapter {
        private ObjectCache findCache;

        Finder(IdentifiedObjectFinder finder, ObjectCache tempCache) {
            super(finder);
            this.findCache = tempCache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IdentifiedObject find(IdentifiedObject object) throws FactoryException {
            IdentifiedObject found;
            IdentifiedObject candidate = (IdentifiedObject)this.findCache.get(object);
            if (candidate == null && (found = this.finder.find(object)) != null) {
                try {
                    this.findCache.writeLock(object);
                    candidate = (IdentifiedObject)this.findCache.peek(object);
                    if (candidate == null) {
                        this.findCache.put(object, found);
                        IdentifiedObject identifiedObject = found;
                        return identifiedObject;
                    }
                }
                finally {
                    this.findCache.writeLock(object);
                }
            }
            return candidate;
        }

        public String findIdentifier(IdentifiedObject object) throws FactoryException {
            IdentifiedObject candidate = (IdentifiedObject)this.findCache.get(object);
            if (candidate != null) {
                return this.getIdentifier(candidate);
            }
            return this.finder.findIdentifier(object);
        }
    }
}

