/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.AbstractFilterImpl;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.NullFilter;
import org.opengis.filter.FilterVisitor;

public class NullFilterImpl
extends AbstractFilterImpl
implements NullFilter {
    private org.opengis.filter.expression.Expression nullCheck = null;

    protected NullFilterImpl() {
        super(CommonFactoryFinder.getFilterFactory(null));
        this.filterType = (short)21;
    }

    public final void nullCheckValue(Expression nullCheck) throws IllegalFilterException {
        this.setExpression(nullCheck);
    }

    public final Expression getNullCheckValue() {
        return (Expression)this.getExpression();
    }

    public org.opengis.filter.expression.Expression getExpression() {
        return this.nullCheck;
    }

    public void setExpression(org.opengis.filter.expression.Expression nullCheck) {
        if (!(nullCheck instanceof AttributeExpression)) {
            throw new IllegalFilterException("Attempted to add non-attribute expression to a null filter.");
        }
        this.nullCheck = nullCheck;
    }

    public boolean evaluate(Object feature) {
        if (this.nullCheck == null) {
            return false;
        }
        return this.nullCheck.evaluate(feature) == null;
    }

    public String toString() {
        return "[ " + this.nullCheck.toString() + " is null ]";
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            NullFilterImpl nullFilter = (NullFilterImpl)obj;
            return nullFilter.getFilterType() == this.filterType && nullFilter.getNullCheckValue().equals(this.nullCheck);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.nullCheck == null ? 0 : this.nullCheck.hashCode());
        return result;
    }

    public Object accept(FilterVisitor visitor, Object extraData) {
        return visitor.visit(this, extraData);
    }
}

