/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage;

import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.measure.unit.Unit;
import javax.media.jai.JAI;
import org.geotools.coverage.Category;
import org.geotools.coverage.CategoryList;
import org.geotools.coverage.SampleTranscoder;
import org.geotools.coverage.TypeMap;
import org.geotools.referencing.operation.transform.LinearTransform1D;
import org.geotools.resources.ClassChanger;
import org.geotools.resources.Classes;
import org.geotools.resources.XArray;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.resources.image.ColorUtilities;
import org.geotools.util.NumberRange;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.Utilities;
import org.opengis.coverage.ColorInterpretation;
import org.opengis.coverage.PaletteInterpretation;
import org.opengis.coverage.SampleDimension;
import org.opengis.coverage.SampleDimensionType;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridSampleDimension
implements SampleDimension,
Serializable {
    private static final long serialVersionUID = 6026936545776852758L;
    private GridSampleDimension inverse;
    final CategoryList categories;
    private final boolean isGeophysics;
    private final boolean hasQualitative;
    private final boolean hasQuantitative;
    private final MathTransform1D sampleToGeophysics;
    private final InternationalString description;

    public GridSampleDimension(CharSequence description) {
        this(description, (CategoryList)null);
    }

    public GridSampleDimension(CharSequence description, CharSequence[] categoriesNames) {
        this(description, GridSampleDimension.list(categoriesNames));
    }

    private static CategoryList list(CharSequence[] names) {
        int length = names.length;
        Color[] colors = new Color[length];
        double scale = 255.0 / (double)length;
        for (int i = 0; i < length; ++i) {
            int r = (int)Math.round(scale * (double)i);
            colors[i] = new Color(r, r, r);
        }
        return GridSampleDimension.list(names, colors);
    }

    public GridSampleDimension(CharSequence description, CharSequence[] names, Color[] colors) {
        this(description, GridSampleDimension.list(names, colors));
    }

    private static CategoryList list(CharSequence[] names, Color[] colors) {
        if (names.length != colors.length) {
            throw new IllegalArgumentException(Errors.format(91));
        }
        int length = names.length;
        Category[] categories = new Category[length];
        for (int i = 0; i < length; ++i) {
            categories[i] = new Category(names[i], colors[i], i);
        }
        return GridSampleDimension.list(categories, null);
    }

    public GridSampleDimension(CharSequence description, SampleDimensionType type, ColorInterpretation color, Color[] palette, CharSequence[] categories, double[] nodata, double minimum, double maximum, double scale, double offset, Unit<?> unit) {
        this(description, GridSampleDimension.list(description, type, color, palette, categories, nodata, minimum, maximum, scale, offset, unit));
    }

    private static CategoryList list(CharSequence description, SampleDimensionType type, ColorInterpretation color, Color[] palette, CharSequence[] categories, double[] nodata, double minimum, double maximum, double scale, double offset, Unit<?> unit) {
        Number max;
        if (description == null) {
            description = Vocabulary.formatInternational(232);
        }
        if (Double.isInfinite(minimum) || Double.isInfinite(maximum) || !(minimum < maximum)) {
            throw new IllegalArgumentException(Errors.format(14, minimum, maximum));
        }
        if (Double.isNaN(scale) || Double.isInfinite(scale) || scale == 0.0) {
            throw new IllegalArgumentException(Errors.format(12, "scale", scale));
        }
        if (Double.isNaN(offset) || Double.isInfinite(offset)) {
            throw new IllegalArgumentException(Errors.format(12, "offset", offset));
        }
        if (type == null) {
            type = TypeMap.getSampleDimensionType(minimum, maximum);
        }
        if (color == null) {
            color = ColorInterpretation.PALETTE_INDEX;
        }
        int nameCount = categories != null ? categories.length : 0;
        int nodataCount = nodata != null ? nodata.length : 0;
        ArrayList<Category> categoryList = new ArrayList<Category>(nameCount + nodataCount + 2);
        for (int i = 0; i < nodataCount; ++i) {
            CharSequence name = null;
            double padValue = nodata[i];
            int intValue = (int)Math.floor(padValue);
            if (intValue >= 0 && intValue < nameCount) {
                if ((double)intValue == padValue) continue;
                name = categories[intValue];
            }
            Number value = TypeMap.wrapSample(padValue, type, false);
            if (name == null) {
                name = value.toString();
            }
            NumberRange<Number> range = new NumberRange<Number>(value.getClass(), value, value);
            Color[] colors = ColorUtilities.subarray(palette, intValue, intValue + 1);
            categoryList.add(new Category(name, colors, range, (MathTransform1D)null));
        }
        if (nameCount != 0) {
            int lower = 0;
            int length = categories.length;
            for (int upper = 1; upper <= length; ++upper) {
                Class<Number> classe;
                String nameUpper;
                String nameLower;
                if (upper != length && (nameLower = ((Object)categories[lower]).toString().trim()).equalsIgnoreCase(nameUpper = ((Object)categories[upper]).toString().trim())) continue;
                CharSequence name = categories[lower];
                Number min = TypeMap.wrapSample(lower, type, false);
                if (min.equals(max = TypeMap.wrapSample(upper - 1, type, false))) {
                    min = max;
                    classe = max.getClass();
                } else {
                    classe = ClassChanger.getWidestClass(min, max);
                    min = ClassChanger.cast(min, classe);
                    max = ClassChanger.cast(max, classe);
                }
                NumberRange<Number> range = new NumberRange<Number>(classe, min, max);
                Color[] colors = ColorUtilities.subarray(palette, lower, upper);
                categoryList.add(new Category(name, colors, range, (MathTransform1D)null));
                lower = upper;
            }
        }
        boolean needQuantitative = false;
        if (scale != 1.0 || offset != 0.0 || nodataCount != 0 || categoryList.size() <= 1) {
            needQuantitative = true;
            int i = categoryList.size();
            while (--i >= 0) {
                double xmax;
                double xmin;
                NumberRange<? extends Number> range;
                Number min;
                int c;
                Category category = (Category)categoryList.get(i);
                if (category.isQuantitative() || (c = (min = (range = category.getRange()).getMinValue()).compareTo((Number)(max = range.getMaxValue()))) == 0 || GridSampleDimension.rangeContains(xmin = ((Number)min).doubleValue(), xmax = max.doubleValue(), nodata)) continue;
                InternationalString name = category.getName();
                Color[] colors = category.getColors();
                category = new Category(name, colors, range, scale, offset);
                categoryList.set(i, category);
                needQuantitative = false;
            }
        }
        if (needQuantitative) {
            boolean minIncluded = true;
            boolean maxIncluded = true;
            int i = categoryList.size();
            while (--i >= 0) {
                NumberRange<? extends Number> range = ((Category)categoryList.get(i)).getRange();
                double min = range.getMinimum();
                double max2 = range.getMaximum();
                if (max2 - minimum < maximum - min) {
                    if (!(max2 >= minimum)) continue;
                    minimum = max2;
                    minIncluded = !range.isMaxIncluded();
                    continue;
                }
                if (!(min <= maximum)) continue;
                maximum = min;
                maxIncluded = !range.isMinIncluded();
            }
            boolean bl = !minIncluded || !maxIncluded;
            if (maximum - minimum > (double)bl) {
                Number min = TypeMap.wrapSample(minimum, type, false);
                Number max3 = TypeMap.wrapSample(maximum, type, false);
                Class<Number> classe = ClassChanger.getWidestClass(min, max3);
                min = ClassChanger.cast(min, classe);
                max3 = ClassChanger.cast(max3, classe);
                NumberRange<Number> range = new NumberRange<Number>(classe, min, minIncluded, max3, maxIncluded);
                Color[] colors = ColorUtilities.subarray(palette, (int)Math.ceil(minimum), (int)Math.floor(maximum));
                categoryList.add(new Category(description, colors, range, scale, offset));
                needQuantitative = false;
            }
        }
        Category[] cl = categoryList.toArray(new Category[categoryList.size()]);
        if (ColorInterpretation.PALETTE_INDEX.equals(color) || ColorInterpretation.GRAY_INDEX.equals(color)) {
            return GridSampleDimension.list(cl, unit);
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public GridSampleDimension(CharSequence description, Category[] categories, Unit<?> units) throws IllegalArgumentException {
        this(description, GridSampleDimension.list(categories, units));
    }

    private static CategoryList list(Category[] categories, Unit<?> units) {
        if (categories == null || categories.length == 0) {
            return null;
        }
        CategoryList list = new CategoryList(categories, units);
        if (CategoryList.isGeophysics(categories, false)) {
            return list;
        }
        if (CategoryList.isGeophysics(categories, true)) {
            return list.inverse;
        }
        throw new IllegalArgumentException(Errors.format(102));
    }

    private GridSampleDimension(CharSequence description, CategoryList list) {
        this.description = description != null ? SimpleInternationalString.wrap(description) : (list != null ? list.getName() : Vocabulary.formatInternational(232));
        MathTransform1D main = null;
        boolean isMainValid = true;
        boolean qualitative = false;
        if (list != null) {
            int i = list.size();
            while (--i >= 0) {
                MathTransform1D candidate = list.get(i).getSampleToGeophysics();
                if (candidate == null) {
                    qualitative = true;
                    continue;
                }
                if (main != null) {
                    isMainValid &= main.equals(candidate);
                }
                main = candidate;
            }
            this.isGeophysics = list.isGeophysics(true);
        } else {
            this.isGeophysics = false;
        }
        this.categories = list;
        this.hasQualitative = qualitative;
        this.hasQuantitative = main != null;
        this.sampleToGeophysics = isMainValid ? main : null;
    }

    protected GridSampleDimension(GridSampleDimension other) {
        if (other != null) {
            this.inverse = other.inverse;
            this.categories = other.categories;
            this.isGeophysics = other.isGeophysics;
            this.hasQualitative = other.hasQualitative;
            this.hasQuantitative = other.hasQuantitative;
            this.sampleToGeophysics = other.sampleToGeophysics;
            this.description = other.description;
        } else {
            this.categories = null;
            this.isGeophysics = false;
            this.hasQualitative = false;
            this.hasQuantitative = false;
            this.sampleToGeophysics = null;
            this.description = Vocabulary.formatInternational(232);
        }
    }

    public static GridSampleDimension wrap(SampleDimension sd) {
        Color[] colors;
        if (sd instanceof GridSampleDimension) {
            return (GridSampleDimension)sd;
        }
        int[][] palette = sd.getPalette();
        if (palette != null) {
            int length = palette.length;
            colors = new Color[length];
            for (int i = 0; i < length; ++i) {
                int[] color = palette[i];
                colors[i] = new Color(color[0], color[1], color[2]);
            }
        } else {
            colors = null;
        }
        return new GridSampleDimension(sd.getDescription(), sd.getSampleDimensionType(), sd.getColorInterpretation(), colors, sd.getCategoryNames(), sd.getNoDataValues(), sd.getMinimumValue(), sd.getMaximumValue(), sd.getScale(), sd.getOffset(), sd.getUnits());
    }

    @Override
    public SampleDimensionType getSampleDimensionType() {
        NumberRange<? extends Number> range = this.getRange();
        if (range == null) {
            return SampleDimensionType.REAL_32BITS;
        }
        return TypeMap.getSampleDimensionType(range);
    }

    @Override
    public InternationalString getDescription() {
        return this.description;
    }

    @Override
    public InternationalString[] getCategoryNames() throws IllegalStateException {
        if (this.categories == null) {
            return null;
        }
        if (this.categories.isEmpty()) {
            return new InternationalString[0];
        }
        Object[] names = null;
        int i = this.categories.size();
        while (--i >= 0) {
            Category category = this.categories.get(i);
            int lower = (int)category.minimum;
            int upper = (int)category.maximum;
            if ((double)lower != category.minimum || lower < 0 || (double)upper != category.maximum || upper < 0) {
                throw new IllegalStateException(Errors.format(111));
            }
            if (names == null) {
                names = new InternationalString[upper + 1];
            }
            Arrays.fill(names, lower, upper + 1, category.getName());
        }
        return names;
    }

    public List<Category> getCategories() {
        if (this.categories == null) {
            return Collections.emptyList();
        }
        return this.categories;
    }

    public Category getCategory(double sample) {
        return this.categories != null ? this.categories.getCategory(sample) : null;
    }

    public Category getBackground() {
        return this.categories != null ? this.categories.nodata : Category.NODATA;
    }

    @Override
    public double[] getNoDataValues() throws IllegalStateException {
        if (!this.hasQuantitative) {
            return null;
        }
        int count = 0;
        double[] padValues = null;
        int size = this.categories.size();
        for (int i = 0; i < size; ++i) {
            Category category = this.categories.get(i);
            if (category.isQuantitative()) continue;
            double min = category.minimum;
            double max = category.maximum;
            if (Double.isNaN(min) && Double.isNaN(max)) continue;
            if (padValues == null) {
                padValues = new double[size - i];
            }
            if (count >= padValues.length) {
                padValues = XArray.resize(padValues, count * 2);
            }
            padValues[count++] = min;
            if (max == min) continue;
            int lower = (int)min;
            int upper = (int)max;
            if ((double)lower != min || (double)upper != max || !Classes.isInteger(category.getRange().getElementClass())) {
                throw new IllegalStateException(Errors.format(111));
            }
            int requiredLength = count + (upper - lower);
            if (requiredLength > padValues.length) {
                padValues = XArray.resize(padValues, requiredLength * 2);
            }
            while (++lower <= upper) {
                padValues[count++] = lower;
            }
        }
        if (padValues != null) {
            padValues = XArray.resize(padValues, count);
        }
        return padValues;
    }

    @Override
    public double getMinimumValue() {
        double value;
        if (this.categories != null && !this.categories.isEmpty() && !Double.isNaN(value = this.categories.get((int)0).minimum)) {
            return value;
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getMaximumValue() {
        if (this.categories != null) {
            int i = this.categories.size();
            while (--i >= 0) {
                double value = this.categories.get((int)i).maximum;
                if (Double.isNaN(value)) continue;
                return value;
            }
        }
        return Double.POSITIVE_INFINITY;
    }

    public NumberRange<? extends Number> getRange() {
        return this.categories != null ? this.categories.getRange() : null;
    }

    private static boolean rangeContains(double lower, double upper, double[] values) {
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                double v = values[i];
                if (!(v >= lower) || !(v < upper)) continue;
                return true;
            }
        }
        return false;
    }

    public String getLabel(double value, Locale locale) {
        if (this.categories != null) {
            if (this.isGeophysics) {
                return this.categories.format(value, locale);
            }
            try {
                return this.categories.inverse.format(this.categories.transform(value), locale);
            }
            catch (TransformException exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Unit<?> getUnits() {
        return this.categories != null ? this.categories.geophysics(true).getUnits() : null;
    }

    @Override
    public double getOffset() throws IllegalStateException {
        return this.getCoefficient(0);
    }

    @Override
    public double getScale() {
        return this.getCoefficient(1);
    }

    private double getCoefficient(int order) throws IllegalStateException {
        if (!this.hasQuantitative) {
            return order;
        }
        TransformException cause = null;
        if (this.sampleToGeophysics != null) {
            try {
                double value;
                switch (order) {
                    case 0: {
                        value = this.sampleToGeophysics.transform(0.0);
                        break;
                    }
                    case 1: {
                        value = this.sampleToGeophysics.derivative(Double.NaN);
                        break;
                    }
                    default: {
                        throw new AssertionError(order);
                    }
                }
                if (!Double.isNaN(value)) {
                    return value;
                }
            }
            catch (TransformException exception) {
                cause = exception;
            }
        }
        throw new IllegalStateException(Errors.format(112), cause);
    }

    @Override
    public MathTransform1D getSampleToGeophysics() {
        if (this.isGeophysics) {
            return LinearTransform1D.IDENTITY;
        }
        if (!this.hasQualitative && this.sampleToGeophysics != null) {
            return this.sampleToGeophysics;
        }
        return this.categories;
    }

    public GridSampleDimension geophysics(boolean geo) {
        if (geo == this.isGeophysics) {
            return this;
        }
        if (this.inverse == null) {
            if (this.categories != null) {
                this.inverse = new GridSampleDimension((CharSequence)this.description, this.categories.inverse);
                this.inverse.inverse = this;
            } else {
                this.inverse = this;
            }
        }
        return this.inverse;
    }

    @Override
    public int[][] getPalette() {
        ColorModel color = this.getColorModel();
        if (color instanceof IndexColorModel) {
            IndexColorModel cm = (IndexColorModel)color;
            int[][] colors = new int[cm.getMapSize()][];
            for (int i = 0; i < colors.length; ++i) {
                colors[i] = new int[]{cm.getRed(i), cm.getGreen(i), cm.getBlue(i)};
            }
            return colors;
        }
        return null;
    }

    @Override
    public PaletteInterpretation getPaletteInterpretation() {
        return PaletteInterpretation.RGB;
    }

    @Override
    public ColorInterpretation getColorInterpretation() {
        boolean band = false;
        boolean numBands = true;
        return TypeMap.getColorInterpretation(this.getColorModel(0, 1), 0);
    }

    public ColorModel getColorModel() {
        boolean band = false;
        boolean numBands = true;
        return this.getColorModel(0, 1);
    }

    public ColorModel getColorModel(int visibleBand, int numBands) {
        if (this.categories != null) {
            if (this.isGeophysics && this.hasQualitative) {
                return this.categories.getColorModel(visibleBand, numBands, 4);
            }
            return this.categories.getColorModel(visibleBand, numBands);
        }
        return null;
    }

    public ColorModel getColorModel(int visibleBand, int numBands, int type) {
        if (this.categories != null) {
            return this.categories.getColorModel(visibleBand, numBands, type);
        }
        return null;
    }

    public GridSampleDimension rescale(double scale, double offset) {
        MathTransform1D sampleToGeophysics = Category.createLinearTransform(scale, offset);
        Category[] categories = (Category[])this.getCategories().toArray();
        boolean changed = false;
        for (int i = 0; i < categories.length; ++i) {
            Category category = categories[i];
            if (category.isQuantitative()) {
                category = category.rescale(sampleToGeophysics);
            }
            if (categories[i].equals(category = category.geophysics(this.isGeophysics))) continue;
            categories[i] = category;
            changed = true;
        }
        return changed ? new GridSampleDimension((CharSequence)this.description, categories, this.getUnits()) : this;
    }

    public int hashCode() {
        return this.categories != null ? this.categories.hashCode() : 920215318;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof GridSampleDimension) {
            GridSampleDimension that = (GridSampleDimension)object;
            return Utilities.equals(this.categories, that.categories);
        }
        return false;
    }

    public String toString() {
        if (this.categories != null) {
            return this.categories.toString(this, this.description);
        }
        return Classes.getShortClassName(this) + "[\"" + this.description + "\"]";
    }

    static {
        SampleTranscoder.register(JAI.getDefaultInstance());
    }
}

