/*
 * Decompiled with CFR 0.152.
 */
package org.eumetsat.beam.dataio.metop;

import java.io.File;
import java.io.IOException;
import javax.imageio.stream.FileImageInputStream;
import org.esa.beam.dataio.avhrr.AvhrrConstants;
import org.esa.beam.dataio.avhrr.AvhrrReader;
import org.esa.beam.dataio.avhrr.BandReader;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.FlagCoding;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.TiePointGeoCoding;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.dataop.maptransf.Datum;
import org.eumetsat.beam.dataio.metop.MetopFile;
import org.eumetsat.beam.dataio.metop.MetopReaderPlugIn;

public class MetopReader
extends AvhrrReader
implements AvhrrConstants {
    boolean doNotCrop = ProductIO.getDoNotCrop();
    float tpOffsetX;

    public MetopReader(ProductReaderPlugIn metopReaderPlugIn) {
        super(metopReaderPlugIn);
    }

    @Override
    protected Product readProductNodesImpl() throws IOException {
        File dataFile = MetopReaderPlugIn.getInputFile(this.getInput());
        try {
            FileImageInputStream imageInputStream = new FileImageInputStream(dataFile);
            this.avhrrFile = new MetopFile(imageInputStream, this.doNotCrop);
            this.avhrrFile.readHeader();
            this.createProduct();
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                this.close();
            }
            catch (IOException iOException) {}
            throw e;
        }
        this.product.setFileLocation(dataFile);
        return this.product;
    }

    @Override
    protected void addTiePointGrids() throws IOException {
        int i;
        MetopFile metopFile = (MetopFile)this.avhrrFile;
        int tiePointSampleRate = metopFile.getNavSampleRate();
        int tiePointGridHeight = (int)Math.ceil((double)metopFile.getProductHeight() / (double)tiePointSampleRate);
        int tiePointGridWidth = metopFile.getNumNavPoints();
        String[] tiePointNames = this.avhrrFile.getTiePointNames();
        float[][] tiePointData = this.avhrrFile.getTiePointData();
        int numGrids = tiePointNames.length;
        TiePointGrid[] grid = new TiePointGrid[numGrids];
        int numTrimX = this.product.getMetadataRoot().getElement("READER_INFO").getAttribute("TRIM_LEFT").getData().getElemInt();
        if (this.doNotCrop) {
            this.tpOffsetX = 0.5f + (float)numTrimX - (float)tiePointSampleRate;
            i = 0;
            while (i < numGrids) {
                tiePointData[i] = this.expandTiePoints(tiePointData[i], tiePointGridWidth, tiePointGridHeight);
                ++i;
            }
            tiePointGridWidth += 2;
            ++tiePointGridHeight;
        } else {
            this.tpOffsetX = 0.5f;
        }
        i = 0;
        while (i < grid.length) {
            grid[i] = this.createTiePointGrid(tiePointNames[i], tiePointGridWidth, tiePointGridHeight, this.tpOffsetX, 0.5f, tiePointSampleRate, tiePointSampleRate, tiePointData[i]);
            grid[i].setUnit("deg");
            this.product.addTiePointGrid(grid[i]);
            ++i;
        }
        this.addDeltaAzimuth(tiePointGridWidth, tiePointGridHeight, tiePointSampleRate);
        TiePointGeoCoding geoCoding = new TiePointGeoCoding(grid[numGrids - 2], grid[numGrids - 1], Datum.WGS_72);
        this.product.setGeoCoding(geoCoding);
    }

    private float[] expandTiePoints(float[] data, int tiePointGridWidth, int tiePointGridHeight) {
        int newWidth = tiePointGridWidth + 2;
        int newHeight = tiePointGridHeight + 1;
        float[] newData = new float[newWidth * newHeight];
        int y = 0;
        while (y < tiePointGridHeight) {
            float[] line = new float[newWidth];
            int x = 0;
            while (x < tiePointGridWidth) {
                line[x + 1] = data[y * tiePointGridWidth + x];
                ++x;
            }
            this.interpolate(line, 2);
            x = 0;
            while (x < newWidth) {
                newData[y * newWidth + x] = line[x];
                ++x;
            }
            ++y;
        }
        int x = 0;
        while (x < newWidth) {
            float[] column = new float[newHeight];
            int y2 = 0;
            while (y2 < newHeight) {
                column[y2] = newData[y2 * newWidth + x];
                ++y2;
            }
            this.interpolate(column, 1);
            newData[(newHeight - 1) * newWidth + x] = column[newHeight - 1];
            ++x;
        }
        return newData;
    }

    private void interpolate(float[] numbers, int sides) {
        float step;
        if (sides == 2) {
            step = numbers[2] - numbers[1];
            numbers[0] = numbers[1] - step;
        }
        step = numbers[numbers.length - 2] - numbers[numbers.length - 3];
        numbers[numbers.length - 1] = numbers[numbers.length - 2] + step;
    }

    @Override
    protected void addCloudBand() {
        if (this.avhrrFile.hasCloudBand()) {
            BandReader cloudReader = this.avhrrFile.createCloudBandReader();
            Band cloudBand = new Band(cloudReader.getBandName(), cloudReader.getDataType(), this.avhrrFile.getProductWidth(), this.avhrrFile.getProductHeight());
            FlagCoding fc = new FlagCoding(cloudReader.getBandName());
            fc.setDescription("Flag coding for CLOUD_INFORMATION");
            this.addFlagAndBitmaskDef(fc, "uniformity_test2", "Uniformity test (0='test failed' or 'clear'; 1='cloudy')", 15);
            this.addFlagAndBitmaskDef(fc, "uniformity_test1", "Uniformity test (0 ='test failed' or 'cloudy', 1='clear')", 14);
            this.addFlagAndBitmaskDef(fc, "t3_t5_test2", "T3-T5 test (0='test failed' or 'clear'; 1='cloudy')", 13);
            this.addFlagAndBitmaskDef(fc, "t3_t5_test1", "T3-T5 test (0 ='test failed' or 'cloudy', 1='clear')", 12);
            this.addFlagAndBitmaskDef(fc, "t4_t3_test2", "T4-T3 test (0='test failed' or 'clear'; 1='cloudy')", 11);
            this.addFlagAndBitmaskDef(fc, "t4_t3_test1", "T4-T3 test (0 ='test failed' or 'cloudy', 1='clear')", 10);
            this.addFlagAndBitmaskDef(fc, "t4_t5_test2", "T4-T5 test (0='test failed' or 'clear'; 1='cloudy')", 9);
            this.addFlagAndBitmaskDef(fc, "t4_t5_test1", "T4-T5 test (0 ='test failed' or 'cloudy', 1='clear')", 8);
            this.addFlagAndBitmaskDef(fc, "albedo_test2", "Albedo test (0='test failed' or 'clear'; 1='cloudy' or 'snow/ice covered')", 7);
            this.addFlagAndBitmaskDef(fc, "albedo_test1", "Albedo test (0 ='test failed' or 'cloudy', 1='clear' or 'snow/ice covered')", 6);
            this.addFlagAndBitmaskDef(fc, "t4_test2", "T4 test (0='test failed' or 'clear'; 1='cloudy' or 'snow/ice covered')", 5);
            this.addFlagAndBitmaskDef(fc, "t4_test1", "T4 test (0 ='test failed' or 'cloudy', 1='clear' or 'snow/ice covered')", 4);
            cloudBand.setSampleCoding(fc);
            this.product.getFlagCodingGroup().add(fc);
            this.product.addBand(cloudBand);
            this.bandReaders.put(cloudBand, cloudReader);
        }
    }

    private void addDeltaAzimuth(int tiePointGridWidth, int tiePointGridHeight, int tiePointSampleRate) {
        float[] sunAzimuthTiePointData = this.product.getTiePointGrid("sun_azimuth").getTiePoints();
        float[] viewAzimuthTiePointData = this.product.getTiePointGrid("view_azimuth").getTiePoints();
        int numTiePoints = viewAzimuthTiePointData.length;
        float[] deltaAzimuthData = new float[numTiePoints];
        int i = 0;
        while (i < numTiePoints) {
            deltaAzimuthData[i] = (float)MetopReader.computeAda(viewAzimuthTiePointData[i], sunAzimuthTiePointData[i]);
            ++i;
        }
        TiePointGrid grid = this.createTiePointGrid("delta_azimuth", tiePointGridWidth, tiePointGridHeight, this.tpOffsetX, 0.5f, tiePointSampleRate, tiePointSampleRate, deltaAzimuthData);
        grid.setUnit("deg");
        this.product.addTiePointGrid(grid);
    }

    private static double computeAda(double vaa, double saa) {
        double ada = saa - vaa;
        if (ada <= -180.0) {
            ada += 360.0;
        } else if (ada > 180.0) {
            ada -= 360.0;
        }
        return ada;
    }

    public static boolean canOpenFile(File file) {
        try {
            return MetopFile.canOpenFile(file);
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

