/*
 * Decompiled with CFR 0.152.
 */
package org.eumetsat.beam.dataio.metop;

import com.bc.ceres.core.ProgressMonitor;
import java.io.IOException;
import java.text.MessageFormat;
import javax.imageio.stream.ImageInputStream;
import org.esa.beam.dataio.avhrr.AvhrrFile;
import org.esa.beam.dataio.avhrr.BandReader;
import org.esa.beam.framework.datamodel.ProductData;
import org.eumetsat.beam.dataio.metop.MetopFile;

class CloudBandReader
implements BandReader {
    protected MetopFile metopFile;
    protected final ImageInputStream inputStream;

    public CloudBandReader(MetopFile metopFile, ImageInputStream inputStream) {
        this.metopFile = metopFile;
        this.inputStream = inputStream;
    }

    @Override
    public String getBandDescription() {
        return "CLAVR-x cloud mask";
    }

    @Override
    public String getBandName() {
        return "cloud_flags";
    }

    @Override
    public String getBandUnit() {
        return null;
    }

    @Override
    public int getDataType() {
        return 21;
    }

    @Override
    public double getScalingFactor() {
        return 1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readBandRasterData(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        AvhrrFile.RawCoordinates rawCoord = this.metopFile.getRawCoordinates(sourceOffsetX, sourceOffsetY, sourceWidth, sourceHeight);
        short[] targetData = (short[])destBuffer.getElems();
        pm.beginTask(MessageFormat.format("Reading AVHRR band ''{0}''...", this.getBandName()), rawCoord.maxY - rawCoord.minY);
        int targetIdx = rawCoord.targetStart;
        int sourceY = rawCoord.minY;
        while (sourceY <= rawCoord.maxY) {
            if (pm.isCanceled()) break;
            int dataOffset = this.getDataOffset(sourceOffsetX, sourceY);
            ImageInputStream imageInputStream = this.inputStream;
            synchronized (imageInputStream) {
                this.inputStream.seek(dataOffset);
                this.inputStream.readFully(targetData, targetIdx, sourceWidth);
            }
            targetIdx += sourceWidth;
            pm.worked(1);
            sourceY += sourceStepY;
        }
        pm.done();
    }

    protected int getDataOffset(int sourceOffsetX, int sourceY) {
        return this.metopFile.getScanLineOffset(sourceY) + 22472 + (this.metopFile.getNumTrimX() + sourceOffsetX) * 2;
    }
}

