/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util.jai;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import org.esa.beam.util.Debug;
import org.esa.beam.util.ImageUtils;
import org.esa.beam.util.jai.JAIUtils;

public class JAIDebug
extends Debug {
    public static final int F_ATTRIBUTES = 1;
    public static final int F_TILEINFO = 2;
    public static final int F_STATISTICS = 4;
    public static final int F_PROPERTIES = 8;
    public static final int F_ALL = 15;
    private static final int INDENT_INCR = 4;
    private static int _defaultTraceMask = 0;
    private static StringBuffer _stringBuffer = new StringBuffer();

    public static void setDefaultTraceMask(int traceMask) {
        _defaultTraceMask = traceMask;
    }

    public static int getDefaultTraceMask() {
        return _defaultTraceMask;
    }

    private static StringBuffer getStringBuffer() {
        _stringBuffer.ensureCapacity(1024);
        return _stringBuffer;
    }

    public static void trace(RenderedImage im) {
        if (JAIDebug.isEnabled() && im != null) {
            JAIDebug.trace("RenderedImage", im);
        }
    }

    public static void trace(String label, RenderedImage im) {
        if (JAIDebug.isEnabled() && im != null) {
            JAIDebug.trace(label, im, _defaultTraceMask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void trace(String label, RenderedImage im, int traceMask) {
        if (JAIDebug.isEnabled() && im != null) {
            StringBuffer sb;
            StringBuffer stringBuffer = sb = JAIDebug.getStringBuffer();
            synchronized (stringBuffer) {
                sb.setLength(0);
                JAIDebug.traceObj(label, im, traceMask, sb, 0);
                JAIDebug.trace(sb.toString());
            }
        }
    }

    private static void traceObj(String label, RenderedImage im, int traceMask, StringBuffer sb, int indent) {
        if (!JAIDebug.isEnabled()) {
            return;
        }
        if (im != null) {
            int i;
            JAIDebug.traceObjStart(label, im, sb, indent);
            indent += 4;
            if (JAIDebug.isFlagSet(traceMask, 1)) {
                JAIDebug.traceField("minX", im.getMinX(), sb, indent);
                JAIDebug.traceField("minY", im.getMinY(), sb, indent);
                JAIDebug.traceField("width", im.getWidth(), sb, indent);
                JAIDebug.traceField("height", im.getHeight(), sb, indent);
                if (JAIDebug.isFlagSet(traceMask, 2)) {
                    JAIDebug.traceField("minTileX", im.getMinTileX(), sb, indent);
                    JAIDebug.traceField("minTileY", im.getMinTileY(), sb, indent);
                    JAIDebug.traceField("tileWidth", im.getTileWidth(), sb, indent);
                    JAIDebug.traceField("tileHeight", im.getTileHeight(), sb, indent);
                    JAIDebug.traceField("tileGridXOffset", im.getTileGridXOffset(), sb, indent);
                    JAIDebug.traceField("tileGridYOffset", im.getTileGridYOffset(), sb, indent);
                    JAIDebug.traceField("numXTiles", im.getNumXTiles(), sb, indent);
                    JAIDebug.traceField("numYTiles", im.getNumYTiles(), sb, indent);
                }
            }
            if (JAIDebug.isFlagSet(traceMask, 4)) {
                double[][] extrema = JAIUtils.getExtrema(im);
                if (extrema != null) {
                    JAIDebug.appendLineStart(sb, indent);
                    sb.append("extrema = { ");
                    i = 0;
                    while (i < extrema[0].length) {
                        if (i > 0) {
                            sb.append(", ");
                        }
                        sb.append("{ ");
                        sb.append(extrema[0][i]);
                        sb.append(", ");
                        sb.append(extrema[1][i]);
                        sb.append(" }");
                        ++i;
                    }
                    sb.append(" }");
                    JAIDebug.appendLineEnd(sb);
                } else {
                    JAIDebug.traceField("extrema", null, sb, indent);
                }
            }
            if (JAIDebug.isFlagSet(traceMask, 8)) {
                String[] propertyNames = im.getPropertyNames();
                if (propertyNames != null) {
                    JAIDebug.appendLineStart(sb, indent);
                    sb.append("properties = { ");
                    JAIDebug.appendLineEnd(sb);
                    i = 0;
                    while (i < propertyNames.length) {
                        JAIDebug.appendLineStart(sb, indent + 4);
                        sb.append(propertyNames[i]);
                        sb.append(" = ");
                        Object propertyValue = im.getProperty(propertyNames[i]);
                        if (propertyValue != null) {
                            sb.append(propertyValue.toString());
                        } else {
                            sb.append("(null)");
                        }
                        JAIDebug.appendLineEnd(sb);
                        ++i;
                    }
                    JAIDebug.appendLineStart(sb, indent);
                    sb.append(" }");
                    JAIDebug.appendLineEnd(sb);
                } else {
                    JAIDebug.traceField("properties", null, sb, indent);
                }
            }
            if (im instanceof BufferedImage) {
                BufferedImage bim = (BufferedImage)im;
                JAIDebug.traceObj("raster", bim.getRaster(), traceMask, sb, indent);
            } else {
                JAIDebug.traceObj("sampleModel", im.getSampleModel(), traceMask, sb, indent);
            }
            JAIDebug.traceObj("colorModel", im.getColorModel(), traceMask, sb, indent);
            JAIDebug.traceObjEnd(sb, indent -= 4);
        } else {
            JAIDebug.traceField(label, im, sb, indent);
        }
    }

    private static void traceObj(String label, Raster ras, int traceMask, StringBuffer sb, int indent) {
        if (!JAIDebug.isEnabled()) {
            return;
        }
        if (ras != null) {
            JAIDebug.traceObjStart(label, ras, sb, indent);
            indent += 4;
            if (JAIDebug.isFlagSet(traceMask, 1)) {
                JAIDebug.traceField("width", ras.getWidth(), sb, indent);
                JAIDebug.traceField("height", ras.getHeight(), sb, indent);
                JAIDebug.traceField("numBands", ras.getNumDataElements(), sb, indent);
                JAIDebug.traceField("numDataElements", ras.getNumDataElements(), sb, indent);
                JAIDebug.traceField("transferType", ImageUtils.getDataTypeName(ras.getTransferType()), sb, indent);
            }
            JAIDebug.traceObj("dataBuffer", ras.getDataBuffer(), traceMask, sb, indent);
            JAIDebug.traceObj("sampleModel", ras.getSampleModel(), traceMask, sb, indent);
            JAIDebug.traceObjEnd(sb, indent -= 4);
        } else {
            JAIDebug.traceField(label, ras, sb, indent);
        }
    }

    private static void traceObj(String label, DataBuffer buf, int traceMask, StringBuffer sb, int indent) {
        if (!JAIDebug.isEnabled()) {
            return;
        }
        if (buf != null) {
            JAIDebug.traceObjStart(label, buf, sb, indent);
            indent += 4;
            if (JAIDebug.isFlagSet(traceMask, 1)) {
                JAIDebug.traceField("dataType", ImageUtils.getDataTypeName(buf.getDataType()), sb, indent);
                JAIDebug.traceField("size", buf.getSize(), sb, indent);
                JAIDebug.traceField("numBanks", buf.getNumBanks(), sb, indent);
                JAIDebug.traceField("offsets", buf.getOffsets(), sb, indent);
            }
            JAIDebug.traceObjEnd(sb, indent -= 4);
        } else {
            JAIDebug.traceField(label, buf, sb, indent);
        }
    }

    private static void traceObj(String label, SampleModel sm, int traceMask, StringBuffer sb, int indent) {
        if (!JAIDebug.isEnabled()) {
            return;
        }
        if (sm != null) {
            JAIDebug.traceObjStart(label, sm, sb, indent);
            indent += 4;
            if (JAIDebug.isFlagSet(traceMask, 1)) {
                JAIDebug.traceField("width", sm.getWidth(), sb, indent);
                JAIDebug.traceField("height", sm.getHeight(), sb, indent);
                JAIDebug.traceField("numBands", sm.getNumBands(), sb, indent);
                JAIDebug.traceField("numDataElements", sm.getNumDataElements(), sb, indent);
                JAIDebug.traceField("transferType", ImageUtils.getDataTypeName(sm.getTransferType()), sb, indent);
            }
            JAIDebug.traceObjEnd(sb, indent -= 4);
        } else {
            JAIDebug.traceField(label, sm, sb, indent);
        }
    }

    private static void traceObj(String label, ColorModel cm, int traceMask, StringBuffer sb, int indent) {
        if (!JAIDebug.isEnabled()) {
            return;
        }
        if (cm != null) {
            JAIDebug.traceObjStart(label, cm, sb, indent);
            indent += 4;
            if (JAIDebug.isFlagSet(traceMask, 1)) {
                JAIDebug.traceField("numComponents", cm.getNumComponents(), sb, indent);
                JAIDebug.traceField("numColorComponents", cm.getNumColorComponents(), sb, indent);
            }
            JAIDebug.traceObj("colorSpace", cm.getColorSpace(), traceMask, sb, indent);
            JAIDebug.traceObjEnd(sb, indent -= 4);
        } else {
            JAIDebug.traceField(label, sb, sb, indent);
        }
    }

    private static void traceObj(String label, ColorSpace cs, int traceMask, StringBuffer sb, int indent) {
        if (!JAIDebug.isEnabled()) {
            return;
        }
        if (cs != null) {
            JAIDebug.traceObjStart(label, cs, sb, indent);
            indent += 4;
            if (JAIDebug.isFlagSet(traceMask, 1)) {
                JAIDebug.traceField("type", ImageUtils.getColorSpaceName(cs.getType()), sb, indent);
                JAIDebug.traceField("numComponents", cs.getNumComponents(), sb, indent);
            }
            JAIDebug.traceObjEnd(sb, indent -= 4);
        } else {
            JAIDebug.traceField(label, cs, sb, indent);
        }
    }

    private static void traceObjStart(String label, Object value, StringBuffer sb, int indent) {
        if (!JAIDebug.isEnabled()) {
            return;
        }
        JAIDebug.appendLineStart(sb, indent);
        sb.append("<");
        sb.append(label);
        sb.append("> (class ");
        sb.append(value.getClass().getName());
        sb.append(") = {");
        JAIDebug.appendLineEnd(sb);
    }

    private static void traceObjEnd(StringBuffer sb, int indent) {
        if (!JAIDebug.isEnabled()) {
            return;
        }
        JAIDebug.appendLineStart(sb, indent);
        sb.append('}');
        JAIDebug.appendLineEnd(sb);
    }

    private static void traceField(String name, int value, StringBuffer sb, int indent) {
        if (!JAIDebug.isEnabled()) {
            return;
        }
        JAIDebug.appendLineStart(sb, indent);
        sb.append(name);
        sb.append(" = ");
        sb.append(value);
        JAIDebug.appendLineEnd(sb);
    }

    private static void traceField(String name, String value, StringBuffer sb, int indent) {
        if (!JAIDebug.isEnabled()) {
            return;
        }
        JAIDebug.appendLineStart(sb, indent);
        sb.append(name);
        sb.append(" = ");
        sb.append(value != null ? value : "(null)");
        JAIDebug.appendLineEnd(sb);
    }

    private static void traceField(String name, int[] values, StringBuffer sb, int indent) {
        if (!JAIDebug.isEnabled()) {
            return;
        }
        JAIDebug.appendLineStart(sb, indent);
        sb.append("offsets = { ");
        int i = 0;
        while (i < values.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(values[i]);
            ++i;
        }
        sb.append(" }");
        JAIDebug.appendLineEnd(sb);
    }

    private static void traceField(String name, Object value, StringBuffer sb, int indent) {
        if (!JAIDebug.isEnabled()) {
            return;
        }
        JAIDebug.appendLineStart(sb, indent);
        sb.append(name);
        sb.append(" = ");
        sb.append(value != null ? value.toString() : "(null)");
        JAIDebug.appendLineEnd(sb);
    }

    private static void appendLineStart(StringBuffer sb, int indent) {
        if (!JAIDebug.isEnabled()) {
            return;
        }
        int i = 0;
        while (i < indent) {
            sb.append(' ');
            ++i;
        }
    }

    private static void appendLineEnd(StringBuffer sb) {
        if (!JAIDebug.isEnabled()) {
            return;
        }
        sb.append('\n');
    }

    private static boolean isFlagSet(int mask, int flag) {
        return (mask & flag) != 0;
    }

    private JAIDebug() {
    }
}

