/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResourceScanner {
    private URL[] scanLocations;
    private Map<String, URL> resourcesMap = new HashMap<String, URL>();
    private String relPath;

    public ResourceScanner(URL[] locations, String relPath) {
        this.scanLocations = locations;
        this.relPath = relPath;
    }

    public void scan(ProgressMonitor pm) {
        pm.beginTask("Scanning for resources...", this.scanLocations.length);
        int i = 0;
        while (i < this.scanLocations.length) {
            URL scanLocation = this.scanLocations[i];
            ArrayList<URL> resourceUrls = new ArrayList<URL>();
            ResourceScanner.collectResources(scanLocation, this.relPath, resourceUrls);
            this.resourcesMap.putAll(ResourceScanner.splitResourceUrls(scanLocation, this.relPath, resourceUrls));
            pm.worked(1);
            ++i;
        }
    }

    public URL getResource(String relPath) {
        return this.resourcesMap.get(relPath);
    }

    public String getRelativePath(URL resourceURL) {
        Set<Map.Entry<String, URL>> entries = this.resourcesMap.entrySet();
        for (Map.Entry<String, URL> entry : entries) {
            if (!entry.getValue().equals(resourceURL)) continue;
            return entry.getKey();
        }
        return null;
    }

    public URL[] getResourcesByPattern(String patternString) {
        Pattern pattern = Pattern.compile(patternString);
        ArrayList<URL> resourceUrls = new ArrayList<URL>();
        ResourceScanner.collectMatchingUrls(this.resourcesMap, pattern, resourceUrls);
        return resourceUrls.toArray(new URL[resourceUrls.size()]);
    }

    private static void collectResources(URL location, String relPath, ArrayList<URL> resourceUrls) {
        if (ResourceScanner.isUrlToCompressedFile(location)) {
            ResourceScanner.collectResourcesFromJar(location, relPath, resourceUrls);
        } else {
            ResourceScanner.collectResourcesFromDir(location, relPath, resourceUrls);
        }
    }

    private static void collectMatchingUrls(Map<String, URL> resourcesMap, Pattern pattern, ArrayList<URL> resourceUrls) {
        for (Map.Entry<String, URL> entry : resourcesMap.entrySet()) {
            Matcher matcher = pattern.matcher(entry.getKey());
            if (!matcher.matches()) continue;
            resourceUrls.add(entry.getValue());
        }
    }

    private static Map<String, URL> splitResourceUrls(URL baseLocation, String relPath, Collection<URL> resourceUrls) {
        HashMap<String, URL> resourceMap = new HashMap<String, URL>(200);
        try {
            baseLocation = ResourceScanner.isUrlToCompressedFile(baseLocation) ? new URL("jar:" + baseLocation + "!/" + relPath) : new URL(baseLocation + relPath);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        for (URL url : resourceUrls) {
            String extForm = url.toExternalForm();
            String relResourcePath = extForm.substring(baseLocation.toExternalForm().length());
            resourceMap.put(relResourcePath, url);
        }
        return resourceMap;
    }

    private static void collectResourcesFromJar(URL urlTojar, String relPath, Collection<URL> resourceUrls) {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(new File(urlTojar.toURI()));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        Enumeration<JarEntry> jarEnum = jarFile.entries();
        while (jarEnum.hasMoreElements()) {
            JarEntry jarEntry = jarEnum.nextElement();
            String name = jarEntry.getName();
            if (!name.startsWith(relPath)) continue;
            try {
                URL resourceUrl = new URL("jar:" + urlTojar + "!/" + name);
                resourceUrls.add(resourceUrl);
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static void collectResourcesFromDir(URL baseLocation, String relPath, Collection<URL> resourceUrls) {
        try {
            File auxdataDir = new File(new File(baseLocation.toURI()), relPath);
            ResourceScanner.collectResourcesFromDir(auxdataDir, resourceUrls);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void collectResourcesFromDir(File dir, Collection<URL> resourceUrls) {
        File[] files = dir.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                try {
                    resourceUrls.add(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new IllegalStateException(e);
                }
                if (file.isDirectory()) {
                    ResourceScanner.collectResourcesFromDir(file, resourceUrls);
                }
                ++n2;
            }
        }
    }

    private static boolean isUrlToCompressedFile(URL location) {
        return location.toExternalForm().toLowerCase().endsWith(".jar") || location.toExternalForm().toLowerCase().endsWith(".zip");
    }
}

