/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.jai;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import org.esa.beam.jai.ResolutionLevel;
import org.esa.beam.jai.SingleBandedOpImage;

public class ShapeMaskOpImage
extends SingleBandedOpImage {
    private static final byte FALSE = 0;
    private static final byte TRUE = -1;
    private final Shape shape;
    private final ColorModel colorModel;

    public ShapeMaskOpImage(Shape shape, int width, int height, ResolutionLevel level) {
        super(0, width, height, null, null, level);
        this.shape = AffineTransform.getScaleInstance(1.0 / this.getScale(), 1.0 / this.getScale()).createTransformedShape(shape);
        this.colorModel = PlanarImage.createColorModel(this.getSampleModel());
    }

    public ShapeMaskOpImage(Shape shape, int width, int height, Dimension tileSize, ResolutionLevel level) {
        super(0, width, height, tileSize, null, level);
        this.shape = AffineTransform.getScaleInstance(1.0 / this.getScale(), 1.0 / this.getScale()).createTransformedShape(shape);
        this.colorModel = PlanarImage.createColorModel(this.getSampleModel());
    }

    @Override
    protected void computeRect(PlanarImage[] sourceImages, WritableRaster tile, Rectangle destRect) {
        WritableRaster wrappedTile = RasterFactory.createWritableRaster(tile.getSampleModel(), tile.getDataBuffer(), new Point(0, 0));
        BufferedImage image = new BufferedImage(this.colorModel, wrappedTile, false, null);
        Graphics2D graphics2D = image.createGraphics();
        graphics2D.translate(-tile.getMinX(), -tile.getMinY());
        graphics2D.setColor(Color.WHITE);
        graphics2D.fill(this.shape);
        graphics2D.dispose();
        byte[] data = ((DataBufferByte)tile.getDataBuffer()).getData();
        int i = 0;
        while (i < data.length) {
            data[i] = data[i] != 0 ? -1 : 0;
            ++i;
        }
    }
}

