/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.jai;

import java.awt.Rectangle;
import java.io.IOException;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.jai.RasterDataNodeOpImage;
import org.esa.beam.jai.ResolutionLevel;

public abstract class RasterDataNodeSampleOpImage
extends RasterDataNodeOpImage {
    public RasterDataNodeSampleOpImage(RasterDataNode rasterDataNode, ResolutionLevel level) {
        super(rasterDataNode, level);
    }

    @Override
    protected void computeProductData(ProductData productData, Rectangle destRect) throws IOException {
        int sourceWidth = this.getRasterDataNode().getSceneRasterWidth();
        int sourceHeight = this.getRasterDataNode().getSceneRasterHeight();
        int targetWidth = destRect.width;
        int targetHeight = destRect.height;
        int sourceX0 = this.getSourceX(destRect.x);
        int sourceY0 = this.getSourceY(destRect.y);
        int[] sourceXs = this.getSourceCoords(sourceWidth, targetWidth);
        int[] sourceYs = this.getSourceCoords(sourceHeight, targetHeight);
        int elemIndex = 0;
        int j = 0;
        while (j < targetHeight) {
            int sourceY = sourceY0 + sourceYs[j];
            int i = 0;
            while (i < targetWidth) {
                productData.setElemDoubleAt(elemIndex, this.computeSample(sourceX0 + sourceXs[i], sourceY));
                ++elemIndex;
                ++i;
            }
            ++j;
        }
    }

    protected abstract double computeSample(int var1, int var2);
}

