/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.jai;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.media.jai.PlanarImage;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.jai.ImageManager;
import org.esa.beam.jai.ResolutionLevel;
import org.esa.beam.jai.SingleBandedOpImage;
import org.esa.beam.util.ImageUtils;

public abstract class RasterDataNodeOpImage
extends SingleBandedOpImage {
    private final RasterDataNode rasterDataNode;

    private static Dimension getPreferredTileSize(RasterDataNode rdn) {
        Product product = rdn.getProduct();
        if (product != null && product.getPreferredTileSize() != null) {
            return product.getPreferredTileSize();
        }
        return null;
    }

    protected RasterDataNodeOpImage(RasterDataNode rasterDataNode, ResolutionLevel level) {
        super(ImageManager.getDataBufferType(rasterDataNode.getDataType()), rasterDataNode.getSceneRasterWidth(), rasterDataNode.getSceneRasterHeight(), RasterDataNodeOpImage.getPreferredTileSize(rasterDataNode), null, level);
        this.rasterDataNode = rasterDataNode;
    }

    public RasterDataNode getRasterDataNode() {
        return this.rasterDataNode;
    }

    @Override
    protected void computeRect(PlanarImage[] sourceImages, WritableRaster tile, Rectangle destRect) {
        boolean directMode = tile.getDataBuffer().getSize() == destRect.width * destRect.height;
        ProductData productData = directMode ? ProductData.createInstance(this.rasterDataNode.getDataType(), ImageUtils.getPrimitiveArray(tile.getDataBuffer())) : ProductData.createInstance(this.rasterDataNode.getDataType(), destRect.width * destRect.height);
        try {
            this.computeProductData(productData, destRect);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!directMode) {
            tile.setDataElements(destRect.x, destRect.y, destRect.width, destRect.height, productData.getElems());
        }
    }

    protected abstract void computeProductData(ProductData var1, Rectangle var2) throws IOException;

    @Override
    public String toString() {
        String className = this.getClass().getSimpleName();
        String productName = "";
        if (this.rasterDataNode.getProduct() != null) {
            productName = ":" + this.rasterDataNode.getProduct().getName();
        }
        String bandName = "." + this.rasterDataNode.getName();
        return String.valueOf(className) + productName + bandName;
    }

    protected int[] getSourceCoords(int sourceLength, int targetLength) {
        int[] sourceCoords = new int[targetLength];
        int i = 0;
        while (i < targetLength) {
            sourceCoords[i] = this.getSourceCoord(i, 0, sourceLength - 1);
            ++i;
        }
        return sourceCoords;
    }

    protected static void copyLine(int y, int destWidth, ProductData src, ProductData dest, int[] sourceCoords) {
        int destOffset = y * destWidth;
        int type = src.getType();
        switch (type) {
            case 10: 
            case 20: {
                byte[] srcArrayB = (byte[])src.getElems();
                byte[] destArrayB = (byte[])dest.getElems();
                int[] nArray = sourceCoords;
                int n = sourceCoords.length;
                int n2 = 0;
                while (n2 < n) {
                    int coord = nArray[n2];
                    destArrayB[destOffset++] = srcArrayB[coord];
                    ++n2;
                }
                return;
            }
            case 11: 
            case 21: {
                short[] srcArrayS = (short[])src.getElems();
                short[] destArrayS = (short[])dest.getElems();
                int[] nArray = sourceCoords;
                int n = sourceCoords.length;
                int n3 = 0;
                while (n3 < n) {
                    int coord = nArray[n3];
                    destArrayS[destOffset++] = srcArrayS[coord];
                    ++n3;
                }
                return;
            }
            case 12: 
            case 22: {
                int[] srcArrayI = (int[])src.getElems();
                int[] destArrayI = (int[])dest.getElems();
                int[] nArray = sourceCoords;
                int n = sourceCoords.length;
                int n4 = 0;
                while (n4 < n) {
                    int coord = nArray[n4];
                    destArrayI[destOffset++] = srcArrayI[coord];
                    ++n4;
                }
                return;
            }
            case 30: {
                float[] srcArrayF = (float[])src.getElems();
                float[] destArrayF = (float[])dest.getElems();
                int[] nArray = sourceCoords;
                int n = sourceCoords.length;
                int n5 = 0;
                while (n5 < n) {
                    int coord = nArray[n5];
                    destArrayF[destOffset++] = srcArrayF[coord];
                    ++n5;
                }
                return;
            }
            case 31: {
                double[] srcArrayD = (double[])src.getElems();
                double[] destArrayD = (double[])dest.getElems();
                int[] nArray = sourceCoords;
                int n = sourceCoords.length;
                int n6 = 0;
                while (n6 < n) {
                    int coord = nArray[n6];
                    destArrayD[destOffset++] = srcArrayD[coord];
                    ++n6;
                }
                return;
            }
        }
        throw new IllegalArgumentException("wrong product data type: " + type);
    }
}

