/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.param.validators;

import com.bc.jexp.EvalEnv;
import com.bc.jexp.EvalException;
import com.bc.jexp.Function;
import com.bc.jexp.Namespace;
import com.bc.jexp.ParseException;
import com.bc.jexp.Parser;
import com.bc.jexp.Symbol;
import com.bc.jexp.Term;
import com.bc.jexp.impl.AbstractFunction;
import com.bc.jexp.impl.AbstractSymbol;
import com.bc.jexp.impl.DefaultNamespace;
import com.bc.jexp.impl.ParserImpl;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.param.ParamParseException;
import org.esa.beam.framework.param.ParamProperties;
import org.esa.beam.framework.param.Parameter;
import org.esa.beam.framework.param.validators.StringValidator;
import org.esa.beam.util.Debug;

public abstract class AbstractExpressionValidator
extends StringValidator {
    public static final String PROPERTY_KEY_SELECTED_PRODUCT = "selectedProduct";
    public static final String PROPERTY_KEY_INPUT_PRODUCTS = "inputProducts";
    public static final String PROPERTY_KEY_PREFERENCES = "preferences";

    protected AbstractExpressionValidator() {
    }

    @Override
    public Object parse(Parameter parameter, String text) throws ParamParseException {
        Debug.assertTrue(text != null);
        if (AbstractExpressionValidator.isAllowedNullText(parameter, text)) {
            return null;
        }
        Parser parser = this.getParser(parameter);
        try {
            parser.parse(text);
        }
        catch (ParseException e) {
            throw new ParamParseException(parameter, e.getMessage());
        }
        return text;
    }

    @Override
    public boolean equalValues(Parameter parameter, Object value1, Object value2) {
        return AbstractExpressionValidator.equalValues(false, value1, value2);
    }

    private Parser getParser(Parameter parameter) {
        Parser parser;
        ParamProperties properties = parameter.getProperties();
        Object propertyValue = properties.getPropertyValue(PROPERTY_KEY_SELECTED_PRODUCT);
        if (propertyValue instanceof Product) {
            Product product = (Product)propertyValue;
            parser = product.createBandArithmeticParser();
        } else {
            parser = this.createFallbackParser();
        }
        return parser;
    }

    private ParserImpl createFallbackParser() {
        DummyNamespace fallbackNS = new DummyNamespace();
        DefaultNamespace defaultNS = new DefaultNamespace(fallbackNS);
        return new ParserImpl(defaultNS, false);
    }

    private static class DummyFunction
    extends AbstractFunction.D {
        public DummyFunction(String name, Term[] args) {
            super(name, args.length);
        }

        @Override
        public double evalD(EvalEnv env, Term[] args) throws EvalException {
            return 0.0;
        }
    }

    private static class DummyNamespace
    implements Namespace {
        private DummyNamespace() {
        }

        @Override
        public Symbol resolveSymbol(String name) {
            return new DummySymbol(name);
        }

        @Override
        public Function resolveFunction(String name, Term[] args) {
            return new DummyFunction(name, args);
        }
    }

    private static class DummySymbol
    extends AbstractSymbol {
        public DummySymbol(String name) {
            super(name, 3);
        }

        @Override
        public boolean evalB(EvalEnv env) throws EvalException {
            return false;
        }

        @Override
        public int evalI(EvalEnv env) throws EvalException {
            return 0;
        }

        @Override
        public double evalD(EvalEnv env) throws EvalException {
            return 0.0;
        }

        @Override
        public String evalS(EvalEnv env) throws EvalException {
            return "0";
        }
    }
}

