/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.param.editors;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.esa.beam.framework.param.Parameter;
import org.esa.beam.framework.param.editors.TextFieldXEditor;
import org.esa.beam.util.SystemUtils;
import org.esa.beam.util.io.FileChooserFactory;

public class FileEditor
extends TextFieldXEditor {
    private static final String _FILE_APPROVE_BUTTON_TEXT = "Select File";
    private static final String _DIR_APPROVE_BUTTON_TEXT = "Select Directory";
    private static final String _DEFAULT_APPROVE_BUTTON_TEXT = "Select";

    public FileEditor(Parameter parameter) {
        super(parameter);
        this.updateLastDir();
    }

    @Override
    protected void invokeXEditor() {
        FileFilter current;
        JFileChooser fileChooser;
        File lastDir = this.getLastDir();
        File file = this.getParameterFileValue();
        int fsm = this.getParameter().getProperties().getFileSelectionMode();
        if (fsm == 1) {
            if (file == null) {
                file = lastDir;
            }
            fileChooser = FileChooserFactory.getInstance().createDirChooser(file);
        } else {
            fileChooser = FileChooserFactory.getInstance().createFileChooser(lastDir);
        }
        fileChooser.setFileSelectionMode(fsm);
        if (file != null && file.exists()) {
            fileChooser.setSelectedFile(file);
        }
        fileChooser.setDialogTitle(this.getXEditorTitle());
        FileFilter[] choosable = this.getParameter().getProperties().getChoosableFileFilters();
        if (choosable != null) {
            int i = choosable.length - 1;
            while (i > -1) {
                FileFilter filter = choosable[i];
                fileChooser.addChoosableFileFilter(filter);
                --i;
            }
        }
        if ((current = this.getParameter().getProperties().getCurrentFileFilter()) != null) {
            fileChooser.setFileFilter(current);
        }
        int option = fsm == 0 ? fileChooser.showDialog(this.getEditorComponent(), _FILE_APPROVE_BUTTON_TEXT) : (fsm == 1 ? fileChooser.showDialog(this.getEditorComponent(), _DIR_APPROVE_BUTTON_TEXT) : fileChooser.showDialog(this.getEditorComponent(), _DEFAULT_APPROVE_BUTTON_TEXT));
        this.setLastDir(fileChooser.getCurrentDirectory());
        if (option == 0 && (file = fileChooser.getSelectedFile()) != null) {
            this.setParameterFileValue(file);
        }
    }

    private File getParameterFileValue() {
        return (File)this.getParameter().getValue();
    }

    private void setParameterFileValue(File file) {
        this.getParameter().setValue(file, null);
        this.updateLastDir();
    }

    private void updateLastDir() {
        File parentFile;
        File file = (File)this.getParameter().getValue();
        if (file != null && (parentFile = file.getParentFile()) != null) {
            this.setLastDir(parentFile);
        }
    }

    private File getLastDir() {
        File file;
        File parentDir;
        if (this.getParameter().getValue() instanceof File && (parentDir = (file = (File)this.getParameter().getValue()).getParentFile()) != null && parentDir.isDirectory()) {
            return parentDir;
        }
        return (File)this.getParameter().getProperties().getPropertyValue("lastDir", SystemUtils.getApplicationHomeDir());
    }

    private void setLastDir(File lastDir) {
        this.getParameter().getProperties().setPropertyValue("lastDir", lastDir);
    }
}

