/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.dataop.barithm;

import com.bc.jexp.EvalEnv;
import com.bc.jexp.EvalException;
import com.bc.jexp.Term;
import com.bc.jexp.WritableNamespace;
import com.bc.jexp.impl.AbstractFunction;
import com.bc.jexp.impl.AbstractSymbol;
import com.bc.jexp.impl.SymbolFactory;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Random;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.dataop.barithm.BandArithmetic;
import org.esa.beam.framework.dataop.barithm.RasterDataEvalEnv;
import org.esa.beam.util.ProductUtils;

class MoreFuncs {
    private static final Random RANDOM = new Random();
    public static final GeoPos INVALID_GEO_POS = new GeoPos(Float.NaN, Float.NaN);

    private MoreFuncs() {
    }

    public static void registerExtraFunctions() {
        BandArithmetic.registerFunction(new AbstractFunction.D("random_gaussian", 0){

            @Override
            public double evalD(EvalEnv env, Term[] args) throws EvalException {
                return RANDOM.nextGaussian();
            }
        });
        BandArithmetic.registerFunction(new AbstractFunction.D("random_uniform", 0){

            @Override
            public double evalD(EvalEnv env, Term[] args) throws EvalException {
                return RANDOM.nextDouble();
            }
        });
        BandArithmetic.registerFunction(new AbstractFunction.D("sinh", 1){

            @Override
            public double evalD(EvalEnv env, Term[] args) throws EvalException {
                return Math.sinh(args[0].evalD(env));
            }
        });
        BandArithmetic.registerFunction(new AbstractFunction.D("cosh", 1){

            @Override
            public double evalD(EvalEnv env, Term[] args) throws EvalException {
                return Math.cosh(args[0].evalD(env));
            }
        });
        BandArithmetic.registerFunction(new AbstractFunction.D("tanh", 1){

            @Override
            public double evalD(EvalEnv env, Term[] args) throws EvalException {
                return Math.tanh(args[0].evalD(env));
            }
        });
        BandArithmetic.registerFunction(new AbstractFunction.D("sech", 1){

            @Override
            public double evalD(EvalEnv env, Term[] args) throws EvalException {
                return MoreFuncs.sech(args[0].evalD(env));
            }
        });
        BandArithmetic.registerFunction(new AbstractFunction.D("cosech", 1){

            @Override
            public double evalD(EvalEnv env, Term[] args) throws EvalException {
                return MoreFuncs.cosech(args[0].evalD(env));
            }
        });
    }

    public static void registerExtraSymbols() {
        BandArithmetic.addNamespaceExtender(new BandArithmetic.NamespaceExtender(){

            @Override
            public void extendNamespace(WritableNamespace namespace, Product product, String namePrefix) {
                int numBands = product.getNumBands();
                int i = 0;
                while (i < numBands) {
                    Band band = product.getBandAt(i);
                    MoreFuncs.registerBandProperties(namespace, band);
                    ++i;
                }
            }
        });
        BandArithmetic.addNamespaceExtender(new BandArithmetic.NamespaceExtender(){

            @Override
            public void extendNamespace(WritableNamespace namespace, Product product, String namePrefix) {
                final int width = product.getSceneRasterWidth();
                final int height = product.getSceneRasterHeight();
                final WeakReference<GeoCoding> geocodingRef = new WeakReference<GeoCoding>(product.getGeoCoding());
                AbstractSymbol.D lat = new AbstractSymbol.D("LAT"){

                    @Override
                    public double evalD(EvalEnv env) throws EvalException {
                        GeoPos geoPos;
                        double latitude = Double.NaN;
                        GeoCoding geoCoding = (GeoCoding)geocodingRef.get();
                        if (geoCoding != null && geoCoding.canGetGeoPos() && (geoPos = MoreFuncs.getGeoPos(geoCoding, env, width, height)).isValid()) {
                            latitude = geoPos.getLat();
                        }
                        return latitude;
                    }
                };
                AbstractSymbol.D lon = new AbstractSymbol.D("LON"){

                    @Override
                    public double evalD(EvalEnv env) throws EvalException {
                        GeoPos geoPos;
                        double longitude = Double.NaN;
                        GeoCoding geoCoding = (GeoCoding)geocodingRef.get();
                        if (geoCoding != null && geoCoding.canGetGeoPos() && (geoPos = MoreFuncs.getGeoPos(geoCoding, env, width, height)).isValid()) {
                            longitude = geoPos.getLon();
                        }
                        return longitude;
                    }
                };
                MJD mjd = new MJD(product);
                BandArithmetic.registerSymbol(lat);
                BandArithmetic.registerSymbol(lon);
                BandArithmetic.registerSymbol(mjd);
            }
        });
    }

    private static GeoPos getGeoPos(GeoCoding geoCoding, EvalEnv env, int width, int height) {
        RasterDataEvalEnv rasterEnv = (RasterDataEvalEnv)env;
        int pixelX = rasterEnv.getPixelX();
        int pixelY = rasterEnv.getPixelY();
        if (pixelX >= 0 && pixelX < width && pixelY >= 0 && pixelY < height) {
            return geoCoding.getGeoPos(new PixelPos((float)pixelX + 0.5f, (float)pixelY + 0.5f), null);
        }
        return INVALID_GEO_POS;
    }

    private static void registerBandProperties(WritableNamespace namespace, Band band) {
        Method[] declaredMethods;
        Class<?> bandClass = band.getClass();
        Method[] methodArray = declaredMethods = bandClass.getDeclaredMethods();
        int n = declaredMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            String methodName = method.getName();
            Class<?> methodType = method.getReturnType();
            if (methodType.isPrimitive() && MoreFuncs.hasGetterPrefix(methodName) && method.getParameterTypes().length == 0) {
                Object propertyValue = null;
                try {
                    propertyValue = method.invoke((Object)band, null);
                }
                catch (Throwable throwable) {}
                if (propertyValue != null) {
                    String propertyName = MoreFuncs.convertMethodNameToPropertyName(methodName);
                    String symbolName = String.valueOf(band.getName()) + "." + propertyName;
                    MoreFuncs.registerConstant(namespace, symbolName, propertyValue);
                }
            }
            ++n2;
        }
    }

    private static void registerConstant(WritableNamespace namespace, String symbolName, Object propertyValue) {
        Class<?> getterType = propertyValue.getClass();
        if (getterType.equals(Double.class) || getterType.equals(Float.class)) {
            namespace.registerSymbol(SymbolFactory.createConstant(symbolName, ((Number)propertyValue).doubleValue()));
        } else if (getterType.equals(Byte.class) || getterType.equals(Short.class) || getterType.equals(Integer.class) || getterType.equals(Long.class)) {
            namespace.registerSymbol(SymbolFactory.createConstant(symbolName, ((Number)propertyValue).intValue()));
        } else if (getterType.equals(Boolean.class)) {
            namespace.registerSymbol(SymbolFactory.createConstant(symbolName, (Boolean)propertyValue));
        }
    }

    private static String convertMethodNameToPropertyName(String s) {
        int skipCount = 0;
        if (s.startsWith("is")) {
            skipCount = 2;
        } else if (s.startsWith("get")) {
            skipCount = 3;
        }
        StringBuilder sb = new StringBuilder();
        int n = s.length();
        int i = 0;
        while (i < n) {
            if (i >= skipCount) {
                if (i < n - 1) {
                    char c1 = s.charAt(i);
                    char c2 = s.charAt(i + 1);
                    sb.append(Character.toLowerCase(c1));
                    if (Character.isLowerCase(c1) && Character.isUpperCase(c2)) {
                        sb.append('_');
                    }
                } else {
                    sb.append(Character.toLowerCase(s.charAt(i)));
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private static boolean hasGetterPrefix(String methodName) {
        return MoreFuncs.hasPrefix(methodName, "is") || MoreFuncs.hasPrefix(methodName, "get");
    }

    private static boolean hasPrefix(String methodName, String prefix) {
        return methodName.startsWith(prefix) && methodName.length() > prefix.length();
    }

    private static double sech(double x) {
        return 2.0 / (Math.exp(x) + Math.exp(-x));
    }

    private static double cosech(double x) {
        return 2.0 / (Math.exp(x) - Math.exp(-x));
    }

    static class MJD
    extends AbstractSymbol.D {
        private final Product product;

        public MJD(Product product) {
            super("MJD");
            this.product = product;
        }

        @Override
        public double evalD(EvalEnv env) throws EvalException {
            int pixelY = ((RasterDataEvalEnv)env).getPixelY();
            ProductData.UTC scanLineTime = ProductUtils.getScanLineTime(this.product, pixelY);
            if (scanLineTime != null) {
                return scanLineTime.getMJD();
            }
            return Double.NaN;
        }
    }
}

