/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import com.bc.ceres.core.Assert;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.io.IOException;
import org.esa.beam.framework.datamodel.Mask;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.TransectProfileData;
import org.esa.beam.framework.datamodel.VectorDataNode;
import org.opengis.feature.simple.SimpleFeature;

public class TransectProfileDataBuilder {
    final TransectProfileData.Config config = new TransectProfileData.Config();
    private VectorDataNode pointData;

    public TransectProfileDataBuilder() {
        this.setDefaults();
    }

    public TransectProfileData build() throws IOException {
        this.validate();
        if (this.config.path == null) {
            this.config.path = TransectProfileDataBuilder.createPath(this.pointData);
        }
        return new TransectProfileData(this.config);
    }

    public TransectProfileDataBuilder raster(RasterDataNode raster) {
        Assert.argument(raster.getProduct() != null, "raster.getProduct() != null");
        this.config.raster = raster;
        return this;
    }

    public TransectProfileDataBuilder path(Shape path) {
        this.config.path = path;
        return this;
    }

    public TransectProfileDataBuilder pointData(VectorDataNode pointData) {
        this.pointData = pointData;
        return this;
    }

    public TransectProfileDataBuilder boxSize(int boxSize) {
        this.config.boxSize = boxSize;
        return this;
    }

    public TransectProfileDataBuilder useRoiMask(boolean useRoiMask) {
        this.config.useRoiMask = useRoiMask;
        return this;
    }

    public TransectProfileDataBuilder roiMask(Mask roiMask) {
        this.config.roiMask = roiMask;
        return this;
    }

    public TransectProfileDataBuilder connectVertices(boolean connectVertices) {
        this.config.connectVertices = connectVertices;
        return this;
    }

    private void setDefaults() {
        this.config.boxSize = 1;
        this.config.connectVertices = true;
    }

    private void validate() {
        Assert.state(this.config.raster != null, "raster == null");
        Assert.state(this.config.path != null || this.pointData != null, "path != null || pointData != null");
        Assert.state(this.config.path == null && this.pointData != null || this.config.path != null && this.pointData == null, "path == null && pointData != null || path != null && pointData == null");
    }

    private static Path2D createPath(VectorDataNode pointData) {
        Path2D.Double path = new Path2D.Double();
        SimpleFeature[] simpleFeatures = pointData.getFeatureCollection().toArray(new SimpleFeature[0]);
        int i = 0;
        while (i < simpleFeatures.length) {
            SimpleFeature simpleFeature = simpleFeatures[i];
            Geometry geometry = (Geometry)simpleFeature.getDefaultGeometry();
            Point centroid = geometry.getCentroid();
            if (i == 0) {
                path.moveTo(centroid.getX(), centroid.getY());
            } else {
                path.lineTo(centroid.getX(), centroid.getY());
            }
            ++i;
        }
        return path;
    }
}

