/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import javax.media.jai.UnpackedImageData;
import org.esa.beam.framework.datamodel.StxOp;
import org.esa.beam.util.math.DoubleList;

public final class SummaryStxOp
extends StxOp {
    private double minimum = Double.POSITIVE_INFINITY;
    private double maximum = Double.NEGATIVE_INFINITY;
    private double mean;
    private double meanSqr;
    private long sampleCount;

    public SummaryStxOp() {
        super("Summary");
    }

    public double getMinimum() {
        return this.minimum == Double.POSITIVE_INFINITY ? Double.NaN : this.minimum;
    }

    public double getMaximum() {
        return this.maximum == Double.NEGATIVE_INFINITY ? Double.NaN : this.maximum;
    }

    public double getMean() {
        return this.sampleCount > 0L ? this.mean : Double.NaN;
    }

    public double getStandardDeviation() {
        return this.sampleCount > 0L ? Math.sqrt(this.getVariance()) : Double.NaN;
    }

    public double getVariance() {
        return this.sampleCount > 1L ? this.meanSqr / (double)(this.sampleCount - 1L) : (this.sampleCount == 1L ? 0.0 : Double.NaN);
    }

    @Override
    public void accumulateData(UnpackedImageData dataPixels, UnpackedImageData maskPixels) {
        DoubleList values = StxOp.asDoubleList(dataPixels);
        int dataPixelStride = dataPixels.pixelStride;
        int dataLineStride = dataPixels.lineStride;
        int dataBandOffset = dataPixels.bandOffsets[0];
        byte[] mask = null;
        int maskPixelStride = 0;
        int maskLineStride = 0;
        int maskBandOffset = 0;
        if (maskPixels != null) {
            mask = maskPixels.getByteData(0);
            maskPixelStride = maskPixels.pixelStride;
            maskLineStride = maskPixels.lineStride;
            maskBandOffset = maskPixels.bandOffsets[0];
        }
        int width = dataPixels.rect.width;
        int height = dataPixels.rect.height;
        int dataLineOffset = dataBandOffset;
        int maskLineOffset = maskBandOffset;
        double tileMinimum = this.minimum;
        double tileMaximum = this.maximum;
        long tileSampleCount = this.sampleCount;
        double tileMean = this.mean;
        double tileMeanSqr = this.meanSqr;
        int y = 0;
        while (y < height) {
            int dataPixelOffset = dataLineOffset;
            int maskPixelOffset = maskLineOffset;
            int x = 0;
            while (x < width) {
                if (mask == null || mask[maskPixelOffset] != 0) {
                    ++tileSampleCount;
                    double value = values.getDouble(dataPixelOffset);
                    if (value < tileMinimum) {
                        tileMinimum = value;
                    }
                    if (value > tileMaximum) {
                        tileMaximum = value;
                    }
                    double delta = value - tileMean;
                    tileMeanSqr += delta * (value - (tileMean += delta / (double)tileSampleCount));
                }
                dataPixelOffset += dataPixelStride;
                maskPixelOffset += maskPixelStride;
                ++x;
            }
            dataLineOffset += dataLineStride;
            maskLineOffset += maskLineStride;
            ++y;
        }
        this.minimum = tileMinimum;
        this.maximum = tileMaximum;
        this.sampleCount = tileSampleCount;
        this.mean = tileMean;
        this.meanSqr = tileMeanSqr;
    }
}

