/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import javax.media.jai.UnpackedImageData;
import org.esa.beam.util.math.DoubleList;

abstract class StxOp {
    private final String name;

    protected StxOp(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract void accumulateData(UnpackedImageData var1, UnpackedImageData var2);

    static DoubleList asDoubleList(UnpackedImageData dataPixels) {
        if (dataPixels.type == 0) {
            return new DoubleList.UByte(dataPixels.getByteData(0));
        }
        if (dataPixels.type == 2) {
            return new DoubleList.Short(dataPixels.getShortData(0));
        }
        if (dataPixels.type == 1) {
            return new DoubleList.UShort(dataPixels.getShortData(0));
        }
        if (dataPixels.type == 3) {
            return new DoubleList.Int(dataPixels.getIntData(0));
        }
        if (dataPixels.type == 4) {
            return new DoubleList.Float(dataPixels.getFloatData(0));
        }
        if (dataPixels.type == 5) {
            return new DoubleList.Double(dataPixels.getDoubleData(0));
        }
        return new ZeroDoubleList(dataPixels.rect.width * dataPixels.rect.height);
    }

    static final class ZeroDoubleList
    implements DoubleList {
        private final int size;

        public ZeroDoubleList(int size) {
            this.size = size;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public double getDouble(int index) {
            return 0.0;
        }
    }
}

