/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import org.esa.beam.framework.dataio.ProductSubsetDef;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.ProductVisitor;
import org.opengis.feature.simple.SimpleFeature;

class SimpleFeatureNode
extends ProductNode {
    private static final String PROPERTY_NAME_SIMPLE_FEATURE = "simpleFeature";
    private final SimpleFeature simpleFeature;

    SimpleFeatureNode(SimpleFeature simpleFeature) {
        this(simpleFeature, null);
    }

    SimpleFeatureNode(SimpleFeature simpleFeature, String description) {
        super(simpleFeature.getID(), description);
        this.simpleFeature = simpleFeature;
    }

    public SimpleFeature getSimpleFeature() {
        return this.simpleFeature;
    }

    @Override
    public long getRawStorageSize(ProductSubsetDef subsetDef) {
        return this.getDescription().length();
    }

    @Override
    public void acceptVisitor(ProductVisitor visitor) {
    }

    public final Object getSimpleFeatureAttribute(String name) {
        return this.simpleFeature.getAttribute(name);
    }

    public final void setSimpleFeatureAttribute(String name, Object value) {
        Object oldValue = this.getSimpleFeatureAttribute(name);
        if (!SimpleFeatureNode.equals(oldValue, value)) {
            this.simpleFeature.setAttribute(name, value);
            this.fireProductNodeChanged(name, oldValue, value);
        }
    }

    public final void setDefaultGeometry(Object geometry) {
        this.setSimpleFeatureAttribute(this.simpleFeature.getFeatureType().getGeometryDescriptor().getLocalName(), geometry);
    }

    public final Object getDefaultGeometry() {
        return this.simpleFeature.getDefaultGeometry();
    }

    public void fireSimpleFeatureChanged() {
        this.fireProductNodeChanged(PROPERTY_NAME_SIMPLE_FEATURE);
    }

    private static boolean equals(Object value, Object other) {
        return value == other || value != null && value.equals(other);
    }
}

