/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import java.text.ParseException;
import org.esa.beam.framework.dataio.ProductSubsetDef;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.ProductNodeGroup;
import org.esa.beam.framework.datamodel.ProductVisitor;
import org.esa.beam.util.Guardian;

public class MetadataElement
extends ProductNode {
    private ProductNodeGroup<MetadataElement> elements;
    private ProductNodeGroup<MetadataAttribute> attributes;

    public MetadataElement(String name) {
        super(name);
    }

    public ProductNodeGroup<MetadataElement> getElementGroup() {
        return this.elements != null ? this.elements : null;
    }

    public MetadataElement getParentElement() {
        return MetadataElement.getParentElement(this);
    }

    public void addElement(MetadataElement element) {
        if (element == null) {
            return;
        }
        if (this.elements == null) {
            this.elements = new ProductNodeGroup(this, "elements", true);
        }
        this.elements.add(element);
    }

    public void addElementAt(MetadataElement element, int index) {
        if (element == null) {
            return;
        }
        if (this.elements == null) {
            this.elements = new ProductNodeGroup(this, "elements", true);
        }
        this.elements.add(index, element);
    }

    public boolean removeElement(MetadataElement element) {
        return element != null && this.elements != null && this.elements.remove(element);
    }

    public int getNumElements() {
        if (this.elements == null) {
            return 0;
        }
        return this.elements.getNodeCount();
    }

    public MetadataElement getElementAt(int index) {
        if (this.elements == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.elements.get(index);
    }

    public String[] getElementNames() {
        if (this.elements == null) {
            return new String[0];
        }
        return this.elements.getNodeNames();
    }

    public MetadataElement[] getElements() {
        if (this.elements == null) {
            return new MetadataElement[0];
        }
        return (MetadataElement[])this.elements.toArray(new MetadataElement[0]);
    }

    public MetadataElement getElement(String name) {
        Guardian.assertNotNullOrEmpty("name", name);
        if (this.elements == null) {
            return null;
        }
        return this.elements.get(name);
    }

    public boolean containsElement(String name) {
        Guardian.assertNotNullOrEmpty("name", name);
        return this.elements != null && this.elements.contains(name);
    }

    public int getElementIndex(MetadataElement element) {
        return this.elements.indexOf(element);
    }

    public void addAttribute(MetadataAttribute attribute) {
        if (attribute == null) {
            return;
        }
        if (this.attributes == null) {
            this.attributes = new ProductNodeGroup(this, "attributes", true);
        }
        this.attributes.add(attribute);
    }

    public boolean removeAttribute(MetadataAttribute attribute) {
        return attribute != null && this.attributes != null && this.attributes.remove(attribute);
    }

    public int getNumAttributes() {
        if (this.attributes == null) {
            return 0;
        }
        return this.attributes.getNodeCount();
    }

    public MetadataAttribute getAttributeAt(int index) {
        if (this.attributes == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.attributes.get(index);
    }

    public String[] getAttributeNames() {
        if (this.attributes == null) {
            return new String[0];
        }
        return this.attributes.getNodeNames();
    }

    public MetadataAttribute[] getAttributes() {
        if (this.attributes == null) {
            return new MetadataAttribute[0];
        }
        return (MetadataAttribute[])this.attributes.toArray(new MetadataAttribute[this.attributes.getNodeCount()]);
    }

    public MetadataAttribute getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    public boolean containsAttribute(String name) {
        return this.attributes != null && this.attributes.contains(name);
    }

    public int getAttributeIndex(MetadataAttribute attribute) {
        return this.attributes.indexOf(attribute);
    }

    public double getAttributeDouble(String name, double defaultValue) {
        MetadataAttribute attribute = this.getAttribute(name);
        if (attribute == null) {
            return defaultValue;
        }
        if (attribute.getDataType() == 41) {
            return Double.parseDouble(attribute.getData().getElemString());
        }
        return attribute.getData().getElemDouble();
    }

    public double getAttributeDouble(String name) {
        MetadataAttribute attribute = this.getAttribute(name);
        if (attribute == null) {
            throw new IllegalArgumentException(MetadataElement.getAttributeNotFoundMessage(name));
        }
        if (attribute.getDataType() == 41) {
            return Double.parseDouble(attribute.getData().getElemString());
        }
        return attribute.getData().getElemDouble();
    }

    public ProductData.UTC getAttributeUTC(String name, ProductData.UTC defaultValue) {
        try {
            MetadataAttribute attribute = this.getAttribute(name);
            if (attribute != null) {
                return ProductData.UTC.parse(attribute.getData().getElemString());
            }
        }
        catch (ParseException parseException) {}
        return defaultValue;
    }

    public ProductData.UTC getAttributeUTC(String name) {
        try {
            MetadataAttribute attribute = this.getAttribute(name);
            if (attribute != null) {
                return ProductData.UTC.parse(attribute.getData().getElemString());
            }
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Unable to parse metadata attribute " + name);
        }
        throw new IllegalArgumentException(MetadataElement.getAttributeNotFoundMessage(name));
    }

    public int getAttributeInt(String name, int defaultValue) {
        MetadataAttribute attribute = this.getAttribute(name);
        if (attribute == null) {
            return defaultValue;
        }
        if (attribute.getDataType() == 41) {
            return Integer.parseInt(attribute.getData().getElemString());
        }
        return attribute.getData().getElemInt();
    }

    public int getAttributeInt(String name) {
        MetadataAttribute attribute = this.getAttribute(name);
        if (attribute == null) {
            throw new IllegalArgumentException(MetadataElement.getAttributeNotFoundMessage(name));
        }
        if (attribute.getDataType() == 41) {
            return Integer.parseInt(attribute.getData().getElemString());
        }
        return attribute.getData().getElemInt();
    }

    public void setAttributeInt(String name, int value) {
        MetadataAttribute attribute = this.getAndMaybeCreateAttribute(name, 12, 1);
        attribute.getData().setElemInt(value);
        attribute.fireProductNodeDataChanged();
        this.setModified(true);
    }

    public void setAttributeDouble(String name, double value) {
        MetadataAttribute attribute = this.getAndMaybeCreateAttribute(name, 31, 1);
        attribute.getData().setElemDouble(value);
        attribute.fireProductNodeDataChanged();
        this.setModified(true);
    }

    public void setAttributeUTC(String name, ProductData.UTC value) {
        MetadataAttribute attribute = this.getAndMaybeCreateAttribute(name, 51, 1);
        attribute.getData().setElems(value.getArray());
        attribute.fireProductNodeDataChanged();
        this.setModified(true);
    }

    public String getAttributeString(String name) {
        MetadataAttribute attribute = this.getAttribute(name);
        if (attribute == null) {
            throw new IllegalArgumentException(MetadataElement.getAttributeNotFoundMessage(name));
        }
        return attribute.getData().getElemString();
    }

    public String getAttributeString(String name, String defaultValue) {
        MetadataAttribute attribute = this.getAttribute(name);
        if (attribute == null) {
            return defaultValue;
        }
        return attribute.getData().getElemString();
    }

    public void setAttributeString(String name, String value) {
        MetadataAttribute attribute = this.getAndMaybeCreateAttribute(name, 41, 1);
        attribute.getData().setElems(value);
        attribute.fireProductNodeDataChanged();
        this.setModified(true);
    }

    @Override
    public void setModified(boolean modified) {
        boolean oldState = this.isModified();
        if (oldState != modified) {
            if (!modified) {
                if (this.elements != null) {
                    this.elements.setModified(false);
                }
                if (this.attributes != null) {
                    this.attributes.setModified(false);
                }
            }
            super.setModified(modified);
        }
    }

    @Override
    public void acceptVisitor(ProductVisitor visitor) {
        Guardian.assertNotNull("visitor", visitor);
        int i = 0;
        while (i < this.getNumElements()) {
            this.getElementAt(i).acceptVisitor(visitor);
            ++i;
        }
        i = 0;
        while (i < this.getNumAttributes()) {
            this.getAttributeAt(i).acceptVisitor(visitor);
            ++i;
        }
        visitor.visit(this);
    }

    private MetadataAttribute getAndMaybeCreateAttribute(String name, int type, int numElems) {
        MetadataAttribute attribute = this.getAttribute(name);
        if (attribute == null) {
            attribute = new MetadataAttribute(name, type, numElems);
            this.addAttribute(attribute);
        }
        return attribute;
    }

    @Override
    public long getRawStorageSize(ProductSubsetDef subsetDef) {
        if (subsetDef != null && !subsetDef.containsNodeName(this.getName())) {
            return 0L;
        }
        long size = 0L;
        int i = 0;
        while (i < this.getNumElements()) {
            size += this.getElementAt(i).getRawStorageSize(subsetDef);
            ++i;
        }
        i = 0;
        while (i < this.getNumAttributes()) {
            size += this.getAttributeAt(i).getRawStorageSize(subsetDef);
            ++i;
        }
        return size;
    }

    public MetadataElement createDeepClone() {
        MetadataElement[] elements;
        MetadataAttribute[] attributes;
        MetadataElement clone = new MetadataElement(this.getName());
        clone.setDescription(this.getDescription());
        MetadataAttribute[] metadataAttributeArray = attributes = this.getAttributes();
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            MetadataAttribute attribute = metadataAttributeArray[n2];
            clone.addAttribute(attribute.createDeepClone());
            ++n2;
        }
        MetadataElement[] metadataElementArray = elements = this.getElements();
        int n3 = elements.length;
        n = 0;
        while (n < n3) {
            MetadataElement element = metadataElementArray[n];
            clone.addElement(element.createDeepClone());
            ++n;
        }
        return clone;
    }

    @Override
    public void dispose() {
        if (this.attributes != null) {
            this.attributes.dispose();
            this.attributes = null;
        }
        if (this.elements != null) {
            this.elements.dispose();
            this.elements = null;
        }
        super.dispose();
    }

    static MetadataElement getParentElement(ProductNode node) {
        node = node.getOwner();
        while (node != null) {
            if (node instanceof MetadataElement) {
                return (MetadataElement)node;
            }
            node = node.getOwner();
        }
        return null;
    }

    private static String getAttributeNotFoundMessage(String name) {
        return "Metadata attribute '" + name + "' not found";
    }
}

