/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import org.esa.beam.framework.datamodel.ColorPaletteDef;
import org.esa.beam.framework.datamodel.ImageInfo;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.jai.ImageManager;
import org.esa.beam.util.StringUtils;
import org.esa.beam.util.math.MathUtils;

public class ImageLegend {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private static final int GAP = 10;
    private static final int LABEL_GAP = 12;
    private static final int SLIDER_WIDTH = 10;
    private static final int SLIDER_HEIGHT = 14;
    private static final int MIN_PALETTE_WIDTH = 256;
    private static final int MIN_PALETTE_HEIGHT = 32;
    private static final int MIN_LEGEND_WIDTH = 320;
    private static final int MIN_LEGEND_HEIGHT = 48;
    private static final Font _DEFAULT_FONT = new Font("Arial", 1, 14);
    private final ImageInfo imageInfo;
    private final RasterDataNode raster;
    private boolean usingHeader;
    private String headerText;
    private int orientation;
    private Font font;
    private Color foregroundColor;
    private Color backgroundColor;
    private boolean backgroundTransparencyEnabled;
    private float backgroundTransparency;
    private boolean antialiasing;
    private Rectangle paletteRect;
    private Dimension legendSize;
    private Shape sliderShape;
    private String[] labels;
    private int[] labelWidths;
    private int palettePos1;
    private int palettePos2;

    public ImageLegend(ImageInfo imageInfo, RasterDataNode raster) {
        this.imageInfo = imageInfo;
        this.raster = raster;
        this.usingHeader = true;
        this.headerText = "";
        this.orientation = 0;
        this.font = _DEFAULT_FONT;
        this.antialiasing = false;
        this.backgroundColor = Color.white;
        this.foregroundColor = Color.black;
        this.backgroundTransparency = 0.0f;
    }

    public ImageInfo getImageInfo() {
        return this.imageInfo;
    }

    public RasterDataNode getRaster() {
        return this.raster;
    }

    public boolean isUsingHeader() {
        return this.usingHeader;
    }

    public void setUsingHeader(boolean usingHeader) {
        this.usingHeader = usingHeader;
    }

    public String getHeaderText() {
        return this.headerText;
    }

    public void setHeaderText(String headerText) {
        this.headerText = headerText;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public boolean isAntialiasing() {
        return this.antialiasing;
    }

    public void setAntialiasing(boolean antialiasing) {
        this.antialiasing = antialiasing;
    }

    public boolean isBackgroundTransparencyEnabled() {
        return this.backgroundTransparencyEnabled;
    }

    public void setBackgroundTransparencyEnabled(boolean backgroundTransparencyEnabled) {
        this.backgroundTransparencyEnabled = backgroundTransparencyEnabled;
    }

    public float getBackgroundTransparency() {
        return this.backgroundTransparency;
    }

    public void setBackgroundTransparency(float backgroundTransparency) {
        this.backgroundTransparency = backgroundTransparency;
    }

    public boolean isAlphaUsed() {
        return this.backgroundTransparencyEnabled && this.backgroundTransparency > 0.0f && this.backgroundTransparency <= 1.0f;
    }

    public int getBackgroundAlpha() {
        return this.isAlphaUsed() ? Math.round(255.0f * (1.0f - this.backgroundTransparency)) : 255;
    }

    public BufferedImage createImage() {
        this.initDrawing();
        BufferedImage bi = this.createBufferedImage(this.legendSize.width, this.legendSize.height);
        Graphics2D g2d = bi.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        if (this.antialiasing) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        if (this.font != null) {
            g2d.setFont(this.font);
        }
        this.draw(g2d);
        return bi;
    }

    private void initDrawing() {
        FontMetrics fontMetrics = this.createFontMetrics();
        int n = this.getNumGradationCurvePoints();
        this.labels = new String[n];
        this.labelWidths = new int[n];
        int textHeight = fontMetrics.getHeight();
        double minValue = this.imageInfo.getColorPaletteDef().getMinDisplaySample();
        double maxValue = this.imageInfo.getColorPaletteDef().getMaxDisplaySample();
        double roundFactor = MathUtils.computeRoundFactor(minValue, maxValue, 2);
        int i = 0;
        while (i < n) {
            ColorPaletteDef.Point slider = this.getGradationCurvePointAt(i);
            this.labels[i] = String.valueOf(MathUtils.round(slider.getSample(), roundFactor));
            this.labelWidths[i] = fontMetrics.stringWidth(this.labels[i]);
            ++i;
        }
        int headerTextVSpace = 0;
        int headerTextWidth = 0;
        if (this.hasHeaderText()) {
            headerTextVSpace = textHeight + 10;
            headerTextWidth = fontMetrics.stringWidth(this.headerText);
        }
        int legendWidth = 0;
        int legendHeight = 0;
        int maxLabelWidth = 0;
        int i2 = 0;
        while (i2 < n) {
            legendWidth += 12 + this.labelWidths[i2];
            legendHeight += 2 * textHeight;
            maxLabelWidth = Math.max(this.labelWidths[i2], maxLabelWidth);
            ++i2;
        }
        if (this.orientation == 0) {
            legendWidth = Math.max(legendWidth, 32);
            legendWidth = 10 + Math.max(legendWidth, headerTextWidth) + 10;
            legendHeight = 10 + headerTextVSpace + 32 + 12 + textHeight + 10;
            legendWidth = Math.max(320, ImageLegend.adjust(legendWidth, 16));
            legendHeight = Math.max(48, ImageLegend.adjust(legendHeight, 16));
        } else {
            legendWidth = 44 + maxLabelWidth;
            legendWidth = 10 + Math.max(legendWidth, headerTextWidth) + 10;
            legendHeight = 10 + headerTextVSpace + Math.max(legendHeight, 256) + 12 + textHeight + 10;
            legendWidth = Math.max(48, ImageLegend.adjust(legendWidth, 16));
            legendHeight = Math.max(320, ImageLegend.adjust(legendHeight, 16));
        }
        this.legendSize = new Dimension(legendWidth, legendHeight);
        int headerTextSpace = this.headerText != null ? textHeight + 10 : 0;
        int labelTextSpace = 12 + textHeight;
        if (this.orientation == 0) {
            this.paletteRect = new Rectangle(10, 10 + headerTextSpace, this.legendSize.width - 20, this.legendSize.height - (10 + headerTextSpace + labelTextSpace + 10));
            int paletteGap = Math.max(this.labelWidths[0], this.labelWidths[n - 1]) / 2;
            this.palettePos1 = this.paletteRect.x + paletteGap;
            this.palettePos2 = this.paletteRect.x + this.paletteRect.width - paletteGap;
        } else {
            this.paletteRect = new Rectangle(10, 10 + headerTextSpace, this.legendSize.width - (10 + labelTextSpace + maxLabelWidth + 10), this.legendSize.height - (10 + headerTextSpace + 10));
            int paletteGap = Math.max(textHeight, 10) / 2;
            this.palettePos1 = this.paletteRect.y + paletteGap;
            this.palettePos2 = this.paletteRect.y + this.paletteRect.height - paletteGap;
        }
        this.sliderShape = this.createSliderShape();
    }

    private boolean hasHeaderText() {
        return this.usingHeader && StringUtils.isNotNullAndNotEmpty(this.headerText);
    }

    private void draw(Graphics2D g2d) {
        this.fillBackground(g2d);
        this.drawHeaderText(g2d);
        this.drawPalette(g2d);
        this.drawLabels(g2d);
    }

    private void fillBackground(Graphics2D g2d) {
        Color c = this.backgroundColor;
        if (this.isAlphaUsed()) {
            c = new Color(c.getRed(), c.getGreen(), c.getBlue(), this.getBackgroundAlpha());
        }
        g2d.setColor(c);
        g2d.fillRect(0, 0, this.legendSize.width + 1, this.legendSize.height + 1);
    }

    private void drawHeaderText(Graphics2D g2d) {
        if (this.hasHeaderText()) {
            FontMetrics fontMetrics = g2d.getFontMetrics();
            g2d.setPaint(this.foregroundColor);
            int x0 = 10;
            int y0 = 10 + fontMetrics.getMaxAscent();
            g2d.drawString(this.headerText, x0, y0);
        }
    }

    private void drawPalette(Graphics2D g2d) {
        int i2;
        int i1;
        Color[] palette = ImageManager.createColorPalette(this.getRaster().getImageInfo());
        int x1 = this.paletteRect.x;
        int x2 = this.paletteRect.x + this.paletteRect.width;
        int y1 = this.paletteRect.y;
        int y2 = this.paletteRect.y + this.paletteRect.height;
        if (this.orientation == 0) {
            i1 = x1;
            i2 = x2;
        } else {
            i1 = y1;
            i2 = y2;
        }
        g2d.setStroke(new BasicStroke(1.0f));
        int i = i1;
        while (i < i2) {
            int divisor = this.palettePos2 - this.palettePos1;
            int palIndex = divisor == 0 ? (i < this.palettePos1 ? 0 : palette.length - 1) : palette.length * (i - this.palettePos1) / divisor;
            if (palIndex < 0) {
                palIndex = 0;
            }
            if (palIndex > palette.length - 1) {
                palIndex = palette.length - 1;
            }
            g2d.setColor(palette[palIndex]);
            if (this.orientation == 0) {
                g2d.drawLine(i, y1, i, y2);
            } else {
                g2d.drawLine(x1, i, x2, i);
            }
            ++i;
        }
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.setColor(this.foregroundColor);
        g2d.draw(this.paletteRect);
    }

    private void drawLabels(Graphics2D g2d) {
        FontMetrics fontMetrics = g2d.getFontMetrics();
        int n = this.getNumGradationCurvePoints();
        g2d.setStroke(new BasicStroke(2.0f));
        Color c1 = (this.foregroundColor != null ? this.foregroundColor : Color.black).brighter();
        Color c2 = (this.backgroundColor != null ? this.backgroundColor : Color.white).darker();
        int i = 0;
        while (i < n) {
            float y0;
            float x0;
            double ty;
            double tx;
            ColorPaletteDef.Point slider = this.getGradationCurvePointAt(i);
            double normalizedSample = this.normalizeSample(slider.getSample());
            double sliderPos = normalizedSample * (double)(this.palettePos2 - this.palettePos1);
            if (this.orientation == 0) {
                tx = (double)this.palettePos1 + sliderPos;
                ty = this.paletteRect.y + this.paletteRect.height;
            } else {
                tx = this.paletteRect.x + this.paletteRect.width;
                ty = (double)this.palettePos1 + sliderPos;
            }
            g2d.translate(tx, ty);
            g2d.setPaint(slider.getColor());
            g2d.fill(this.sliderShape);
            int gray = (slider.getColor().getRed() + slider.getColor().getGreen() + slider.getColor().getBlue()) / 3;
            g2d.setColor(gray < 128 ? c2 : c1);
            g2d.draw(this.sliderShape);
            if (this.orientation == 0) {
                x0 = -0.5f * (float)this.labelWidths[i];
                y0 = 12 + fontMetrics.getMaxAscent();
            } else {
                x0 = 12.0f;
                y0 = fontMetrics.getMaxAscent();
            }
            g2d.setPaint(this.foregroundColor);
            g2d.drawString(this.labels[i], x0, y0);
            g2d.translate(-tx, -ty);
            ++i;
        }
    }

    private double normalizeSample(double sample) {
        double delta;
        double minDisplaySample = this.getImageInfo().getColorPaletteDef().getMinDisplaySample();
        double maxDisplaySample = this.getImageInfo().getColorPaletteDef().getMaxDisplaySample();
        if (this.imageInfo.isLogScaled()) {
            minDisplaySample = Math.log10(this.imageInfo.getColorPaletteDef().getMinDisplaySample());
            maxDisplaySample = Math.log10(this.imageInfo.getColorPaletteDef().getMaxDisplaySample());
            sample = Math.log10(sample);
        }
        if ((delta = maxDisplaySample - minDisplaySample) == 0.0 || Double.isNaN(delta)) {
            delta = 1.0;
        }
        return (sample - minDisplaySample) / delta;
    }

    private Shape createSliderShape() {
        GeneralPath path = new GeneralPath();
        if (this.orientation == 0) {
            path.moveTo(0.0f, -7.0f);
            path.lineTo(5.0f, 7.0f);
            path.lineTo(-5.0f, 7.0f);
        } else {
            path.moveTo(-7.0f, 0.0f);
            path.lineTo(7.0f, 5.0f);
            path.lineTo(7.0f, -5.0f);
        }
        path.closePath();
        return path;
    }

    private int getNumGradationCurvePoints() {
        return this.getImageInfo().getColorPaletteDef().getNumPoints();
    }

    private ColorPaletteDef.Point getGradationCurvePointAt(int index) {
        return this.getImageInfo().getColorPaletteDef().getPointAt(index);
    }

    private static int adjust(int size, int blockSize) {
        return blockSize * (size / blockSize) + (size % blockSize == 0 ? 0 : blockSize);
    }

    private FontMetrics createFontMetrics() {
        BufferedImage bi = this.createBufferedImage(32, 32);
        Graphics2D g2d = bi.createGraphics();
        if (this.font != null) {
            g2d.setFont(this.font);
        }
        FontMetrics fontMetrics = g2d.getFontMetrics();
        g2d.dispose();
        return fontMetrics;
    }

    private BufferedImage createBufferedImage(int width, int height) {
        return new BufferedImage(width, height, this.isAlphaUsed() ? 2 : 1);
    }
}

